# pulp_ansible-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.14.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_ansible
from pulpcore.client.pulp_ansible.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_ansible.Configuration(
    host = "https://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_ansible.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_ansible.Configuration(
    host = "https://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_ansible.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_ansible.AnsibleCollectionsApi(api_client)
    limit = 56 # int | Number of results to return per page. (optional)
name = 'name_example' # str |  (optional)
namespace = 'namespace_example' # str |  (optional)
offset = 56 # int | The initial index from which to return the results. (optional)
ordering = ['ordering_example'] # list[str] | Ordering (optional)
fields = 'fields_example' # str | A list of fields to include in the response. (optional)
exclude_fields = 'exclude_fields_example' # str | A list of fields to exclude from the response. (optional)

    try:
        # List collections
        api_response = api_instance.list(limit=limit, name=name, namespace=namespace, offset=offset, ordering=ordering, fields=fields, exclude_fields=exclude_fields)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnsibleCollectionsApi->list: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnsibleCollectionsApi* | [**list**](docs/AnsibleCollectionsApi.md#list) | **GET** /pulp/api/v3/ansible/collections/ | List collections
*AnsibleCollectionsApi* | [**upload_collection**](docs/AnsibleCollectionsApi.md#upload_collection) | **POST** /ansible/collections/ | Upload a collection
*AnsibleCopyApi* | [**copy_content**](docs/AnsibleCopyApi.md#copy_content) | **POST** /pulp/api/v3/ansible/copy/ | Copy content
*ApiCollectionsApi* | [**get**](docs/ApiCollectionsApi.md#get) | **GET** {ansible_collection_href}api/v2/collections/ | 
*ApiCollectionsApi* | [**post**](docs/ApiCollectionsApi.md#post) | **POST** {ansible_collection_href}api/v2/collections/ | 
*ApiRolesApi* | [**get**](docs/ApiRolesApi.md#get) | **GET** {ansible_role_href}api/v1/roles/ | 
*CollectionImportApi* | [**read**](docs/CollectionImportApi.md#read) | **GET** {ansible_collection_import_href} | Inspect a collection import
*ContentCollectionDeprecationsApi* | [**create**](docs/ContentCollectionDeprecationsApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_deprecations/ | Create an ansible collection deprecated
*ContentCollectionDeprecationsApi* | [**list**](docs/ContentCollectionDeprecationsApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_deprecations/ | List ansible collection deprecateds
*ContentCollectionDeprecationsApi* | [**read**](docs/ContentCollectionDeprecationsApi.md#read) | **GET** {ansible_ansible_collection_deprecated_href} | Inspect an ansible collection deprecated
*ContentCollectionSignaturesApi* | [**create**](docs/ContentCollectionSignaturesApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_signatures/ | Create a collection version signature
*ContentCollectionSignaturesApi* | [**list**](docs/ContentCollectionSignaturesApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_signatures/ | List collection version signatures
*ContentCollectionSignaturesApi* | [**read**](docs/ContentCollectionSignaturesApi.md#read) | **GET** {ansible_collection_version_signature_href} | Inspect a collection version signature
*ContentCollectionVersionsApi* | [**create**](docs/ContentCollectionVersionsApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_versions/ | Create a collection version
*ContentCollectionVersionsApi* | [**list**](docs/ContentCollectionVersionsApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_versions/ | List collection versions
*ContentCollectionVersionsApi* | [**read**](docs/ContentCollectionVersionsApi.md#read) | **GET** {ansible_collection_version_href} | Inspect a collection version
*ContentRolesApi* | [**create**](docs/ContentRolesApi.md#create) | **POST** /pulp/api/v3/content/ansible/roles/ | Create a role
*ContentRolesApi* | [**list**](docs/ContentRolesApi.md#list) | **GET** /pulp/api/v3/content/ansible/roles/ | List roles
*ContentRolesApi* | [**read**](docs/ContentRolesApi.md#read) | **GET** {ansible_role_href} | Inspect a role
*DistributionsAnsibleApi* | [**create**](docs/DistributionsAnsibleApi.md#create) | **POST** /pulp/api/v3/distributions/ansible/ansible/ | Create an ansible distribution
*DistributionsAnsibleApi* | [**delete**](docs/DistributionsAnsibleApi.md#delete) | **DELETE** {ansible_ansible_distribution_href} | Delete an ansible distribution
*DistributionsAnsibleApi* | [**list**](docs/DistributionsAnsibleApi.md#list) | **GET** /pulp/api/v3/distributions/ansible/ansible/ | List ansible distributions
*DistributionsAnsibleApi* | [**partial_update**](docs/DistributionsAnsibleApi.md#partial_update) | **PATCH** {ansible_ansible_distribution_href} | Update an ansible distribution
*DistributionsAnsibleApi* | [**read**](docs/DistributionsAnsibleApi.md#read) | **GET** {ansible_ansible_distribution_href} | Inspect an ansible distribution
*DistributionsAnsibleApi* | [**update**](docs/DistributionsAnsibleApi.md#update) | **PUT** {ansible_ansible_distribution_href} | Update an ansible distribution
*GalaxyDetailApi* | [**get**](docs/GalaxyDetailApi.md#get) | **GET** {ansible_collection_href} | 
*PulpAnsibleApiApi* | [**get**](docs/PulpAnsibleApiApi.md#get) | **GET** /pulp_ansible/galaxy/{path}/api/ | 
*PulpAnsibleApiV2CollectionsVersionsApi* | [**get**](docs/PulpAnsibleApiV2CollectionsVersionsApi.md#get) | **GET** /pulp_ansible/galaxy/{path}/api/v2/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3Api* | [**read**](docs/PulpAnsibleApiV3Api.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/ | 
*PulpAnsibleApiV3ArtifactsCollectionsApi* | [**get**](docs/PulpAnsibleApiV3ArtifactsCollectionsApi.md#get) | **GET** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/{path}/{filename} | 
*PulpAnsibleApiV3CollectionVersionsAllApi* | [**list**](docs/PulpAnsibleApiV3CollectionVersionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collection_versions/all/ | 
*PulpAnsibleApiV3CollectionsApi* | [**delete**](docs/PulpAnsibleApiV3CollectionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsApi* | [**list**](docs/PulpAnsibleApiV3CollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/ | 
*PulpAnsibleApiV3CollectionsApi* | [**read**](docs/PulpAnsibleApiV3CollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsApi* | [**update**](docs/PulpAnsibleApiV3CollectionsApi.md#update) | **PATCH** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsAllApi* | [**list**](docs/PulpAnsibleApiV3CollectionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/all/ | 
*PulpAnsibleApiV3CollectionsVersionsApi* | [**delete**](docs/PulpAnsibleApiV3CollectionsVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3CollectionsVersionsApi* | [**list**](docs/PulpAnsibleApiV3CollectionsVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleApiV3CollectionsVersionsApi* | [**read**](docs/PulpAnsibleApiV3CollectionsVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3CollectionsVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleApiV3CollectionsVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-versions/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsApi* | [**download**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsApi.md#download) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/{filename} | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**delete**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**update**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#update) | **PATCH** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**delete**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleArtifactsCollectionsV3Api* | [**create**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create) | **POST** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3Api* | [**create_0**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create_0) | **POST** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3Api* | [**create_1**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create_1) | **POST** /pulp_ansible/galaxy/default/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3Api* | [**create_2**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create_2) | **POST** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/ | Upload a collection
*PulpAnsibleDefaultApiApi* | [**get**](docs/PulpAnsibleDefaultApiApi.md#get) | **GET** /pulp_ansible/galaxy/default/api/ | 
*PulpAnsibleDefaultApiV3Api* | [**read**](docs/PulpAnsibleDefaultApiV3Api.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/ | 
*PulpAnsibleDefaultApiV3ArtifactsCollectionsApi* | [**get**](docs/PulpAnsibleDefaultApiV3ArtifactsCollectionsApi.md#get) | **GET** /pulp_ansible/galaxy/default/api/v3/artifacts/collections/{path}/{filename} | 
*PulpAnsibleDefaultApiV3CollectionVersionsAllApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionVersionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collection_versions/all/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**delete**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**update**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#update) | **PATCH** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsAllApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/all/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsApi* | [**delete**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsApi* | [**download**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsApi.md#download) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/{filename} | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**delete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**update**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#update) | **PATCH** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**delete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleTagsApi* | [**list**](docs/PulpAnsibleTagsApi.md#list) | **GET** /pulp/api/v3/pulp_ansible/tags/ | List tags
*RemotesCollectionApi* | [**create**](docs/RemotesCollectionApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/collection/ | Create a collection remote
*RemotesCollectionApi* | [**delete**](docs/RemotesCollectionApi.md#delete) | **DELETE** {ansible_collection_remote_href} | Delete a collection remote
*RemotesCollectionApi* | [**list**](docs/RemotesCollectionApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/collection/ | List collection remotes
*RemotesCollectionApi* | [**partial_update**](docs/RemotesCollectionApi.md#partial_update) | **PATCH** {ansible_collection_remote_href} | Update a collection remote
*RemotesCollectionApi* | [**read**](docs/RemotesCollectionApi.md#read) | **GET** {ansible_collection_remote_href} | Inspect a collection remote
*RemotesCollectionApi* | [**update**](docs/RemotesCollectionApi.md#update) | **PUT** {ansible_collection_remote_href} | Update a collection remote
*RemotesGitApi* | [**create**](docs/RemotesGitApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/git/ | Create a git remote
*RemotesGitApi* | [**delete**](docs/RemotesGitApi.md#delete) | **DELETE** {ansible_git_remote_href} | Delete a git remote
*RemotesGitApi* | [**list**](docs/RemotesGitApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/git/ | List git remotes
*RemotesGitApi* | [**partial_update**](docs/RemotesGitApi.md#partial_update) | **PATCH** {ansible_git_remote_href} | Update a git remote
*RemotesGitApi* | [**read**](docs/RemotesGitApi.md#read) | **GET** {ansible_git_remote_href} | Inspect a git remote
*RemotesGitApi* | [**update**](docs/RemotesGitApi.md#update) | **PUT** {ansible_git_remote_href} | Update a git remote
*RemotesRoleApi* | [**create**](docs/RemotesRoleApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/role/ | Create a role remote
*RemotesRoleApi* | [**delete**](docs/RemotesRoleApi.md#delete) | **DELETE** {ansible_role_remote_href} | Delete a role remote
*RemotesRoleApi* | [**list**](docs/RemotesRoleApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/role/ | List role remotes
*RemotesRoleApi* | [**partial_update**](docs/RemotesRoleApi.md#partial_update) | **PATCH** {ansible_role_remote_href} | Update a role remote
*RemotesRoleApi* | [**read**](docs/RemotesRoleApi.md#read) | **GET** {ansible_role_remote_href} | Inspect a role remote
*RemotesRoleApi* | [**update**](docs/RemotesRoleApi.md#update) | **PUT** {ansible_role_remote_href} | Update a role remote
*RepositoriesAnsibleApi* | [**create**](docs/RepositoriesAnsibleApi.md#create) | **POST** /pulp/api/v3/repositories/ansible/ansible/ | Create an ansible repository
*RepositoriesAnsibleApi* | [**delete**](docs/RepositoriesAnsibleApi.md#delete) | **DELETE** {ansible_ansible_repository_href} | Delete an ansible repository
*RepositoriesAnsibleApi* | [**list**](docs/RepositoriesAnsibleApi.md#list) | **GET** /pulp/api/v3/repositories/ansible/ansible/ | List ansible repositorys
*RepositoriesAnsibleApi* | [**modify**](docs/RepositoriesAnsibleApi.md#modify) | **POST** {ansible_ansible_repository_href}modify/ | Modify Repository Content
*RepositoriesAnsibleApi* | [**partial_update**](docs/RepositoriesAnsibleApi.md#partial_update) | **PATCH** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleApi* | [**read**](docs/RepositoriesAnsibleApi.md#read) | **GET** {ansible_ansible_repository_href} | Inspect an ansible repository
*RepositoriesAnsibleApi* | [**sign**](docs/RepositoriesAnsibleApi.md#sign) | **POST** {ansible_ansible_repository_href}sign/ | 
*RepositoriesAnsibleApi* | [**sync**](docs/RepositoriesAnsibleApi.md#sync) | **POST** {ansible_ansible_repository_href}sync/ | 
*RepositoriesAnsibleApi* | [**update**](docs/RepositoriesAnsibleApi.md#update) | **PUT** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleVersionsApi* | [**delete**](docs/RepositoriesAnsibleVersionsApi.md#delete) | **DELETE** {ansible_ansible_repository_version_href} | Delete a repository version
*RepositoriesAnsibleVersionsApi* | [**list**](docs/RepositoriesAnsibleVersionsApi.md#list) | **GET** {ansible_ansible_repository_href}versions/ | List repository versions
*RepositoriesAnsibleVersionsApi* | [**read**](docs/RepositoriesAnsibleVersionsApi.md#read) | **GET** {ansible_ansible_repository_version_href} | Inspect a repository version
*RepositoriesAnsibleVersionsApi* | [**repair**](docs/RepositoriesAnsibleVersionsApi.md#repair) | **POST** {ansible_ansible_repository_version_href}repair/ | 
*VersionsApi* | [**get**](docs/VersionsApi.md#get) | **GET** {ansible_role_href}versions/ | 
*VersionsApi* | [**get_0**](docs/VersionsApi.md#get_0) | **GET** {ansible_collection_version_href}versions/ | 


## Documentation For Models

 - [AnsibleAnsibleDistribution](docs/AnsibleAnsibleDistribution.md)
 - [AnsibleAnsibleDistributionResponse](docs/AnsibleAnsibleDistributionResponse.md)
 - [AnsibleAnsibleRepository](docs/AnsibleAnsibleRepository.md)
 - [AnsibleAnsibleRepositoryResponse](docs/AnsibleAnsibleRepositoryResponse.md)
 - [AnsibleCollection](docs/AnsibleCollection.md)
 - [AnsibleCollectionRemote](docs/AnsibleCollectionRemote.md)
 - [AnsibleCollectionRemoteResponse](docs/AnsibleCollectionRemoteResponse.md)
 - [AnsibleCollectionResponse](docs/AnsibleCollectionResponse.md)
 - [AnsibleCollectionVersion](docs/AnsibleCollectionVersion.md)
 - [AnsibleCollectionVersionResponse](docs/AnsibleCollectionVersionResponse.md)
 - [AnsibleCollectionVersionSignature](docs/AnsibleCollectionVersionSignature.md)
 - [AnsibleCollectionVersionSignatureResponse](docs/AnsibleCollectionVersionSignatureResponse.md)
 - [AnsibleGitRemote](docs/AnsibleGitRemote.md)
 - [AnsibleGitRemoteResponse](docs/AnsibleGitRemoteResponse.md)
 - [AnsibleRepositorySignature](docs/AnsibleRepositorySignature.md)
 - [AnsibleRepositorySyncURL](docs/AnsibleRepositorySyncURL.md)
 - [AnsibleRole](docs/AnsibleRole.md)
 - [AnsibleRoleRemote](docs/AnsibleRoleRemote.md)
 - [AnsibleRoleRemoteResponse](docs/AnsibleRoleRemoteResponse.md)
 - [AnsibleRoleResponse](docs/AnsibleRoleResponse.md)
 - [AnsibleTagResponse](docs/AnsibleTagResponse.md)
 - [ArtifactRefResponse](docs/ArtifactRefResponse.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [CollectionImportDetailResponse](docs/CollectionImportDetailResponse.md)
 - [CollectionMetadataResponse](docs/CollectionMetadataResponse.md)
 - [CollectionNamespaceResponse](docs/CollectionNamespaceResponse.md)
 - [CollectionOneShot](docs/CollectionOneShot.md)
 - [CollectionRefResponse](docs/CollectionRefResponse.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionVersionDocsResponse](docs/CollectionVersionDocsResponse.md)
 - [CollectionVersionListResponse](docs/CollectionVersionListResponse.md)
 - [CollectionVersionResponse](docs/CollectionVersionResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [Copy](docs/Copy.md)
 - [GalaxyCollection](docs/GalaxyCollection.md)
 - [GalaxyCollectionResponse](docs/GalaxyCollectionResponse.md)
 - [GalaxyCollectionVersionResponse](docs/GalaxyCollectionVersionResponse.md)
 - [GalaxyRoleResponse](docs/GalaxyRoleResponse.md)
 - [GalaxyRoleVersionResponse](docs/GalaxyRoleVersionResponse.md)
 - [PaginatedCollectionResponseList](docs/PaginatedCollectionResponseList.md)
 - [PaginatedCollectionResponseListLinks](docs/PaginatedCollectionResponseListLinks.md)
 - [PaginatedCollectionResponseListMeta](docs/PaginatedCollectionResponseListMeta.md)
 - [PaginatedCollectionVersionListResponseList](docs/PaginatedCollectionVersionListResponseList.md)
 - [PaginatedGalaxyCollectionResponseList](docs/PaginatedGalaxyCollectionResponseList.md)
 - [PaginatedGalaxyCollectionVersionResponseList](docs/PaginatedGalaxyCollectionVersionResponseList.md)
 - [PaginatedGalaxyRoleResponseList](docs/PaginatedGalaxyRoleResponseList.md)
 - [PaginatedGalaxyRoleVersionResponseList](docs/PaginatedGalaxyRoleVersionResponseList.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedTagResponseList](docs/PaginatedTagResponseList.md)
 - [PaginatedansibleAnsibleDistributionResponseList](docs/PaginatedansibleAnsibleDistributionResponseList.md)
 - [PaginatedansibleAnsibleRepositoryResponseList](docs/PaginatedansibleAnsibleRepositoryResponseList.md)
 - [PaginatedansibleCollectionRemoteResponseList](docs/PaginatedansibleCollectionRemoteResponseList.md)
 - [PaginatedansibleCollectionResponseList](docs/PaginatedansibleCollectionResponseList.md)
 - [PaginatedansibleCollectionVersionResponseList](docs/PaginatedansibleCollectionVersionResponseList.md)
 - [PaginatedansibleCollectionVersionSignatureResponseList](docs/PaginatedansibleCollectionVersionSignatureResponseList.md)
 - [PaginatedansibleGitRemoteResponseList](docs/PaginatedansibleGitRemoteResponseList.md)
 - [PaginatedansibleRoleRemoteResponseList](docs/PaginatedansibleRoleRemoteResponseList.md)
 - [PaginatedansibleRoleResponseList](docs/PaginatedansibleRoleResponseList.md)
 - [PatchedansibleAnsibleDistribution](docs/PatchedansibleAnsibleDistribution.md)
 - [PatchedansibleAnsibleRepository](docs/PatchedansibleAnsibleRepository.md)
 - [PatchedansibleCollectionRemote](docs/PatchedansibleCollectionRemote.md)
 - [PatchedansibleGitRemote](docs/PatchedansibleGitRemote.md)
 - [PatchedansibleRoleRemote](docs/PatchedansibleRoleRemote.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [Repair](docs/Repair.md)
 - [RepoMetadataResponse](docs/RepoMetadataResponse.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [TagResponse](docs/TagResponse.md)
 - [UnpaginatedCollectionVersionResponse](docs/UnpaginatedCollectionVersionResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


