import Template from 'cloudform-types/types/template';
import Resource from 'cloudform-types/types/resource';
import Parameter from 'cloudform-types/types/parameter';
import { Condition } from 'cloudform-types/types/dataTypes';
import Output from 'cloudform-types/types/output';
import { TypeSystemDefinitionNode, ObjectTypeDefinitionNode, FieldDefinitionNode, InputObjectTypeDefinitionNode, SchemaDefinitionNode, ObjectTypeExtensionNode, DocumentNode, EnumTypeDefinitionNode, TypeDefinitionNode } from 'graphql';
import { InterfaceTypeExtensionNode, UnionTypeExtensionNode, EnumTypeExtensionNode, InputObjectTypeExtensionNode } from 'graphql/language/ast';
import { ResolverConfig } from './util';
import { FeatureFlagProvider } from './FeatureFlags';
export interface MappingParameters {
    [key: string]: {
        [key: string]: {
            [key: string]: string | number | string[];
        };
    };
}
export declare function blankObject(name: string): ObjectTypeDefinitionNode;
export declare function objectExtension(name: string, fields?: FieldDefinitionNode[]): ObjectTypeExtensionNode;
export declare class TransformerContextMetadata {
    private metadata;
    get(key: string): any;
    set(key: string, val: any): void;
    has(key: string): boolean;
}
export declare type StackMapping = Map<string, string>;
export declare class TransformerContext {
    readonly featureFlags: FeatureFlagProvider;
    template: Template;
    nodeMap: {
        [name: string]: TypeSystemDefinitionNode;
    };
    inputDocument: DocumentNode;
    metadata: TransformerContextMetadata;
    private stackMapping;
    private resolverConfig;
    private transformerVersion;
    constructor(inputSDL: string, featureFlags: FeatureFlagProvider);
    private fillNodeMapWithInput;
    getTypeDefinitionsOfKind(kind: string): TypeDefinitionNode[];
    mergeResources(resources: {
        [key: string]: Resource;
    }): void;
    mergeParameters(params: {
        [key: string]: Parameter;
    }): void;
    mergeConditions(conditions: {
        [key: string]: Condition;
    }): void;
    getResource(resource: string): Resource;
    setResource(key: string, resource: Resource): void;
    setOutput(key: string, output: Output): void;
    getOutput(key: string): Output;
    mergeOutputs(outputs: {
        [key: string]: Output;
    }): void;
    mergeMappings(mapping: MappingParameters): void;
    putSchema(obj: SchemaDefinitionNode): void;
    getSchema(): SchemaDefinitionNode;
    getQueryTypeName(): string | undefined;
    getQuery(): ObjectTypeDefinitionNode | undefined;
    getMutationTypeName(): string | undefined;
    getMutation(): ObjectTypeDefinitionNode | undefined;
    getSubscriptionTypeName(): string | undefined;
    getSubscription(): ObjectTypeDefinitionNode | undefined;
    addType(obj: TypeDefinitionNode): void;
    putType(obj: TypeDefinitionNode): void;
    getType(name: string): TypeSystemDefinitionNode | undefined;
    addObject(obj: ObjectTypeDefinitionNode): void;
    updateObject(obj: ObjectTypeDefinitionNode): void;
    getObject(name: string): ObjectTypeDefinitionNode | undefined;
    addQueryFields(fields: FieldDefinitionNode[]): void;
    addMutationFields(fields: FieldDefinitionNode[]): void;
    addSubscriptionFields(fields: FieldDefinitionNode[]): void;
    addObjectExtension(obj: ObjectTypeExtensionNode): void;
    addInputExtension(obj: InputObjectTypeExtensionNode): void;
    addInterfaceExtension(obj: InterfaceTypeExtensionNode): void;
    addUnionExtension(obj: UnionTypeExtensionNode): void;
    addEnumExtension(obj: EnumTypeExtensionNode): void;
    addInput(inp: InputObjectTypeDefinitionNode): void;
    addEnum(en: EnumTypeDefinitionNode): void;
    mapResourceToStack(stackName: string, resource: string): void;
    getStackMapping(): StackMapping;
    setResolverConfig(resolverConfig: ResolverConfig): void;
    getResolverConfig(): ResolverConfig;
    setTransformerVersion(version: Number): void;
    getTransformerVersion(): Number;
    isProjectUsingDataStore(): boolean;
}
//# sourceMappingURL=TransformerContext.d.ts.map