import { Transformer, TransformerContext } from 'graphql-transformer-core';
import { ResourceFactory } from './resources';
import { AuthRule, AuthProvider } from './AuthRule';
import { ObjectTypeDefinitionNode, DirectiveNode, FieldDefinitionNode, InterfaceTypeDefinitionNode } from 'graphql';
export declare type AppSyncAuthMode = 'API_KEY' | 'AMAZON_COGNITO_USER_POOLS' | 'AWS_IAM' | 'OPENID_CONNECT';
export declare type AppSyncAuthConfiguration = {
    defaultAuthentication: AppSyncAuthConfigurationEntry;
    additionalAuthenticationProviders: Array<AppSyncAuthConfigurationEntry>;
};
export declare type AppSyncAuthConfigurationEntry = {
    authenticationType: AppSyncAuthMode;
    apiKeyConfig?: ApiKeyConfig;
    userPoolConfig?: UserPoolConfig;
    openIDConnectConfig?: OpenIDConnectConfig;
};
export declare type ApiKeyConfig = {
    description?: string;
    apiKeyExpirationDays: number;
};
export declare type UserPoolConfig = {
    userPoolId: string;
};
export declare type OpenIDConnectConfig = {
    name: string;
    issuerUrl: string;
    clientId?: string;
    iatTTL?: number;
    authTTL?: number;
};
export declare type ModelAuthTransformerConfig = {
    authConfig?: AppSyncAuthConfiguration;
    addAwsIamAuthInOutputSchema?: boolean;
};
export declare type ConfiguredAuthProviders = {
    default: AuthProvider;
    onlyDefaultAuthProviderConfigured: boolean;
    hasApiKey: boolean;
    hasUserPools: boolean;
    hasOIDC: boolean;
    hasIAM: boolean;
};
export declare class ModelAuthTransformer extends Transformer {
    resources: ResourceFactory;
    config: ModelAuthTransformerConfig;
    configuredAuthProviders: ConfiguredAuthProviders;
    generateIAMPolicyforUnauthRole: boolean;
    generateIAMPolicyforAuthRole: boolean;
    authPolicyResources: Set<string>;
    unauthPolicyResources: Set<string>;
    constructor(config?: ModelAuthTransformerConfig);
    private updateAPIAuthentication;
    before: (ctx: TransformerContext) => void;
    after: (ctx: TransformerContext) => void;
    private getApiKeyConfig;
    object: (def: ObjectTypeDefinitionNode, directive: DirectiveNode, ctx: TransformerContext) => void;
    field: (parent: ObjectTypeDefinitionNode | InterfaceTypeDefinitionNode, definition: FieldDefinitionNode, directive: DirectiveNode, ctx: TransformerContext) => void;
    private propagateAuthDirectivesToNestedTypes;
    private protectField;
    private protectReadForField;
    private protectUpdateForField;
    private protectDeleteForField;
    private protectCreateForField;
    private splitRules;
    private validateRules;
    private validateFieldRules;
    private commonRuleValidation;
    private protectGetQuery;
    private authorizationExpressionOnSingleObject;
    private protectListQuery;
    private authorizationExpressionForListResult;
    private protectCreateMutation;
    private protectUpdateOrDeleteMutation;
    private protectUpdateMutation;
    private protectDeleteMutation;
    private protectConnections;
    private protectQueries;
    private protectSearchQuery;
    protectSyncQuery(ctx: TransformerContext, def: ObjectTypeDefinitionNode, resolverResourceID: string, rules: AuthRule[]): void;
    private protectOnCreateSubscription;
    private protectOnUpdateSubscription;
    private protectOnDeleteSubscription;
    private addSubscriptionResolvers;
    private isSubscriptionOwnerArgumentOptional;
    private addSubscriptionOwnerArgument;
    private addOwnerFieldsToObject;
    private addOwner;
    private getOwnerRules;
    private getStaticGroupRules;
    private getDynamicGroupRules;
    hasProviderAuthRules(rules: AuthRule[]): Boolean;
    private extendTypeWithDirectives;
    private addDirectivesToOperation;
    private addDirectivesToField;
    private extendAuthRulesForAdminUI;
    private getDirectivesForRules;
    private ensureDefaultAuthProviderAssigned;
    private validateRuleAuthStrategy;
    private getConfiguredAuthProviders;
    private setAuthPolicyFlag;
    private setUnauthPolicyFlag;
    private getAuthRulesFromDirective;
    private isTypeNeedsDefaultProviderAccess;
    private doesTypeHaveRulesForOperation;
    private addTypeToResourceReferences;
    private addFieldToResourceReferences;
    private isOperationExpressionSet;
    private updateMutationConditionInput;
    private isAdminUIEnabled;
    private shouldAddDefaultAuthDirective;
    private typeExist;
    private isSyncEnabled;
}
//# sourceMappingURL=ModelAuthTransformer.d.ts.map