#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.result',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20220311',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    ('Result and friends: various subclassable classes for deferred delivery of '    
 'values.'),
  long_description =
    ('Result and friends: various subclassable classes for deferred delivery of '    
 'values.\n'    
 '\n'    
 '*Latest release 20220311*:\n'    
 '* Result: class local Seq instance.\n'    
 '* Result.call: thread safe runtime check of self.state==pending.\n'    
 '* New Task and @task decorator, prototype for rerunnable blocking chaining '    
 'tasks scheme - very alpha.\n'    
 '\n'    
 'A `Result` is the base class for several callable subclasses\n'    
 'which will receive values at a later point in time,\n'    
 'and can also be used standalone without subclassing.\n'    
 '\n'    
 'A call to a `Result` will block until the value is received or the `Result` '    
 'is cancelled,\n'    
 'which will raise an exception in the caller.\n'    
 'A `Result` may be called by multiple users, before or after the value has '    
 'been delivered;\n'    
 'if the value has been delivered the caller returns with it immediately.\n'    
 "A `Result`'s state may be inspected (pending, running, ready, cancelled).\n"    
 "Callbacks can be registered via a `Result`'s .notify method.\n"    
 '\n'    
 'An incomplete `Result` can be told to call a function to compute its value;\n'    
 'the function return will be stored as the value unless the function raises '    
 'an exception,\n'    
 'in which case the exception information is recorded instead.\n'    
 'If an exception occurred, it will be reraised for any caller of the '    
 '`Result`.\n'    
 '\n'    
 'Trite example:\n'    
 '\n'    
 '    R = Result(name="my demo")\n'    
 '\n'    
 'Thread 1:\n'    
 '\n'    
 '    # this blocks until the Result is ready\n'    
 '    value = R()\n'    
 '    print(value)\n'    
 '    # prints 3 once Thread 2 (below) assigns to it\n'    
 '\n'    
 'Thread 2:\n'    
 '\n'    
 '    R.result = 3\n'    
 '\n'    
 'Thread 3:\n'    
 '\n'    
 '    value = R()\n'    
 '    # returns immediately with 3\n'    
 '\n'    
 'You can also collect multiple `Result`s in completion order using the '    
 '`report()` function:\n'    
 '\n'    
 '    Rs = [ ... list of Results of whatever type ... ]\n'    
 '    ...\n'    
 '    for R in report(Rs):\n'    
 '        x = R()     # collect result, will return immediately because\n'    
 '                    # the Result is complete\n'    
 '        print(x)    # print result\n'    
 '\n'    
 '## Function `after(Rs, R, func, *a, **kw)`\n'    
 '\n'    
 'After the completion of `Rs` call `func(*a,**kw)` and return\n'    
 'its result via `R`; return the `Result` object.\n'    
 '\n'    
 'Parameters:\n'    
 '* `Rs`: an iterable of Results.\n'    
 '* `R`: a `Result` to collect to result of calling `func`.\n'    
 '  If `None`, one will be created.\n'    
 '* `func`, `a`, `kw`: a callable and its arguments.\n'    
 '\n'    
 '## Class `AsynchState(enum.Enum)`\n'    
 '\n'    
 'State tokens for `Result`s.\n'    
 '\n'    
 '## Function `bg(func, *a, **kw)`\n'    
 '\n'    
 'Dispatch a `Thread` to run `func`, return a `Result` to collect its value.\n'    
 '\n'    
 'Parameters:\n'    
 '* `_name`: optional name for the `Result`, passed to the initialiser\n'    
 '* `_extra`: optional extra data for the `Result`, passed to the initialiser\n'    
 '\n'    
 'Other parameters are passed to `func`.\n'    
 '\n'    
 '## Class `BlockedError(builtins.Exception, builtins.BaseException)`\n'    
 '\n'    
 'Raised by a blocked `Task` if attempted.\n'    
 '\n'    
 '## Class `CancellationError(builtins.Exception, builtins.BaseException)`\n'    
 '\n'    
 'Raised when accessing `result` or `exc_info` after cancellation.\n'    
 '\n'    
 '## Class `OnDemandFunction(Result)`\n'    
 '\n'    
 'Wrap a callable, run it when required.\n'    
 '\n'    
 '## Class `OnDemandResult(Result)`\n'    
 '\n'    
 'Wrap a callable, run it when required.\n'    
 '\n'    
 '## Function `report(LFs)`\n'    
 '\n'    
 'Generator which yields completed `Result`s.\n'    
 '\n'    
 'This is a generator that yields `Result`s as they complete,\n'    
 'useful for waiting for a sequence of `Result`s\n'    
 'that may complete in an arbitrary order.\n'    
 '\n'    
 '## Class `Result`\n'    
 '\n'    
 'Basic class for asynchronous collection of a result.\n'    
 'This is also used to make `OnDemandFunction`s, `LateFunction`s and other\n'    
 'objects with asynchronous termination.\n'    
 '\n'    
 '*Method `Result.__init__(self, name=None, lock=None, result=None, '    
 'extra=None)`*:\n'    
 'Base initialiser for `Result` objects and subclasses.\n'    
 '\n'    
 'Parameter:\n'    
 '* `name`: optional parameter naming this object.\n'    
 '* `lock`: optional locking object, defaults to a new `threading.Lock`.\n'    
 '* `result`: if not `None`, prefill the `.result` property.\n'    
 '* `extra`: a mapping of extra information to associate with the `Result`,\n'    
 '  useful to provide context when collecting the result;\n'    
 '  the `Result` has a public attribute `.extra`\n'    
 '  which is an `AttrableMapping` to hold this information.\n'    
 '\n'    
 '*Method `Result.__call__(self, *a, **kw)`*:\n'    
 'Call the `Result`: wait for it to be ready and then return or raise.\n'    
 '\n'    
 'You can optionally supply a callable and arguments,\n'    
 'in which case `callable(*args,**kwargs)` will be called\n'    
 'via `Result.call` and the results applied to this `Result`.\n'    
 '\n'    
 '*Method `Result.bg(self, func, *a, **kw)`*:\n'    
 'Submit a function to compute the result in a separate `Thread`,\n'    
 'returning the `Thread`.\n'    
 '\n'    
 'This dispatches a `Thread` to run `self.call(func,*a,**kw)`\n'    
 'and as such the `Result` must be in "pending" state,\n'    
 'and transitions to "running".\n'    
 '\n'    
 '*Method `Result.call(self, func, *a, **kw)`*:\n'    
 'Have the `Result` call `func(*a,**kw)` and store its return value as\n'    
 '`self.result`.\n'    
 'If `func` raises an exception, store it as `self.exc_info`.\n'    
 '\n'    
 '*Method `Result.cancel(self)`*:\n'    
 'Cancel this function.\n'    
 'If `self.state` is pending or cancelled, return `True`.\n'    
 'Otherwise return `False` (too late to cancel).\n'    
 '\n'    
 '*Property `Result.cancelled`*:\n'    
 'Test whether this `Result` has been cancelled.\n'    
 '\n'    
 '*Method `Result.empty(self)`*:\n'    
 'Analogue to `Queue.empty()`.\n'    
 '\n'    
 '*Property `Result.exc_info`*:\n'    
 'The exception information from a completed `Result`.\n'    
 'This is not available before completion.\n'    
 '\n'    
 '*Method `Result.get(self, default=None)`*:\n'    
 'Wait for readiness; return the result if `self.exc_info` is `None`,\n'    
 'otherwise `default`.\n'    
 '\n'    
 '*Method `Result.join(self, *a, **kw)`*:\n'    
 'Calling the `.join()` method waits for the function to run to\n'    
 "completion and returns a tuple as for the `WorkerThreadPool`'s\n"    
 '`.dispatch()` return queue, a tuple of `(result,exc_info)`.\n'    
 '\n'    
 'On completion the sequence `(result,None)` is returned.\n'    
 'If an exception occurred computing the result the sequence\n'    
 '`(None,exc_info)` is returned\n'    
 'where `exc_info` is a tuple of `(exc_type,exc_value,exc_traceback)`.\n'    
 'If the function was cancelled the sequence `(None,None)`\n'    
 'is returned.\n'    
 '\n'    
 '*Method `Result.notify(self, notifier)`*:\n'    
 'After the function completes, call `notifier(self)`.\n'    
 '\n'    
 'If the function has already completed this will happen immediately.\n'    
 "example: if you'd rather `self` got put on some Queue `Q`, supply `Q.put`.\n"    
 '\n'    
 '*Property `Result.pending`*:\n'    
 'Whether the `Result` is pending.\n'    
 '\n'    
 '*Method `Result.put(self, value)`*:\n'    
 'Store the value. `Queue`-like idiom.\n'    
 '\n'    
 '*Method `Result.raise_(self, exc=None)`*:\n'    
 'Convenience wrapper for `self.exc_info` to store an exception result `exc`.\n'    
 'If `exc` is omitted or `None`, use `sys.exc_info()`.\n'    
 '\n'    
 '*Property `Result.ready`*:\n'    
 'Whether the `Result` state is ready or cancelled.\n'    
 '\n'    
 '*Property `Result.result`*:\n'    
 'The result.\n'    
 'This property is not available before completion.\n'    
 '\n'    
 '*Method `Result.with_result(self, submitter, prefix=None)`*:\n'    
 'On completion without an exception, call `submitter(self.result)`\n'    
 'or report exception.\n'    
 '\n'    
 '## Class `ResultSet(builtins.set)`\n'    
 '\n'    
 'A `set` subclass containing `Result`s,\n'    
 'on which one may iterate as `Result`s complete.\n'    
 '\n'    
 '*Method `ResultSet.__iter__(self)`*:\n'    
 'Iterating on a `ResultSet` yields `Result`s as they complete.\n'    
 '\n'    
 '*Method `ResultSet.wait(self)`*:\n'    
 'Convenience function to wait for all the `Result`s.\n'    
 '\n'    
 '## Class `ResultState(enum.Enum)`\n'    
 '\n'    
 'State tokens for `Result`s.\n'    
 '\n'    
 '## Class `Task(Result)`\n'    
 '\n'    
 'A task which may require the completion of other tasks.\n'    
 'This is a subclass of `Result`.\n'    
 '\n'    
 'Keyword parameters:\n'    
 '* `cancel_on_exception`: if true, cancel this `Task` if `.call`\n'    
 '  raises an exception; the default is `False`, allowing repair\n'    
 '  and retry\n'    
 '* `cancel_on_result`: optional callable to test the `Task.result`\n'    
 '  after `.call`; if it returns `True` the `Task` is marked\n'    
 '  as cancelled\n'    
 '* `func`: the function to call to complete the `Task`;\n'    
 '  it will be called as `func(*func_args,**func_kwargs)`\n'    
 '* `func_args`: optional positional arguments, default `()`\n'    
 '* `func_kwargs`: optional keyword arguments, default `{}`\n'    
 '* `lock`: optional lock, default an `RLock`\n'    
 'Other arguments are passed to the `Result` initialiser.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    t1 = Task(name="task1")\n'    
 '    t1.bg(time.sleep, 10)\n'    
 '    t2 = Task("name="task2")\n'    
 '    # prevent t2 from running until t1 completes\n'    
 '    t2.require(t1)\n'    
 '    # try to run sleep(5) for t2 immediately after t1 completes\n'    
 '    t1.notify(t2.call, sleep, 5)\n'    
 '\n'    
 'The model here may not be quite as expected; it is aimed at\n'    
 'tasks which can be repaired and rerun.\n'    
 'As such, if `self.call(func,...)` raises an exception from\n'    
 '`func` then this `Task` will still block dependent `Task`s.\n'    
 'Dually, a `Task` which completes without an exception is\n'    
 'considered complete and does not block dependent `Task`s.\n'    
 'To cancel dependent `Tasks` the function should raise a\n'    
 '`CancellationError`.\n'    
 '\n'    
 'Users wanting more immediate semantics can supply `cancel_on_exception`\n'    
 'and/or `cancel_on_result` to control these behaviours.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    t1 = Task(name="task1")\n'    
 '    t1.bg(time.sleep, 2)\n'    
 '    t2 = Task("name="task2")\n'    
 '    # prevent t2 from running until t1 completes\n'    
 '    t2.require(t1)\n'    
 '    # try to run sleep(5) for t2 immediately after t1 completes\n'    
 '    t1.notify(t2.call, sleep, 5)\n'    
 '\n'    
 '    >>>\n'    
 '\n'    
 '*Method `Task.abort(self)`*:\n'    
 'Calling `abort()` calls `self.runstate.cancel()` to indicate\n'    
 'to the running function that it should cease operation.\n'    
 '\n'    
 '*Method `Task.bg(self)`*:\n'    
 'Submit a function to complete the `Task` in a separate `Thread`,\n'    
 'returning the `Thread`.\n'    
 '\n'    
 'This dispatches a `Thread` to run `self.call()`\n'    
 'and as such the `Task` must be in "pending" state,\n'    
 'and transitions to "running".\n'    
 '\n'    
 '*Method `Task.block(self, otask)`*:\n'    
 'Block another task until we are complete.\n'    
 '\n'    
 '*Method `Task.blockers(self)`*:\n'    
 'A generator yielding tasks from `self.required()`\n'    
 'which should block this task.\n'    
 'Cancelled tasks are not blockers\n'    
 'but if we encounter one we do cancel the current task.\n'    
 '\n'    
 '*Method `Task.call(self)`*:\n'    
 'Attempt to perform the `Task` by calling `func(*func_args,**func_kwargs)`.\n'    
 '\n'    
 'If we are cancelled, raise `CancellationError`.\n'    
 'If there are blocking required tasks, raise `BlockedError`.\n'    
 'Otherwise run `r=func(self,*self.func_args,**self.func_kwargsw)`\n'    
 'with the following effects:\n'    
 '* if `func()` raises a `CancellationError`, cancel the `Task`\n'    
 '* otherwise, if an exception is raised and `self.cancel_on_exception`\n'    
 '  is true, cancel the `Task`;\n'    
 '  store the exception information from `sys.exc_info()` as `self.exc_info`\n'    
 '  regardless\n'    
 '* otherwise, if `self.cancel_on_result` is not `None`\n'    
 '  and `self.cancel_on_result(r)` is true, cancel the `Task`;\n'    
 '  store `r` as `self.result` regardless\n'    
 'If we were cancelled, raise `CancellationError`.\n'    
 '\n'    
 'During the duration of the call the property `Task.current_task`\n'    
 'is set to `self` allowing access to the `Task`.\n'    
 "A typical use is to access the current `Task`'s `.runstate`\n"    
 'attribute which can be polled by long running tasks to\n'    
 'honour calls to `Task.abort()`.\n'    
 '\n'    
 '*Method `Task.callif(self)`*:\n'    
 'Trigger a call to `func(self,*self.func_args,**self.func_kwargsw)`\n'    
 "if we're pending and not blocked or cancelled.\n"    
 '\n'    
 '*Method `Task.current_task()`*:\n'    
 'The current `Task`, valid during `Task.call()`.\n'    
 'This allows the function called by the `Task` to access the\n'    
 'task, typically to poll its `.runstate` attribute.\n'    
 '\n'    
 '*Method `Task.require(self, otask)`*:\n'    
 'Add a requirement that `otask` be complete before we proceed.\n'    
 '\n'    
 '*Method `Task.required(self)`*:\n'    
 'Return a `set` containing any required tasks.\n'    
 '\n'    
 '*Method `Task.then(self, func, *a, **kw)`*:\n'    
 'Queue a call to `func(*a,**kw)` to run after the completion of\n'    
 'this task.\n'    
 '\n'    
 'This supports a chain of actions:\n'    
 '\n'    
 '    >>> t = Task(func=lambda: 1)\n'    
 '    >>> final_t = t.then(print,1).then(print,2)\n'    
 '    >>> final_t.ready   # the final task has not yet run\n'    
 '    False\n'    
 '    >>> # finalise t, wait for final_t (which runs immediately)\n'    
 '    >>> t.call(); print(final_t.join())\n'    
 '    1\n'    
 '    2\n'    
 '    (None, None)\n'    
 '    >>> final_t.ready\n'    
 '    True\n'    
 '\n'    
 '## Function `task(*da, **dkw)`\n'    
 '\n'    
 'Decorator for a function which runs it as a `Task`.\n'    
 'The function may still be called directly.\n'    
 'The function should accept a `Task` as its first argument.\n'    
 '\n'    
 'The following function attributes are provided:\n'    
 '* `dispatch(after=(),deferred=False,delay=0.0)`: run this function\n'    
 '  after the completion of the tasks specified by `after`\n'    
 '  and after at least `delay` seconds;\n'    
 '  return the `Task` for the queued function\n'    
 '\n'    
 'Examples:\n'    
 '\n'    
 '    >>> import time\n'    
 '    >>> @task\n'    
 '    ... def f(x):\n'    
 '    ...     return x * 2\n'    
 '    ...\n'    
 '    >>> print(f(3))  # call the function normally\n'    
 '    6\n'    
 '    >>> # dispatch f(5) after 0.5s, get Task\n'    
 '    >>> t0 = time.time()\n'    
 '    >>> ft = f.dispatch((5,), delay=0.5)\n'    
 '    >>> # calling a Task, as with a Result, is like calling the function\n'    
 '    >>> print(ft())\n'    
 '    10\n'    
 '    >>> # check that we were blocked for 0.5s\n'    
 '    >>> now = time.time()\n'    
 '    >>> now - t0 >= 0.5\n'    
 '    True\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20220311*:\n'    
 '* Result: class local Seq instance.\n'    
 '* Result.call: thread safe runtime check of self.state==pending.\n'    
 '* New Task and @task decorator, prototype for rerunnable blocking chaining '    
 'tasks scheme - very alpha.\n'    
 '\n'    
 '*Release 20210420*:\n'    
 'Update dependencies, add docstring.\n'    
 '\n'    
 '*Release 20210407*:\n'    
 'New ResultSet(set) class, with context manager and wait methods, and whose '    
 '__iter__ iterates completed Results.\n'    
 '\n'    
 '*Release 20210123*:\n'    
 'bg: accept optional _extra parameter for use by the Result.\n'    
 '\n'    
 '*Release 20201102*:\n'    
 'Result: now .extra attribute for associated data and a new optional "extra" '    
 'parameter in the initialiser.\n'    
 '\n'    
 '*Release 20200521*:\n'    
 '* OnDemandResult: bugfixes and improvements.\n'    
 '* Result.bg: accept optional _name parameter to specify the Result.name.\n'    
 '\n'    
 '*Release 20191007*:\n'    
 '* Simplify ResultState definition.\n'    
 '* Result.bg: use cs.threads.bg to dispatch the Thread.\n'    
 '\n'    
 '*Release 20190522*:\n'    
 '* Result.__call__ now accepts an optional callable and args.\n'    
 '* Result.call: set the Result state to "running" before dispatching the '    
 'function.\n'    
 '* Rename OnDemandFunction to OnDemandResult, keep old name around for '    
 'compatibility.\n'    
 '* Result._complete: also permitted if state==cancelled.\n'    
 '\n'    
 '*Release 20190309*:\n'    
 'Small bugfix.\n'    
 '\n'    
 '*Release 20181231*:\n'    
 '* Result.call: report baser exceptions than BaseException.\n'    
 '* Drop _PendingFunction abstract class.\n'    
 '\n'    
 '*Release 20181109.1*:\n'    
 'DISTINFO update.\n'    
 '\n'    
 '*Release 20181109*:\n'    
 '* Derive CancellationError from Exception instead of RuntimeError, fix '    
 'initialiser.\n'    
 '* Rename AsynchState to ResultState and make it an Enum.\n'    
 '* Make Results hashable and comparable for equality for use as mapping keys: '    
 'equality is identity.\n'    
 '* New Result.collected attribute, set true if .result or .exc_info are '    
 'accessed, logs an error if Result.__del__ is called when false, may be set '    
 'true externally if a Result is not required.\n'    
 '* Drop `final` parameter; never used and supplanted by Result.notify.\n'    
 '* Result.join: return the .result and .exc_info properties in order to mark '    
 'the Result as collected.\n'    
 '* Result: set .collected to True when a notifier has been called '    
 'successfully.\n'    
 '* Bugfix Result.cancel: apply the new cancelled state.\n'    
 '\n'    
 '*Release 20171231*:\n'    
 '* Bugfix Result.call to catch BaseException instead of Exception.\n'    
 '* New convenience function bg(func) to dispatch `func` in a separate Thread '    
 'and return a Result to collect its value.\n'    
 '\n'    
 '*Release 20171030.1*:\n'    
 'Fix module requirements specification.\n'    
 '\n'    
 '*Release 20171030*:\n'    
 'New Result.bg(func, *a, **kw) method to dispatch function in separate Thread '    
 'to compute the Result value.\n'    
 '\n'    
 '*Release 20170903*:\n'    
 'rename cs.asynchron to cs.result'),
  install_requires = ['cs.deco', 'cs.logutils', 'cs.mappings', 'cs.pfx', 'cs.py.func', 'cs.py3', 'cs.resources', 'cs.seq', 'cs.threads', 'icontract'],
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.result'],
)
