import {Request} from '../lib/request';
import {Response} from '../lib/response';
import {AWSError} from '../lib/error';
import {Service} from '../lib/service';
import {ServiceConfigurationOptions} from '../lib/service';
import {ConfigBase as Config} from '../lib/config-base';
interface Blob {}
declare class IoTEvents extends Service {
  /**
   * Constructs a service object. This object has one method for each API operation.
   */
  constructor(options?: IoTEvents.Types.ClientConfiguration)
  config: Config & IoTEvents.Types.ClientConfiguration;
  /**
   * Creates a detector model.
   */
  createDetectorModel(params: IoTEvents.Types.CreateDetectorModelRequest, callback?: (err: AWSError, data: IoTEvents.Types.CreateDetectorModelResponse) => void): Request<IoTEvents.Types.CreateDetectorModelResponse, AWSError>;
  /**
   * Creates a detector model.
   */
  createDetectorModel(callback?: (err: AWSError, data: IoTEvents.Types.CreateDetectorModelResponse) => void): Request<IoTEvents.Types.CreateDetectorModelResponse, AWSError>;
  /**
   * Creates an input.
   */
  createInput(params: IoTEvents.Types.CreateInputRequest, callback?: (err: AWSError, data: IoTEvents.Types.CreateInputResponse) => void): Request<IoTEvents.Types.CreateInputResponse, AWSError>;
  /**
   * Creates an input.
   */
  createInput(callback?: (err: AWSError, data: IoTEvents.Types.CreateInputResponse) => void): Request<IoTEvents.Types.CreateInputResponse, AWSError>;
  /**
   * Deletes a detector model. Any active instances of the detector model are also deleted.
   */
  deleteDetectorModel(params: IoTEvents.Types.DeleteDetectorModelRequest, callback?: (err: AWSError, data: IoTEvents.Types.DeleteDetectorModelResponse) => void): Request<IoTEvents.Types.DeleteDetectorModelResponse, AWSError>;
  /**
   * Deletes a detector model. Any active instances of the detector model are also deleted.
   */
  deleteDetectorModel(callback?: (err: AWSError, data: IoTEvents.Types.DeleteDetectorModelResponse) => void): Request<IoTEvents.Types.DeleteDetectorModelResponse, AWSError>;
  /**
   * Deletes an input.
   */
  deleteInput(params: IoTEvents.Types.DeleteInputRequest, callback?: (err: AWSError, data: IoTEvents.Types.DeleteInputResponse) => void): Request<IoTEvents.Types.DeleteInputResponse, AWSError>;
  /**
   * Deletes an input.
   */
  deleteInput(callback?: (err: AWSError, data: IoTEvents.Types.DeleteInputResponse) => void): Request<IoTEvents.Types.DeleteInputResponse, AWSError>;
  /**
   * Describes a detector model. If the version parameter is not specified, information about the latest version is returned.
   */
  describeDetectorModel(params: IoTEvents.Types.DescribeDetectorModelRequest, callback?: (err: AWSError, data: IoTEvents.Types.DescribeDetectorModelResponse) => void): Request<IoTEvents.Types.DescribeDetectorModelResponse, AWSError>;
  /**
   * Describes a detector model. If the version parameter is not specified, information about the latest version is returned.
   */
  describeDetectorModel(callback?: (err: AWSError, data: IoTEvents.Types.DescribeDetectorModelResponse) => void): Request<IoTEvents.Types.DescribeDetectorModelResponse, AWSError>;
  /**
   * Retrieves execution information about a detector model analysis
   */
  describeDetectorModelAnalysis(params: IoTEvents.Types.DescribeDetectorModelAnalysisRequest, callback?: (err: AWSError, data: IoTEvents.Types.DescribeDetectorModelAnalysisResponse) => void): Request<IoTEvents.Types.DescribeDetectorModelAnalysisResponse, AWSError>;
  /**
   * Retrieves execution information about a detector model analysis
   */
  describeDetectorModelAnalysis(callback?: (err: AWSError, data: IoTEvents.Types.DescribeDetectorModelAnalysisResponse) => void): Request<IoTEvents.Types.DescribeDetectorModelAnalysisResponse, AWSError>;
  /**
   * Describes an input.
   */
  describeInput(params: IoTEvents.Types.DescribeInputRequest, callback?: (err: AWSError, data: IoTEvents.Types.DescribeInputResponse) => void): Request<IoTEvents.Types.DescribeInputResponse, AWSError>;
  /**
   * Describes an input.
   */
  describeInput(callback?: (err: AWSError, data: IoTEvents.Types.DescribeInputResponse) => void): Request<IoTEvents.Types.DescribeInputResponse, AWSError>;
  /**
   * Retrieves the current settings of the AWS IoT Events logging options.
   */
  describeLoggingOptions(params: IoTEvents.Types.DescribeLoggingOptionsRequest, callback?: (err: AWSError, data: IoTEvents.Types.DescribeLoggingOptionsResponse) => void): Request<IoTEvents.Types.DescribeLoggingOptionsResponse, AWSError>;
  /**
   * Retrieves the current settings of the AWS IoT Events logging options.
   */
  describeLoggingOptions(callback?: (err: AWSError, data: IoTEvents.Types.DescribeLoggingOptionsResponse) => void): Request<IoTEvents.Types.DescribeLoggingOptionsResponse, AWSError>;
  /**
   * Retrieves one or more analysis results of the detector model.
   */
  getDetectorModelAnalysisResults(params: IoTEvents.Types.GetDetectorModelAnalysisResultsRequest, callback?: (err: AWSError, data: IoTEvents.Types.GetDetectorModelAnalysisResultsResponse) => void): Request<IoTEvents.Types.GetDetectorModelAnalysisResultsResponse, AWSError>;
  /**
   * Retrieves one or more analysis results of the detector model.
   */
  getDetectorModelAnalysisResults(callback?: (err: AWSError, data: IoTEvents.Types.GetDetectorModelAnalysisResultsResponse) => void): Request<IoTEvents.Types.GetDetectorModelAnalysisResultsResponse, AWSError>;
  /**
   * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
   */
  listDetectorModelVersions(params: IoTEvents.Types.ListDetectorModelVersionsRequest, callback?: (err: AWSError, data: IoTEvents.Types.ListDetectorModelVersionsResponse) => void): Request<IoTEvents.Types.ListDetectorModelVersionsResponse, AWSError>;
  /**
   * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
   */
  listDetectorModelVersions(callback?: (err: AWSError, data: IoTEvents.Types.ListDetectorModelVersionsResponse) => void): Request<IoTEvents.Types.ListDetectorModelVersionsResponse, AWSError>;
  /**
   * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
   */
  listDetectorModels(params: IoTEvents.Types.ListDetectorModelsRequest, callback?: (err: AWSError, data: IoTEvents.Types.ListDetectorModelsResponse) => void): Request<IoTEvents.Types.ListDetectorModelsResponse, AWSError>;
  /**
   * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
   */
  listDetectorModels(callback?: (err: AWSError, data: IoTEvents.Types.ListDetectorModelsResponse) => void): Request<IoTEvents.Types.ListDetectorModelsResponse, AWSError>;
  /**
   * Lists the inputs you have created.
   */
  listInputs(params: IoTEvents.Types.ListInputsRequest, callback?: (err: AWSError, data: IoTEvents.Types.ListInputsResponse) => void): Request<IoTEvents.Types.ListInputsResponse, AWSError>;
  /**
   * Lists the inputs you have created.
   */
  listInputs(callback?: (err: AWSError, data: IoTEvents.Types.ListInputsResponse) => void): Request<IoTEvents.Types.ListInputsResponse, AWSError>;
  /**
   * Lists the tags (metadata) you have assigned to the resource.
   */
  listTagsForResource(params: IoTEvents.Types.ListTagsForResourceRequest, callback?: (err: AWSError, data: IoTEvents.Types.ListTagsForResourceResponse) => void): Request<IoTEvents.Types.ListTagsForResourceResponse, AWSError>;
  /**
   * Lists the tags (metadata) you have assigned to the resource.
   */
  listTagsForResource(callback?: (err: AWSError, data: IoTEvents.Types.ListTagsForResourceResponse) => void): Request<IoTEvents.Types.ListTagsForResourceResponse, AWSError>;
  /**
   * Sets or updates the AWS IoT Events logging options. If you update the value of any loggingOptions field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the roleArn field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
   */
  putLoggingOptions(params: IoTEvents.Types.PutLoggingOptionsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Sets or updates the AWS IoT Events logging options. If you update the value of any loggingOptions field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the roleArn field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
   */
  putLoggingOptions(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Performs an analysis of your detector model. For more information, see Running detector model analyses in the AWS IoT Events Developer Guide.
   */
  startDetectorModelAnalysis(params: IoTEvents.Types.StartDetectorModelAnalysisRequest, callback?: (err: AWSError, data: IoTEvents.Types.StartDetectorModelAnalysisResponse) => void): Request<IoTEvents.Types.StartDetectorModelAnalysisResponse, AWSError>;
  /**
   * Performs an analysis of your detector model. For more information, see Running detector model analyses in the AWS IoT Events Developer Guide.
   */
  startDetectorModelAnalysis(callback?: (err: AWSError, data: IoTEvents.Types.StartDetectorModelAnalysisResponse) => void): Request<IoTEvents.Types.StartDetectorModelAnalysisResponse, AWSError>;
  /**
   * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
   */
  tagResource(params: IoTEvents.Types.TagResourceRequest, callback?: (err: AWSError, data: IoTEvents.Types.TagResourceResponse) => void): Request<IoTEvents.Types.TagResourceResponse, AWSError>;
  /**
   * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
   */
  tagResource(callback?: (err: AWSError, data: IoTEvents.Types.TagResourceResponse) => void): Request<IoTEvents.Types.TagResourceResponse, AWSError>;
  /**
   * Removes the given tags (metadata) from the resource.
   */
  untagResource(params: IoTEvents.Types.UntagResourceRequest, callback?: (err: AWSError, data: IoTEvents.Types.UntagResourceResponse) => void): Request<IoTEvents.Types.UntagResourceResponse, AWSError>;
  /**
   * Removes the given tags (metadata) from the resource.
   */
  untagResource(callback?: (err: AWSError, data: IoTEvents.Types.UntagResourceResponse) => void): Request<IoTEvents.Types.UntagResourceResponse, AWSError>;
  /**
   * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
   */
  updateDetectorModel(params: IoTEvents.Types.UpdateDetectorModelRequest, callback?: (err: AWSError, data: IoTEvents.Types.UpdateDetectorModelResponse) => void): Request<IoTEvents.Types.UpdateDetectorModelResponse, AWSError>;
  /**
   * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
   */
  updateDetectorModel(callback?: (err: AWSError, data: IoTEvents.Types.UpdateDetectorModelResponse) => void): Request<IoTEvents.Types.UpdateDetectorModelResponse, AWSError>;
  /**
   * Updates an input.
   */
  updateInput(params: IoTEvents.Types.UpdateInputRequest, callback?: (err: AWSError, data: IoTEvents.Types.UpdateInputResponse) => void): Request<IoTEvents.Types.UpdateInputResponse, AWSError>;
  /**
   * Updates an input.
   */
  updateInput(callback?: (err: AWSError, data: IoTEvents.Types.UpdateInputResponse) => void): Request<IoTEvents.Types.UpdateInputResponse, AWSError>;
}
declare namespace IoTEvents {
  export interface Action {
    /**
     * Sets a variable to a specified value.
     */
    setVariable?: SetVariableAction;
    /**
     * Sends an Amazon SNS message.
     */
    sns?: SNSTopicPublishAction;
    /**
     * Publishes an MQTT message with the given topic to the AWS IoT message broker.
     */
    iotTopicPublish?: IotTopicPublishAction;
    /**
     * Information needed to set the timer.
     */
    setTimer?: SetTimerAction;
    /**
     * Information needed to clear the timer.
     */
    clearTimer?: ClearTimerAction;
    /**
     * Information needed to reset the timer.
     */
    resetTimer?: ResetTimerAction;
    /**
     * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
     */
    lambda?: LambdaAction;
    /**
     * Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.
     */
    iotEvents?: IotEventsAction;
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
     */
    sqs?: SqsAction;
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
     */
    firehose?: FirehoseAction;
    /**
     * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the payload. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see Actions in AWS IoT Events Developer Guide.
     */
    dynamoDB?: DynamoDBAction;
    /**
     * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the payload. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see Actions in AWS IoT Events Developer Guide.
     */
    dynamoDBv2?: DynamoDBv2Action;
    /**
     * Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .
     */
    iotSiteWise?: IotSiteWiseAction;
  }
  export type Actions = Action[];
  export type AmazonResourceName = string;
  export type AnalysisId = string;
  export type AnalysisMessage = string;
  export interface AnalysisResult {
    /**
     * The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:    supported-actions - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.    service-limits - Resources or operations can't exceed service limits. Update your detector model or request a limit adjust.    structure - The detector model must follow a structure that AWS IoT Events supports.     expression-syntax - Your expression must follow the required syntax.    data-type - Data types referenced in the detector model must be compatible.    referenced-data - You must define the data referenced in your detector model before you can use the data.    referenced-resource - Resources that the detector model uses must be available.   For more information, see Running detector model analyses in the AWS IoT Events Developer Guide.
     */
    type?: AnalysisType;
    /**
     * The severity level of the analysis result. Analysis results fall into three general categories based on the severity level:    INFO - An information result informs you about a significant field in your detector model. This type of result usually doesn't require immediate action.    WARNING - A warning result draws special attention to fields that are potentially damaging to your detector model. We recommend that you review warnings and take necessary actions before you use your detetor model in production environments. Otherwise, the detector model may not fully function as expected.    ERROR - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.  
     */
    level?: AnalysisResultLevel;
    /**
     * Contains additional information about the analysis result.
     */
    message?: AnalysisMessage;
    /**
     * Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.
     */
    locations?: AnalysisResultLocations;
  }
  export type AnalysisResultLevel = "INFO"|"WARNING"|"ERROR"|string;
  export interface AnalysisResultLocation {
    /**
     * A JsonPath expression that identifies the error field in your detector model.
     */
    path?: AnalysisResultLocationPath;
  }
  export type AnalysisResultLocationPath = string;
  export type AnalysisResultLocations = AnalysisResultLocation[];
  export type AnalysisResults = AnalysisResult[];
  export type AnalysisStatus = "RUNNING"|"COMPLETE"|"FAILED"|string;
  export type AnalysisType = string;
  export type AssetId = string;
  export type AssetPropertyAlias = string;
  export type AssetPropertyBooleanValue = string;
  export type AssetPropertyDoubleValue = string;
  export type AssetPropertyEntryId = string;
  export type AssetPropertyId = string;
  export type AssetPropertyIntegerValue = string;
  export type AssetPropertyOffsetInNanos = string;
  export type AssetPropertyQuality = string;
  export type AssetPropertyStringValue = string;
  export type AssetPropertyTimeInSeconds = string;
  export interface AssetPropertyTimestamp {
    /**
     * The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
     */
    timeInSeconds: AssetPropertyTimeInSeconds;
    /**
     * The nanosecond offset converted from timeInSeconds. The valid range is between 0-999999999.
     */
    offsetInNanos?: AssetPropertyOffsetInNanos;
  }
  export interface AssetPropertyValue {
    /**
     * The value to send to an asset property.
     */
    value: AssetPropertyVariant;
    /**
     * The timestamp associated with the asset property value. The default is the current event time.
     */
    timestamp?: AssetPropertyTimestamp;
    /**
     * The quality of the asset property value. The value must be 'GOOD', 'BAD', or 'UNCERTAIN'.
     */
    quality?: AssetPropertyQuality;
  }
  export interface AssetPropertyVariant {
    /**
     * The asset property value is a string. You must use an expression, and the evaluated result should be a string.
     */
    stringValue?: AssetPropertyStringValue;
    /**
     * The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
     */
    integerValue?: AssetPropertyIntegerValue;
    /**
     * The asset property value is a double. You must use an expression, and the evaluated result should be a double.
     */
    doubleValue?: AssetPropertyDoubleValue;
    /**
     * The asset property value is a Boolean value that must be 'TRUE' or 'FALSE'. You must use an expression, and the evaluated result should be a Boolean value.
     */
    booleanValue?: AssetPropertyBooleanValue;
  }
  export interface Attribute {
    /**
     * An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (BatchPutMessage). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the condition expressions used by detectors.  Syntax: &lt;field-name&gt;.&lt;field-name&gt;... 
     */
    jsonPath: AttributeJsonPath;
  }
  export type AttributeJsonPath = string;
  export type Attributes = Attribute[];
  export interface ClearTimerAction {
    /**
     * The name of the timer to clear.
     */
    timerName: TimerName;
  }
  export type Condition = string;
  export type ContentExpression = string;
  export interface CreateDetectorModelRequest {
    /**
     * The name of the detector model.
     */
    detectorModelName: DetectorModelName;
    /**
     * Information that defines how the detectors operate.
     */
    detectorModelDefinition: DetectorModelDefinition;
    /**
     * A brief description of the detector model.
     */
    detectorModelDescription?: DetectorModelDescription;
    /**
     * The input attribute key used to identify a device or system to create a detector (an instance of the detector model) and then to route each input received to the appropriate detector (instance). This parameter uses a JSON-path expression in the message payload of each input to specify the attribute-value pair that is used to identify the device associated with the input.
     */
    key?: AttributeJsonPath;
    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    roleArn: AmazonResourceName;
    /**
     * Metadata that can be used to manage the detector model.
     */
    tags?: Tags;
    /**
     * Information about the order in which events are evaluated and how actions are executed. 
     */
    evaluationMethod?: EvaluationMethod;
  }
  export interface CreateDetectorModelResponse {
    /**
     * Information about how the detector model is configured.
     */
    detectorModelConfiguration?: DetectorModelConfiguration;
  }
  export interface CreateInputRequest {
    /**
     * The name you want to give to the input.
     */
    inputName: InputName;
    /**
     * A brief description of the input.
     */
    inputDescription?: InputDescription;
    /**
     * The definition of the input.
     */
    inputDefinition: InputDefinition;
    /**
     * Metadata that can be used to manage the input.
     */
    tags?: Tags;
  }
  export interface CreateInputResponse {
    /**
     * Information about the configuration of the input.
     */
    inputConfiguration?: InputConfiguration;
  }
  export interface DeleteDetectorModelRequest {
    /**
     * The name of the detector model to be deleted.
     */
    detectorModelName: DetectorModelName;
  }
  export interface DeleteDetectorModelResponse {
  }
  export interface DeleteInputRequest {
    /**
     * The name of the input to delete.
     */
    inputName: InputName;
  }
  export interface DeleteInputResponse {
  }
  export type DeliveryStreamName = string;
  export interface DescribeDetectorModelAnalysisRequest {
    /**
     * The ID of the analysis result that you want to retrieve.
     */
    analysisId: AnalysisId;
  }
  export interface DescribeDetectorModelAnalysisResponse {
    /**
     * The status of the analysis activity. The status can be one of the following values:    RUNNING - AWS IoT Events is analyzing your detector model. This process can take several minutes to complete.    COMPLETE - AWS IoT Events finished analyzing your detector model .    FAILED - AWS IoT Events couldn't analyze your detector model. Try again later.  
     */
    status?: AnalysisStatus;
  }
  export interface DescribeDetectorModelRequest {
    /**
     * The name of the detector model.
     */
    detectorModelName: DetectorModelName;
    /**
     * The version of the detector model.
     */
    detectorModelVersion?: DetectorModelVersion;
  }
  export interface DescribeDetectorModelResponse {
    /**
     * Information about the detector model.
     */
    detectorModel?: DetectorModel;
  }
  export interface DescribeInputRequest {
    /**
     * The name of the input.
     */
    inputName: InputName;
  }
  export interface DescribeInputResponse {
    /**
     * Information about the input.
     */
    input?: Input;
  }
  export interface DescribeLoggingOptionsRequest {
  }
  export interface DescribeLoggingOptionsResponse {
    /**
     * The current settings of the AWS IoT Events logging options.
     */
    loggingOptions?: LoggingOptions;
  }
  export interface DetectorDebugOption {
    /**
     * The name of the detector model.
     */
    detectorModelName: DetectorModelName;
    /**
     * The value of the input attribute key used to create the detector (the instance of the detector model).
     */
    keyValue?: KeyValue;
  }
  export type DetectorDebugOptions = DetectorDebugOption[];
  export interface DetectorModel {
    /**
     * Information that defines how a detector operates.
     */
    detectorModelDefinition?: DetectorModelDefinition;
    /**
     * Information about how the detector is configured.
     */
    detectorModelConfiguration?: DetectorModelConfiguration;
  }
  export type DetectorModelArn = string;
  export interface DetectorModelConfiguration {
    /**
     * The name of the detector model.
     */
    detectorModelName?: DetectorModelName;
    /**
     * The version of the detector model.
     */
    detectorModelVersion?: DetectorModelVersion;
    /**
     * A brief description of the detector model.
     */
    detectorModelDescription?: DetectorModelDescription;
    /**
     * The ARN of the detector model.
     */
    detectorModelArn?: DetectorModelArn;
    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    roleArn?: AmazonResourceName;
    /**
     * The time the detector model was created.
     */
    creationTime?: Timestamp;
    /**
     * The time the detector model was last updated.
     */
    lastUpdateTime?: Timestamp;
    /**
     * The status of the detector model.
     */
    status?: DetectorModelVersionStatus;
    /**
     * The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information.  This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.
     */
    key?: AttributeJsonPath;
    /**
     * Information about the order in which events are evaluated and how actions are executed. 
     */
    evaluationMethod?: EvaluationMethod;
  }
  export interface DetectorModelDefinition {
    /**
     * Information about the states of the detector.
     */
    states: States;
    /**
     * The state that is entered at the creation of each detector (instance).
     */
    initialStateName: StateName;
  }
  export type DetectorModelDescription = string;
  export type DetectorModelName = string;
  export type DetectorModelSummaries = DetectorModelSummary[];
  export interface DetectorModelSummary {
    /**
     * The name of the detector model.
     */
    detectorModelName?: DetectorModelName;
    /**
     * A brief description of the detector model.
     */
    detectorModelDescription?: DetectorModelDescription;
    /**
     * The time the detector model was created.
     */
    creationTime?: Timestamp;
  }
  export type DetectorModelVersion = string;
  export type DetectorModelVersionStatus = "ACTIVE"|"ACTIVATING"|"INACTIVE"|"DEPRECATED"|"DRAFT"|"PAUSED"|"FAILED"|string;
  export type DetectorModelVersionSummaries = DetectorModelVersionSummary[];
  export interface DetectorModelVersionSummary {
    /**
     * The name of the detector model.
     */
    detectorModelName?: DetectorModelName;
    /**
     * The ID of the detector model version.
     */
    detectorModelVersion?: DetectorModelVersion;
    /**
     * The ARN of the detector model version.
     */
    detectorModelArn?: DetectorModelArn;
    /**
     * The ARN of the role that grants the detector model permission to perform its tasks.
     */
    roleArn?: AmazonResourceName;
    /**
     * The time the detector model version was created.
     */
    creationTime?: Timestamp;
    /**
     * The last time the detector model version was updated.
     */
    lastUpdateTime?: Timestamp;
    /**
     * The status of the detector model version.
     */
    status?: DetectorModelVersionStatus;
    /**
     * Information about the order in which events are evaluated and how actions are executed. 
     */
    evaluationMethod?: EvaluationMethod;
  }
  export interface DynamoDBAction {
    /**
     * The data type for the hash key (also called the partition key). You can specify the following values:    'STRING' - The hash key is a string.    'NUMBER' - The hash key is a number.   If you don't specify hashKeyType, the default value is 'STRING'.
     */
    hashKeyType?: DynamoKeyType;
    /**
     * The name of the hash key (also called the partition key). The hashKeyField value must match the partition key of the target DynamoDB table.
     */
    hashKeyField: DynamoKeyField;
    /**
     * The value of the hash key (also called the partition key).
     */
    hashKeyValue: DynamoKeyValue;
    /**
     * The data type for the range key (also called the sort key), You can specify the following values:    'STRING' - The range key is a string.    'NUMBER' - The range key is number.   If you don't specify rangeKeyField, the default value is 'STRING'.
     */
    rangeKeyType?: DynamoKeyType;
    /**
     * The name of the range key (also called the sort key). The rangeKeyField value must match the sort key of the target DynamoDB table. 
     */
    rangeKeyField?: DynamoKeyField;
    /**
     * The value of the range key (also called the sort key).
     */
    rangeKeyValue?: DynamoKeyValue;
    /**
     * The type of operation to perform. You can specify the following values:     'INSERT' - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.    'UPDATE' - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.    'DELETE' - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.   If you don't specify this parameter, AWS IoT Events triggers the 'INSERT' operation.
     */
    operation?: DynamoOperation;
    /**
     * The name of the DynamoDB column that receives the action payload. If you don't specify this parameter, the name of the DynamoDB column is payload.
     */
    payloadField?: DynamoKeyField;
    /**
     * The name of the DynamoDB table. The tableName value must match the table name of the target DynamoDB table. 
     */
    tableName: DynamoTableName;
    payload?: Payload;
  }
  export interface DynamoDBv2Action {
    /**
     * The name of the DynamoDB table.
     */
    tableName: DynamoTableName;
    payload?: Payload;
  }
  export type DynamoKeyField = string;
  export type DynamoKeyType = string;
  export type DynamoKeyValue = string;
  export type DynamoOperation = string;
  export type DynamoTableName = string;
  export type EvaluationMethod = "BATCH"|"SERIAL"|string;
  export interface Event {
    /**
     * The name of the event.
     */
    eventName: EventName;
    /**
     * Optional. The Boolean expression that, when TRUE, causes the actions to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
     */
    condition?: Condition;
    /**
     * The actions to be performed.
     */
    actions?: Actions;
  }
  export type EventName = string;
  export type Events = Event[];
  export interface FirehoseAction {
    /**
     * The name of the Kinesis Data Firehose delivery stream where the data is written.
     */
    deliveryStreamName: DeliveryStreamName;
    /**
     * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    separator?: FirehoseSeparator;
    /**
     * You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.
     */
    payload?: Payload;
  }
  export type FirehoseSeparator = string;
  export interface GetDetectorModelAnalysisResultsRequest {
    /**
     * The ID of the analysis result that you want to retrieve.
     */
    analysisId: AnalysisId;
    /**
     * The token that you can use to return the next set of results.
     */
    nextToken?: NextToken;
    /**
     * The maximum number of results to be returned per request.
     */
    maxResults?: MaxAnalysisResults;
  }
  export interface GetDetectorModelAnalysisResultsResponse {
    /**
     * Contains information about one or more analysis results.
     */
    analysisResults?: AnalysisResults;
    /**
     * The token that you can use to return the next set of results, or null if there are no more results.
     */
    nextToken?: NextToken;
  }
  export interface Input {
    /**
     * Information about the configuration of an input.
     */
    inputConfiguration?: InputConfiguration;
    /**
     * The definition of the input.
     */
    inputDefinition?: InputDefinition;
  }
  export type InputArn = string;
  export interface InputConfiguration {
    /**
     * The name of the input.
     */
    inputName: InputName;
    /**
     * A brief description of the input.
     */
    inputDescription?: InputDescription;
    /**
     * The ARN of the input.
     */
    inputArn: InputArn;
    /**
     * The time the input was created.
     */
    creationTime: Timestamp;
    /**
     * The last time the input was updated.
     */
    lastUpdateTime: Timestamp;
    /**
     * The status of the input.
     */
    status: InputStatus;
  }
  export interface InputDefinition {
    /**
     * The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using BatchPutMessage. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the condition expressions used by detectors that monitor this input. 
     */
    attributes: Attributes;
  }
  export type InputDescription = string;
  export type InputName = string;
  export type InputStatus = "CREATING"|"UPDATING"|"ACTIVE"|"DELETING"|string;
  export type InputSummaries = InputSummary[];
  export interface InputSummary {
    /**
     * The name of the input.
     */
    inputName?: InputName;
    /**
     * A brief description of the input.
     */
    inputDescription?: InputDescription;
    /**
     * The ARN of the input.
     */
    inputArn?: InputArn;
    /**
     * The time the input was created.
     */
    creationTime?: Timestamp;
    /**
     * The last time the input was updated.
     */
    lastUpdateTime?: Timestamp;
    /**
     * The status of the input.
     */
    status?: InputStatus;
  }
  export interface IotEventsAction {
    /**
     * The name of the AWS IoT Events input where the data is sent.
     */
    inputName: InputName;
    /**
     * You can configure the action payload when you send a message to an AWS IoT Events input.
     */
    payload?: Payload;
  }
  export interface IotSiteWiseAction {
    /**
     * A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
     */
    entryId?: AssetPropertyEntryId;
    /**
     * The ID of the asset that has the specified property.
     */
    assetId?: AssetId;
    /**
     * The ID of the asset property.
     */
    propertyId?: AssetPropertyId;
    /**
     * The alias of the asset property.
     */
    propertyAlias?: AssetPropertyAlias;
    /**
     * The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information. 
     */
    propertyValue: AssetPropertyValue;
  }
  export interface IotTopicPublishAction {
    /**
     * The MQTT topic of the message. You can use a string expression that includes variables ($variable.&lt;variable-name&gt;) and input values ($input.&lt;input-name&gt;.&lt;path-to-datum&gt;) as the topic string.
     */
    mqttTopic: MQTTTopic;
    /**
     * You can configure the action payload when you publish a message to an AWS IoT Core topic.
     */
    payload?: Payload;
  }
  export type KeyValue = string;
  export interface LambdaAction {
    /**
     * The ARN of the Lambda function that is executed.
     */
    functionArn: AmazonResourceName;
    /**
     * You can configure the action payload when you send a message to a Lambda function.
     */
    payload?: Payload;
  }
  export interface ListDetectorModelVersionsRequest {
    /**
     * The name of the detector model whose versions are returned.
     */
    detectorModelName: DetectorModelName;
    /**
     * The token that you can use to return the next set of results.
     */
    nextToken?: NextToken;
    /**
     * The maximum number of results to be returned per request.
     */
    maxResults?: MaxResults;
  }
  export interface ListDetectorModelVersionsResponse {
    /**
     * Summary information about the detector model versions.
     */
    detectorModelVersionSummaries?: DetectorModelVersionSummaries;
    /**
     * The token that you can use to return the next set of results, or null if there are no more results.
     */
    nextToken?: NextToken;
  }
  export interface ListDetectorModelsRequest {
    /**
     * The token that you can use to return the next set of results.
     */
    nextToken?: NextToken;
    /**
     * The maximum number of results to be returned per request.
     */
    maxResults?: MaxResults;
  }
  export interface ListDetectorModelsResponse {
    /**
     * Summary information about the detector models.
     */
    detectorModelSummaries?: DetectorModelSummaries;
    /**
     * The token that you can use to return the next set of results, or null if there are no more results.
     */
    nextToken?: NextToken;
  }
  export interface ListInputsRequest {
    /**
     * The token that you can use to return the next set of results.
     */
    nextToken?: NextToken;
    /**
     * The maximum number of results to be returned per request.
     */
    maxResults?: MaxResults;
  }
  export interface ListInputsResponse {
    /**
     * Summary information about the inputs.
     */
    inputSummaries?: InputSummaries;
    /**
     * The token that you can use to return the next set of results, or null if there are no more results.
     */
    nextToken?: NextToken;
  }
  export interface ListTagsForResourceRequest {
    /**
     * The ARN of the resource.
     */
    resourceArn: AmazonResourceName;
  }
  export interface ListTagsForResourceResponse {
    /**
     * The list of tags assigned to the resource.
     */
    tags?: Tags;
  }
  export type LoggingEnabled = boolean;
  export type LoggingLevel = "ERROR"|"INFO"|"DEBUG"|string;
  export interface LoggingOptions {
    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform logging.
     */
    roleArn: AmazonResourceName;
    /**
     * The logging level.
     */
    level: LoggingLevel;
    /**
     * If TRUE, logging is enabled for AWS IoT Events.
     */
    enabled: LoggingEnabled;
    /**
     * Information that identifies those detector models and their detectors (instances) for which the logging level is given.
     */
    detectorDebugOptions?: DetectorDebugOptions;
  }
  export type MQTTTopic = string;
  export type MaxAnalysisResults = number;
  export type MaxResults = number;
  export type NextToken = string;
  export interface OnEnterLifecycle {
    /**
     * Specifies the actions that are performed when the state is entered and the condition is TRUE.
     */
    events?: Events;
  }
  export interface OnExitLifecycle {
    /**
     * Specifies the actions that are performed when the state is exited and the condition is TRUE.
     */
    events?: Events;
  }
  export interface OnInputLifecycle {
    /**
     * Specifies the actions performed when the condition evaluates to TRUE.
     */
    events?: Events;
    /**
     * Specifies the actions performed, and the next state entered, when a condition evaluates to TRUE.
     */
    transitionEvents?: TransitionEvents;
  }
  export interface Payload {
    /**
     * The content of the payload. You can use a string expression that includes quoted strings ('&lt;string&gt;'), variables ($variable.&lt;variable-name&gt;), input values ($input.&lt;input-name&gt;.&lt;path-to-datum&gt;), string concatenations, and quoted strings that contain ${} as the content. The recommended maximum size of a content expression is 1 KB.
     */
    contentExpression: ContentExpression;
    /**
     * The value of the payload type can be either STRING or JSON.
     */
    type: PayloadType;
  }
  export type PayloadType = "STRING"|"JSON"|string;
  export interface PutLoggingOptionsRequest {
    /**
     * The new values of the AWS IoT Events logging options.
     */
    loggingOptions: LoggingOptions;
  }
  export type QueueUrl = string;
  export interface ResetTimerAction {
    /**
     * The name of the timer to reset.
     */
    timerName: TimerName;
  }
  export interface SNSTopicPublishAction {
    /**
     * The ARN of the Amazon SNS target where the message is sent.
     */
    targetArn: AmazonResourceName;
    /**
     * You can configure the action payload when you send a message as an Amazon SNS push notification.
     */
    payload?: Payload;
  }
  export type Seconds = number;
  export interface SetTimerAction {
    /**
     * The name of the timer.
     */
    timerName: TimerName;
    /**
     * The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds. 
     */
    seconds?: Seconds;
    /**
     * The duration of the timer, in seconds. You can use a string expression that includes numbers, variables ($variable.&lt;variable-name&gt;), and input values ($input.&lt;input-name&gt;.&lt;path-to-datum&gt;) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number. 
     */
    durationExpression?: VariableValue;
  }
  export interface SetVariableAction {
    /**
     * The name of the variable.
     */
    variableName: VariableName;
    /**
     * The new value of the variable.
     */
    value: VariableValue;
  }
  export interface SqsAction {
    /**
     * The URL of the SQS queue where the data is written.
     */
    queueUrl: QueueUrl;
    /**
     * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
     */
    useBase64?: UseBase64;
    /**
     * You can configure the action payload when you send a message to an Amazon SQS queue.
     */
    payload?: Payload;
  }
  export interface StartDetectorModelAnalysisRequest {
    detectorModelDefinition: DetectorModelDefinition;
  }
  export interface StartDetectorModelAnalysisResponse {
    /**
     * The ID that you can use to retrieve the analysis result.
     */
    analysisId?: AnalysisId;
  }
  export interface State {
    /**
     * The name of the state.
     */
    stateName: StateName;
    /**
     * When an input is received and the condition is TRUE, perform the specified actions.
     */
    onInput?: OnInputLifecycle;
    /**
     * When entering this state, perform these actions if the condition is TRUE.
     */
    onEnter?: OnEnterLifecycle;
    /**
     * When exiting this state, perform these actions if the specified condition is TRUE.
     */
    onExit?: OnExitLifecycle;
  }
  export type StateName = string;
  export type States = State[];
  export interface Tag {
    /**
     * The tag's key.
     */
    key: TagKey;
    /**
     * The tag's value.
     */
    value: TagValue;
  }
  export type TagKey = string;
  export type TagKeys = TagKey[];
  export interface TagResourceRequest {
    /**
     * The ARN of the resource.
     */
    resourceArn: AmazonResourceName;
    /**
     * The new or modified tags for the resource.
     */
    tags: Tags;
  }
  export interface TagResourceResponse {
  }
  export type TagValue = string;
  export type Tags = Tag[];
  export type TimerName = string;
  export type Timestamp = Date;
  export interface TransitionEvent {
    /**
     * The name of the transition event.
     */
    eventName: EventName;
    /**
     * Required. A Boolean expression that when TRUE causes the actions to be performed and the nextState to be entered.
     */
    condition: Condition;
    /**
     * The actions to be performed.
     */
    actions?: Actions;
    /**
     * The next state to enter.
     */
    nextState: StateName;
  }
  export type TransitionEvents = TransitionEvent[];
  export interface UntagResourceRequest {
    /**
     * The ARN of the resource.
     */
    resourceArn: AmazonResourceName;
    /**
     * A list of the keys of the tags to be removed from the resource.
     */
    tagKeys: TagKeys;
  }
  export interface UntagResourceResponse {
  }
  export interface UpdateDetectorModelRequest {
    /**
     * The name of the detector model that is updated.
     */
    detectorModelName: DetectorModelName;
    /**
     * Information that defines how a detector operates.
     */
    detectorModelDefinition: DetectorModelDefinition;
    /**
     * A brief description of the detector model.
     */
    detectorModelDescription?: DetectorModelDescription;
    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    roleArn: AmazonResourceName;
    /**
     * Information about the order in which events are evaluated and how actions are executed. 
     */
    evaluationMethod?: EvaluationMethod;
  }
  export interface UpdateDetectorModelResponse {
    /**
     * Information about how the detector model is configured.
     */
    detectorModelConfiguration?: DetectorModelConfiguration;
  }
  export interface UpdateInputRequest {
    /**
     * The name of the input you want to update.
     */
    inputName: InputName;
    /**
     * A brief description of the input.
     */
    inputDescription?: InputDescription;
    /**
     * The definition of the input.
     */
    inputDefinition: InputDefinition;
  }
  export interface UpdateInputResponse {
    /**
     * Information about the configuration of the input.
     */
    inputConfiguration?: InputConfiguration;
  }
  export type UseBase64 = boolean;
  export type VariableName = string;
  export type VariableValue = string;
  /**
   * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
   */
  export type apiVersion = "2018-07-27"|"latest"|string;
  export interface ClientApiVersions {
    /**
     * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
     */
    apiVersion?: apiVersion;
  }
  export type ClientConfiguration = ServiceConfigurationOptions & ClientApiVersions;
  /**
   * Contains interfaces for use with the IoTEvents client.
   */
  export import Types = IoTEvents;
}
export = IoTEvents;
