# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dlf_nova_play_my_own_music']

package_data = \
{'': ['*'], 'dlf_nova_play_my_own_music': ['model_saves/*']}

install_requires = \
['Keras>=2.3.1,<3.0.0',
 'click>=7.1.2,<8.0.0',
 'numpy>=1.18.4,<2.0.0',
 'pandas>=1.0.3,<2.0.0',
 'pydub>=0.24.0,<0.25.0',
 'python-vlc>=3.0.9113,<4.0.0',
 'sklearn>=0.0,<0.1',
 'spafe>=0.1.2,<0.2.0',
 'spotipy>=2.12.0,<3.0.0']

entry_points = \
{'console_scripts': ['dlfnova = dlf_nova_play_my_own_music.cli:main']}

setup_kwargs = {
    'name': 'dlf-nova-play-my-own-music',
    'version': '0.1.3',
    'description': 'Switches to Spotify if music is played on DLF Nova radio stream.',
    'long_description': '[![AlxndrJhn](https://circleci.com/gh/AlxndrJhn/DLF-Nova-Play-My-Own-Music.svg?style=svg)](https://app.circleci.com/pipelines/github/AlxndrJhn/DLF-Nova-Play-My-Own-Music)\n# DLF-Nova Play My Own Music\nThe [DLF nova](https://www.deutschlandfunknova.de/) [playlist](https://open.spotify.com/playlist/5qE59dOhR3JtRE8YThsjkO) is just a few hours long, leading to a lot of repetitions if you listen long enough. This is kind of annoying, because the news-bits are quite interesting.\nSo I programmed a script that detects music/news and switches to spotify during the music parts on the radio.\n\nThis project is work in progress, I want to make it easier to use.\n\n# Requirements\n- VLC https://www.videolan.org/vlc/\n- spotify account https://www.spotify.com\n    - spotify client ID: https://developer.spotify.com/dashboard/applications\n- python 3.7\n\n# Get started\n1. To use the Spotify API a `client id` and `client secret` are needed, it can be created [here](https://developer.spotify.com/dashboard/applications)\n    1. Save `SPOTIPY_CLIENT_ID` in your environment (example `1a2ef9787cc1638261545d6dadb2315`)\n    2. Save `SPOTIPY_CLIENT_SECRET` in your environment (example `2c12e5161ace0476c8f2abc70a924ac76`)\n2. Find your spotify username and insert it in `spotify_username` in `online_prototype.py`\n3. Install with `pip install DLF-Nova-Play-My-Own-Music`\n4. `dlfnova -su my.spotifyusername` to start\n\nAfter some setup messages it should generate logs like this\n\n```\n19:20:34: Class:  music, prob.:  96%, filtered signal:   0%, AI performance:  3.3Hz\n19:20:36: Class:  music, prob.:  66%, filtered signal:   0%, AI performance:  3.5Hz\n19:20:39: Class:   news, prob.:  84%, filtered signal:  70%, AI performance:  3.3Hz\n19:20:42: Class:   news, prob.:  99%, filtered signal:  91%, AI performance:  3.3Hz switch to radio\n[00000282eb2c49d0] prefetch stream error: unimplemented query (264) in control\n19:20:44: Class:   news, prob.: 100%, filtered signal:  97%, AI performance:  2.8Hz\n19:20:47: Class:   news, prob.: 100%, filtered signal:  99%, AI performance:  3.4Hz\n19:20:49: Class:   news, prob.: 100%, filtered signal:  100%, AI performance:  3.3Hz\n```\n\n# Technical details\nI trained a simple deep learning model to classify an audio single as "music" or "news", using this classifications, I switch between my spotify device and the online radio stream.\n\n## Dataset\nThe dataset consists of:\n- 500MB of DLF nova podcasts from https://www.deutschlandfunknova.de/podcasts\n- [the DLF nova spotify playlist](https://open.spotify.com/playlist/5qE59dOhR3JtRE8YThsjkO) using [spotdl](https://pypi.org/project/spotdl/)\n- stream chunks\n\nTo split training (80%) and test (20%) datasets, the files are separated randomly before splitting into chunks.\nThe mp3 files are split into 10s chunks (no overlapping) at 44100Hz.\nEach chunk is converted to the feature vector, making the dataset files relatively small.\n\n## Input vector/features\nBased on this [this medium article](https://medium.com/@mikesmales/sound-classification-using-deep-learning-8bc2aa1990b7) and [this article](https://opensource.com/article/19/9/audio-processing-machine-learning-python) I chose three features: `MFCC` (related to speech/music separation, from [librosa](https://pypi.org/project/librosa/)), `GFCC` (typical used for speaker recognition, from [spafe](https://pypi.org/project/spafe/)) and `onset_strength` (related to beat detection in music, from [librosa](https://pypi.org/project/librosa/)). It results in a 256 dimensional vector.\n\n```python\n# feature vector\nmfccs = librosa.feature.mfcc(y=audio, sr=sample_rate, n_mfcc=20)\nmfccs_scaled = np.mean(mfccs.T, axis=0)\n\ntry:\n    gfccs = gfcc(audio, num_ceps=20)\n    gfccs_scaled = np.mean(gfccs, axis=0)\nexcept Exception:\n    gfccs_scaled = np.zeros(20)\n\nhop_length = 2048\noenv = librosa.onset.onset_strength(y=audio, sr=sample_rate, hop_length=hop_length)\n\nreturn np.hstack((mfccs_scaled, gfccs_scaled, oenv))\n```\n\nWhere `audio` is always a 10 second audio chunk at 44100Hz sample rate.\n\n## Deep learning model\nI used the [Keras](https://pypi.org/project/Keras/) model from [this medium article](https://medium.com/@mikesmales/sound-classification-using-deep-learning-8bc2aa1990b7)\n\n```python\nmodel = Sequential()\n\nmodel.add(Dense(256, input_shape=(input_size,)))\nmodel.add(Activation("relu"))\nmodel.add(Dropout(0.5))\n\nmodel.add(Dense(256))\nmodel.add(Activation("relu"))\nmodel.add(Dropout(0.5))\n\nmodel.add(Dense(num_labels))\nmodel.add(Activation("softmax"))\n\nmodel.compile(loss="categorical_crossentropy", metrics=["accuracy"], optimizer="adam")\n```\n\nwhere `input_size` is 256.\n\nIt trained for 100 epochs, default learning rate, batch size 256 and saved the weights with the lowest validation loss.\n\n## Performance\nIt achieved 99.8% accuracy during training and 98% for the validation set.\n\n## Switching\nThe script `online_prototype.py` registers through the spotify API and requests with OAUTH permission to see the devices and modify the player state. It downloads the DLF stream in 40kB chunks and outputs an classification every 2 to 3 seconds. This signal is smoothed and it triggers switching events. The radio is streamed via VLC.\n\n# Known issues\n- Some songs are classified as news sometimes, due to the simple model. Happens with rap especially. The news sometimes have a beat in the background as well.\n- `[00000282eb2c49d0] prefetch stream error: ...` logs, they come from VLC\n\n# TODO\n1. Train better model for fewer switching errors\n2. Fading the sound during the switch event\n',
    'author': 'Alexander Jahn',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/AlxndrJhn/DLF-Nova-Play-My-Own-Music',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
