import unittest

from centralized_pre_commit_conf.update_gitignore import get_updated_gitignore_content

GITIGNORE_INFO_TEXT = "# fervpierpvjepvjpvjepvjperjverpovpeorvpor"


class TestUpdateGitignore(unittest.TestCase):
    def test_nothing(self) -> None:
        text, mode = get_updated_gitignore_content(
            "", {"a", "b", "c"}, GITIGNORE_INFO_TEXT
        )
        assert mode == "a"
        assert (
            text
            == f"""{GITIGNORE_INFO_TEXT}
a
b
c
"""
        )

    def test_something(self) -> None:
        text, mode = get_updated_gitignore_content(
            "d\ne\n", {"a", "b", "c"}, GITIGNORE_INFO_TEXT
        )
        assert mode == "a"
        assert (
            text
            == f"""
{GITIGNORE_INFO_TEXT}
a
b
c
"""
        )

    def test_old_cppc_data(self) -> None:
        text, mode = get_updated_gitignore_content(
            f"d\ne\n{GITIGNORE_INFO_TEXT}\nf\ng\n", {"a", "b", "c"}, GITIGNORE_INFO_TEXT
        )
        assert mode == "w"
        assert (
            text
            == f"""d
e

{GITIGNORE_INFO_TEXT}
a
b
c
f
g
"""
        )

    def test_duplicated_old_cppc_data(self) -> None:
        text, mode = get_updated_gitignore_content(
            f"""d
e
{GITIGNORE_INFO_TEXT}
f
g

{GITIGNORE_INFO_TEXT}
h
i
""",
            {"a", "b", "c"},
            GITIGNORE_INFO_TEXT,
        )
        assert mode == "w"
        assert (
            text
            == f"""d
e

{GITIGNORE_INFO_TEXT}
a
b
c
f
g

h
i
"""
        )

    def test_real_data(self) -> None:
        text, mode = get_updated_gitignore_content(
            f""".idea/
*.egg-info/

{GITIGNORE_INFO_TEXT}
.isort.cfg
.pylintrc
.flake8
.pre-commit-config.yaml

build/
dist/
""",
            {".clang-format", ".clang-tidy", ".csslintrc"},
            GITIGNORE_INFO_TEXT,
        )
        assert mode == "w"
        assert (
            text
            == f""".idea/
*.egg-info/


{GITIGNORE_INFO_TEXT}
.clang-format
.clang-tidy
.csslintrc
.isort.cfg
.pylintrc
.flake8
.pre-commit-config.yaml

build/
dist/
"""
        )
