"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5208
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.virtualization_base_network_relationship import VirtualizationBaseNetworkRelationship
    from intersight.model.virtualization_vmware_cluster_relationship import VirtualizationVmwareClusterRelationship
    from intersight.model.virtualization_vmware_datacenter_relationship import VirtualizationVmwareDatacenterRelationship
    from intersight.model.virtualization_vmware_datastore_relationship import VirtualizationVmwareDatastoreRelationship
    from intersight.model.virtualization_vmware_folder_relationship import VirtualizationVmwareFolderRelationship
    from intersight.model.virtualization_vmware_host_relationship import VirtualizationVmwareHostRelationship
    from intersight.model.virtualization_vmware_remote_display_info import VirtualizationVmwareRemoteDisplayInfo
    from intersight.model.virtualization_vmware_vm_cpu_share_info import VirtualizationVmwareVmCpuShareInfo
    from intersight.model.virtualization_vmware_vm_cpu_socket_info import VirtualizationVmwareVmCpuSocketInfo
    from intersight.model.virtualization_vmware_vm_disk_commit_info import VirtualizationVmwareVmDiskCommitInfo
    from intersight.model.virtualization_vmware_vm_memory_share_info import VirtualizationVmwareVmMemoryShareInfo
    globals()['VirtualizationBaseNetworkRelationship'] = VirtualizationBaseNetworkRelationship
    globals()['VirtualizationVmwareClusterRelationship'] = VirtualizationVmwareClusterRelationship
    globals()['VirtualizationVmwareDatacenterRelationship'] = VirtualizationVmwareDatacenterRelationship
    globals()['VirtualizationVmwareDatastoreRelationship'] = VirtualizationVmwareDatastoreRelationship
    globals()['VirtualizationVmwareFolderRelationship'] = VirtualizationVmwareFolderRelationship
    globals()['VirtualizationVmwareHostRelationship'] = VirtualizationVmwareHostRelationship
    globals()['VirtualizationVmwareRemoteDisplayInfo'] = VirtualizationVmwareRemoteDisplayInfo
    globals()['VirtualizationVmwareVmCpuShareInfo'] = VirtualizationVmwareVmCpuShareInfo
    globals()['VirtualizationVmwareVmCpuSocketInfo'] = VirtualizationVmwareVmCpuSocketInfo
    globals()['VirtualizationVmwareVmDiskCommitInfo'] = VirtualizationVmwareVmDiskCommitInfo
    globals()['VirtualizationVmwareVmMemoryShareInfo'] = VirtualizationVmwareVmMemoryShareInfo


class VirtualizationVmwareVirtualMachineAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
        },
        ('object_type',): {
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
        },
        ('guest_state',): {
            'UNKNOWN': "Unknown",
            'NOTRUNNING': "NotRunning",
            'RESETTING': "Resetting",
            'RUNNING': "Running",
            'SHUTTINGDOWN': "ShuttingDown",
            'STANDBY': "Standby",
        },
    }

    validations = {
        ('instance_uuid',): {
            'regex': {
                'pattern': r'^$|^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'annotation': (str,),  # noqa: E501
            'config_name': (str,),  # noqa: E501
            'connection_state': (str,),  # noqa: E501
            'cpu_hot_add_enabled': (bool,),  # noqa: E501
            'cpu_shares': (VirtualizationVmwareVmCpuShareInfo,),  # noqa: E501
            'cpu_socket_info': (VirtualizationVmwareVmCpuSocketInfo,),  # noqa: E501
            'custom_attributes': ([str], none_type,),  # noqa: E501
            'default_power_off_type': (str,),  # noqa: E501
            'dhcp_enabled': (bool,),  # noqa: E501
            'disk_commit_info': (VirtualizationVmwareVmDiskCommitInfo,),  # noqa: E501
            'dns_server_list': ([str], none_type,),  # noqa: E501
            'dns_suffix_list': ([str], none_type,),  # noqa: E501
            'extra_config': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'folder': (str,),  # noqa: E501
            'guest_state': (str,),  # noqa: E501
            'host_compatibility': (str,),  # noqa: E501
            'instance_uuid': (str,),  # noqa: E501
            'inventory_path': (str,),  # noqa: E501
            'is_template': (bool,),  # noqa: E501
            'mac_address': ([str], none_type,),  # noqa: E501
            'mem_shares': (VirtualizationVmwareVmMemoryShareInfo,),  # noqa: E501
            'memory_hot_add_enabled': (bool,),  # noqa: E501
            'network_count': (int,),  # noqa: E501
            'port_groups': ([str], none_type,),  # noqa: E501
            'protected_vm': (bool,),  # noqa: E501
            'remote_display_info': (VirtualizationVmwareRemoteDisplayInfo,),  # noqa: E501
            'remote_display_vnc_enabled': (bool,),  # noqa: E501
            'resource_pool': (str,),  # noqa: E501
            'resource_pool_owner': (str,),  # noqa: E501
            'resource_pool_parent': (str,),  # noqa: E501
            'tool_running_status': (str,),  # noqa: E501
            'tools_version': (str,),  # noqa: E501
            'virtual_disks': ([int], none_type,),  # noqa: E501
            'virtual_network_interfaces': ([int], none_type,),  # noqa: E501
            'vm_disk_count': (int,),  # noqa: E501
            'vm_overall_status': (str,),  # noqa: E501
            'vm_path': (str,),  # noqa: E501
            'vm_version': (str,),  # noqa: E501
            'vm_vnic_count': (int,),  # noqa: E501
            'vnic_device_config_id': (str,),  # noqa: E501
            'cluster': (VirtualizationVmwareClusterRelationship,),  # noqa: E501
            'datacenter': (VirtualizationVmwareDatacenterRelationship,),  # noqa: E501
            'datastores': ([VirtualizationVmwareDatastoreRelationship], none_type,),  # noqa: E501
            'host': (VirtualizationVmwareHostRelationship,),  # noqa: E501
            'networks': ([VirtualizationBaseNetworkRelationship], none_type,),  # noqa: E501
            'parent_folder': (VirtualizationVmwareFolderRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'annotation': 'Annotation',  # noqa: E501
        'config_name': 'ConfigName',  # noqa: E501
        'connection_state': 'ConnectionState',  # noqa: E501
        'cpu_hot_add_enabled': 'CpuHotAddEnabled',  # noqa: E501
        'cpu_shares': 'CpuShares',  # noqa: E501
        'cpu_socket_info': 'CpuSocketInfo',  # noqa: E501
        'custom_attributes': 'CustomAttributes',  # noqa: E501
        'default_power_off_type': 'DefaultPowerOffType',  # noqa: E501
        'dhcp_enabled': 'DhcpEnabled',  # noqa: E501
        'disk_commit_info': 'DiskCommitInfo',  # noqa: E501
        'dns_server_list': 'DnsServerList',  # noqa: E501
        'dns_suffix_list': 'DnsSuffixList',  # noqa: E501
        'extra_config': 'ExtraConfig',  # noqa: E501
        'folder': 'Folder',  # noqa: E501
        'guest_state': 'GuestState',  # noqa: E501
        'host_compatibility': 'HostCompatibility',  # noqa: E501
        'instance_uuid': 'InstanceUuid',  # noqa: E501
        'inventory_path': 'InventoryPath',  # noqa: E501
        'is_template': 'IsTemplate',  # noqa: E501
        'mac_address': 'MacAddress',  # noqa: E501
        'mem_shares': 'MemShares',  # noqa: E501
        'memory_hot_add_enabled': 'MemoryHotAddEnabled',  # noqa: E501
        'network_count': 'NetworkCount',  # noqa: E501
        'port_groups': 'PortGroups',  # noqa: E501
        'protected_vm': 'ProtectedVm',  # noqa: E501
        'remote_display_info': 'RemoteDisplayInfo',  # noqa: E501
        'remote_display_vnc_enabled': 'RemoteDisplayVncEnabled',  # noqa: E501
        'resource_pool': 'ResourcePool',  # noqa: E501
        'resource_pool_owner': 'ResourcePoolOwner',  # noqa: E501
        'resource_pool_parent': 'ResourcePoolParent',  # noqa: E501
        'tool_running_status': 'ToolRunningStatus',  # noqa: E501
        'tools_version': 'ToolsVersion',  # noqa: E501
        'virtual_disks': 'VirtualDisks',  # noqa: E501
        'virtual_network_interfaces': 'VirtualNetworkInterfaces',  # noqa: E501
        'vm_disk_count': 'VmDiskCount',  # noqa: E501
        'vm_overall_status': 'VmOverallStatus',  # noqa: E501
        'vm_path': 'VmPath',  # noqa: E501
        'vm_version': 'VmVersion',  # noqa: E501
        'vm_vnic_count': 'VmVnicCount',  # noqa: E501
        'vnic_device_config_id': 'VnicDeviceConfigId',  # noqa: E501
        'cluster': 'Cluster',  # noqa: E501
        'datacenter': 'Datacenter',  # noqa: E501
        'datastores': 'Datastores',  # noqa: E501
        'host': 'Host',  # noqa: E501
        'networks': 'Networks',  # noqa: E501
        'parent_folder': 'ParentFolder',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """VirtualizationVmwareVirtualMachineAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.VmwareVirtualMachine", must be one of ["virtualization.VmwareVirtualMachine", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.VmwareVirtualMachine", must be one of ["virtualization.VmwareVirtualMachine", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            annotation (str): List of annotations provided to this VM by user. Can be long.. [optional]  # noqa: E501
            config_name (str): The configuration name for this VM. This maybe the same as the guest hostname.. [optional]  # noqa: E501
            connection_state (str): Shows if virtual machine is connected to vCenter. Values are Connected, Disconnected, Orphaned, Inaccessible, and Invalid.. [optional]  # noqa: E501
            cpu_hot_add_enabled (bool): Indicates if the capability to add CPUs to a running VM is enabled.. [optional]  # noqa: E501
            cpu_shares (VirtualizationVmwareVmCpuShareInfo): [optional]  # noqa: E501
            cpu_socket_info (VirtualizationVmwareVmCpuSocketInfo): [optional]  # noqa: E501
            custom_attributes ([str], none_type): [optional]  # noqa: E501
            default_power_off_type (str): Indicates how the VM will be powered off (soft, hard etc.).. [optional]  # noqa: E501
            dhcp_enabled (bool): Shows if DHCP is used for IP/DNS on this VM.. [optional]  # noqa: E501
            disk_commit_info (VirtualizationVmwareVmDiskCommitInfo): [optional]  # noqa: E501
            dns_server_list ([str], none_type): [optional]  # noqa: E501
            dns_suffix_list ([str], none_type): [optional]  # noqa: E501
            extra_config (bool, date, datetime, dict, float, int, list, str, none_type): Additional custom configuration settings applied to this VM. It is a set of name-value pairs stored as json.. [optional]  # noqa: E501
            folder (str): The folder name associated with this VM.. [optional]  # noqa: E501
            guest_state (str): The state of the guest OS running on this VM. Could be running, not running etc. * `Unknown` - Indicates that the guest OS state cannot be determined. * `NotRunning` - Indicates that the guest OS is not running. * `Resetting` - Indicates that the guest OS is resetting. * `Running` - Indicates that the guest OS is running normally. * `ShuttingDown` - Indicates that the guest OS is shutting down. * `Standby` - Indicates that the guest OS is in standby mode.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            host_compatibility (str): Minimum host ESXi version required for the virtual machine.. [optional]  # noqa: E501
            instance_uuid (str): UUID assigned by vCenter to every VM.. [optional]  # noqa: E501
            inventory_path (str): Inventory path to the VM. Example - /DC/vm/folder/VMName.. [optional]  # noqa: E501
            is_template (bool): If true, indicates that the entity refers to a template of a virtual machine and not a real virtual machine.. [optional]  # noqa: E501
            mac_address ([str], none_type): [optional]  # noqa: E501
            mem_shares (VirtualizationVmwareVmMemoryShareInfo): [optional]  # noqa: E501
            memory_hot_add_enabled (bool): Adding memory to a running VM.. [optional]  # noqa: E501
            network_count (int): Indicates how many networks are used by this VM.. [optional]  # noqa: E501
            port_groups ([str], none_type): [optional]  # noqa: E501
            protected_vm (bool): Shows if this is a protected VM. VMs can be in protection groups.. [optional]  # noqa: E501
            remote_display_info (VirtualizationVmwareRemoteDisplayInfo): [optional]  # noqa: E501
            remote_display_vnc_enabled (bool): Shows if support for a remote VNC access is enabled.. [optional]  # noqa: E501
            resource_pool (str): Name of the resource pool to which this VM belongs (optional).. [optional]  # noqa: E501
            resource_pool_owner (str): Who owns the resource pool.. [optional]  # noqa: E501
            resource_pool_parent (str): The parent of the current resource pool to which this VM belongs.. [optional]  # noqa: E501
            tool_running_status (str): Indicates if guest tools are running on this VM. Could be set to guestToolNotRunning or guestToolsRunning.. [optional]  # noqa: E501
            tools_version (str): The version of the guest tools, usually not specified.. [optional]  # noqa: E501
            virtual_disks ([int], none_type): [optional]  # noqa: E501
            virtual_network_interfaces ([int], none_type): [optional]  # noqa: E501
            vm_disk_count (int): Shows the number of disks assigned to this VM.. [optional]  # noqa: E501
            vm_overall_status (str): The operational state of the VM. Could be Available, Provisioned, Maintenance mode, Deleting, etc.. [optional]  # noqa: E501
            vm_path (str): Path to the vmx file of the VM. Example - [datastore3] VCSA-134/VCSA-134.vmx.. [optional]  # noqa: E501
            vm_version (str): Information about the version of this VM (vmx-09, vmx-11 etc.).. [optional]  # noqa: E501
            vm_vnic_count (int): How many vnics are present.. [optional]  # noqa: E501
            vnic_device_config_id (str): Information related to the guest info's VNIC virtual device. It is a comma-separated list.. [optional]  # noqa: E501
            cluster (VirtualizationVmwareClusterRelationship): [optional]  # noqa: E501
            datacenter (VirtualizationVmwareDatacenterRelationship): [optional]  # noqa: E501
            datastores ([VirtualizationVmwareDatastoreRelationship], none_type): An array of relationships to virtualizationVmwareDatastore resources.. [optional]  # noqa: E501
            host (VirtualizationVmwareHostRelationship): [optional]  # noqa: E501
            networks ([VirtualizationBaseNetworkRelationship], none_type): An array of relationships to virtualizationBaseNetwork resources.. [optional]  # noqa: E501
            parent_folder (VirtualizationVmwareFolderRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.VmwareVirtualMachine")
        object_type = kwargs.get('object_type', "virtualization.VmwareVirtualMachine")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
