"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5208
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.equipment_locator_led_relationship import EquipmentLocatorLedRelationship
    from intersight.model.firmware_running_firmware_relationship import FirmwareRunningFirmwareRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.storage_controller_relationship import StorageControllerRelationship
    from intersight.model.storage_enclosure_relationship import StorageEnclosureRelationship
    from intersight.model.storage_physical_disk_extension_relationship import StoragePhysicalDiskExtensionRelationship
    from intersight.model.storage_sas_port_relationship import StorageSasPortRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['EquipmentLocatorLedRelationship'] = EquipmentLocatorLedRelationship
    globals()['FirmwareRunningFirmwareRelationship'] = FirmwareRunningFirmwareRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['StorageControllerRelationship'] = StorageControllerRelationship
    globals()['StorageEnclosureRelationship'] = StorageEnclosureRelationship
    globals()['StoragePhysicalDiskExtensionRelationship'] = StoragePhysicalDiskExtensionRelationship
    globals()['StorageSasPortRelationship'] = StorageSasPortRelationship


class StoragePhysicalDiskAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
        },
        ('object_type',): {
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'background_operations': (str,),  # noqa: E501
            'block_size': (str,),  # noqa: E501
            'bootable': (str,),  # noqa: E501
            'configuration_checkpoint': (str,),  # noqa: E501
            'configuration_state': (str,),  # noqa: E501
            'disabled_for_removal': (bool,),  # noqa: E501
            'discovered_path': (str,),  # noqa: E501
            'disk_id': (str,),  # noqa: E501
            'disk_state': (str,),  # noqa: E501
            'drive_firmware': (str,),  # noqa: E501
            'drive_state': (str,),  # noqa: E501
            'encryption_status': (str,),  # noqa: E501
            'failure_predicted': (bool,),  # noqa: E501
            'fde_capable': (str,),  # noqa: E501
            'hot_spare_type': (str,),  # noqa: E501
            'indicator_led': (str,),  # noqa: E501
            'link_speed': (str,),  # noqa: E501
            'link_state': (str,),  # noqa: E501
            'maximum_operating_temperature': (int,),  # noqa: E501
            'media_error_count': (int,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'non_coerced_size_bytes': (int,),  # noqa: E501
            'num_blocks': (str,),  # noqa: E501
            'oper_power_state': (str,),  # noqa: E501
            'oper_qualifier_reason': (str,),  # noqa: E501
            'operability': (str,),  # noqa: E501
            'operating_temperature': (int,),  # noqa: E501
            'percent_life_left': (int,),  # noqa: E501
            'percent_reserved_capacity_consumed': (int,),  # noqa: E501
            'performance_percent': (int,),  # noqa: E501
            'physical_block_size': (str,),  # noqa: E501
            'pid': (str,),  # noqa: E501
            'power_cycle_count': (int,),  # noqa: E501
            'power_on_hours': (int,),  # noqa: E501
            'predicted_media_life_left_percent': (int,),  # noqa: E501
            'predictive_failure_count': (int,),  # noqa: E501
            'protocol': (str,),  # noqa: E501
            'raw_size': (str,),  # noqa: E501
            'read_error_count_threshold': (int,),  # noqa: E501
            'read_io_error_count': (int,),  # noqa: E501
            'secured': (str,),  # noqa: E501
            'size': (str,),  # noqa: E501
            'thermal': (str,),  # noqa: E501
            'threshold_operating_temperature': (int,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'variant_type': (str,),  # noqa: E501
            'wear_status_in_days': (int,),  # noqa: E501
            'write_error_count_threshold': (int,),  # noqa: E501
            'write_io_error_count': (int,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'locator_led': (EquipmentLocatorLedRelationship,),  # noqa: E501
            'physical_disk_extensions': ([StoragePhysicalDiskExtensionRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'running_firmware': ([FirmwareRunningFirmwareRelationship], none_type,),  # noqa: E501
            'sas_ports': ([StorageSasPortRelationship], none_type,),  # noqa: E501
            'storage_controller': (StorageControllerRelationship,),  # noqa: E501
            'storage_enclosure': (StorageEnclosureRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'background_operations': 'BackgroundOperations',  # noqa: E501
        'block_size': 'BlockSize',  # noqa: E501
        'bootable': 'Bootable',  # noqa: E501
        'configuration_checkpoint': 'ConfigurationCheckpoint',  # noqa: E501
        'configuration_state': 'ConfigurationState',  # noqa: E501
        'disabled_for_removal': 'DisabledForRemoval',  # noqa: E501
        'discovered_path': 'DiscoveredPath',  # noqa: E501
        'disk_id': 'DiskId',  # noqa: E501
        'disk_state': 'DiskState',  # noqa: E501
        'drive_firmware': 'DriveFirmware',  # noqa: E501
        'drive_state': 'DriveState',  # noqa: E501
        'encryption_status': 'EncryptionStatus',  # noqa: E501
        'failure_predicted': 'FailurePredicted',  # noqa: E501
        'fde_capable': 'FdeCapable',  # noqa: E501
        'hot_spare_type': 'HotSpareType',  # noqa: E501
        'indicator_led': 'IndicatorLed',  # noqa: E501
        'link_speed': 'LinkSpeed',  # noqa: E501
        'link_state': 'LinkState',  # noqa: E501
        'maximum_operating_temperature': 'MaximumOperatingTemperature',  # noqa: E501
        'media_error_count': 'MediaErrorCount',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'non_coerced_size_bytes': 'NonCoercedSizeBytes',  # noqa: E501
        'num_blocks': 'NumBlocks',  # noqa: E501
        'oper_power_state': 'OperPowerState',  # noqa: E501
        'oper_qualifier_reason': 'OperQualifierReason',  # noqa: E501
        'operability': 'Operability',  # noqa: E501
        'operating_temperature': 'OperatingTemperature',  # noqa: E501
        'percent_life_left': 'PercentLifeLeft',  # noqa: E501
        'percent_reserved_capacity_consumed': 'PercentReservedCapacityConsumed',  # noqa: E501
        'performance_percent': 'PerformancePercent',  # noqa: E501
        'physical_block_size': 'PhysicalBlockSize',  # noqa: E501
        'pid': 'Pid',  # noqa: E501
        'power_cycle_count': 'PowerCycleCount',  # noqa: E501
        'power_on_hours': 'PowerOnHours',  # noqa: E501
        'predicted_media_life_left_percent': 'PredictedMediaLifeLeftPercent',  # noqa: E501
        'predictive_failure_count': 'PredictiveFailureCount',  # noqa: E501
        'protocol': 'Protocol',  # noqa: E501
        'raw_size': 'RawSize',  # noqa: E501
        'read_error_count_threshold': 'ReadErrorCountThreshold',  # noqa: E501
        'read_io_error_count': 'ReadIoErrorCount',  # noqa: E501
        'secured': 'Secured',  # noqa: E501
        'size': 'Size',  # noqa: E501
        'thermal': 'Thermal',  # noqa: E501
        'threshold_operating_temperature': 'ThresholdOperatingTemperature',  # noqa: E501
        'type': 'Type',  # noqa: E501
        'variant_type': 'VariantType',  # noqa: E501
        'wear_status_in_days': 'WearStatusInDays',  # noqa: E501
        'write_error_count_threshold': 'WriteErrorCountThreshold',  # noqa: E501
        'write_io_error_count': 'WriteIoErrorCount',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'locator_led': 'LocatorLed',  # noqa: E501
        'physical_disk_extensions': 'PhysicalDiskExtensions',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'running_firmware': 'RunningFirmware',  # noqa: E501
        'sas_ports': 'SasPorts',  # noqa: E501
        'storage_controller': 'StorageController',  # noqa: E501
        'storage_enclosure': 'StorageEnclosure',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StoragePhysicalDiskAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "storage.PhysicalDisk", must be one of ["storage.PhysicalDisk", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "storage.PhysicalDisk", must be one of ["storage.PhysicalDisk", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            background_operations (str): List of background operations underway.. [optional]  # noqa: E501
            block_size (str): The block size of the physical disk in bytes.. [optional]  # noqa: E501
            bootable (str): This field identifies the disk drive as bootable if set to true.. [optional]  # noqa: E501
            configuration_checkpoint (str): The current configuration checkpoint of the physical disk.. [optional]  # noqa: E501
            configuration_state (str): The current configuration state of the physical disk.. [optional]  # noqa: E501
            disabled_for_removal (bool): The physical disk is disabled for removal.. [optional]  # noqa: E501
            discovered_path (str): The discovered path of the physical disk.. [optional]  # noqa: E501
            disk_id (str): This field identifies the ID assigned to physical disks.. [optional]  # noqa: E501
            disk_state (str): This field identifies the health of the disk.. [optional]  # noqa: E501
            drive_firmware (str): This field identifies the disk firmware running in the disk.. [optional]  # noqa: E501
            drive_state (str): The drive state as reported by the controller.. [optional]  # noqa: E501
            encryption_status (str): Encryption status of the physical disk.. [optional]  # noqa: E501
            failure_predicted (bool): Possibility of physical disk failure.. [optional]  # noqa: E501
            fde_capable (str): Full-Disk Encryption capability parameter of the physical disk.. [optional]  # noqa: E501
            hot_spare_type (str): Type of hotspare configured on the physical disk.. [optional]  # noqa: E501
            indicator_led (str): Status of the locator LED corresponding to the physical disk.. [optional]  # noqa: E501
            link_speed (str): The speed of the link between the drive and the controller.. [optional]  # noqa: E501
            link_state (str): The current link state of the physical disk.. [optional]  # noqa: E501
            maximum_operating_temperature (int): Maximum operating temperature of drive in Celsius.. [optional]  # noqa: E501
            media_error_count (int): Media error count on the physical disk.. [optional]  # noqa: E501
            name (str): Detailed name of the physical disk.. [optional]  # noqa: E501
            non_coerced_size_bytes (int): Physical disk non-coerced size in bytes.. [optional]  # noqa: E501
            num_blocks (str): The number of blocks present on the physical disk.. [optional]  # noqa: E501
            oper_power_state (str): Operational power of the physical disk.. [optional]  # noqa: E501
            oper_qualifier_reason (str): For certain states, indicates the reason why the operState is in that state.. [optional]  # noqa: E501
            operability (str): This field identifies the disk operability of the disk.. [optional]  # noqa: E501
            operating_temperature (int): Operating temperature of drive in Celsius.. [optional]  # noqa: E501
            percent_life_left (int): Percentage of write cycles remaining in a solid state drive (SSD).. [optional]  # noqa: E501
            percent_reserved_capacity_consumed (int): Percentage of reserve capacity consumed.. [optional]  # noqa: E501
            performance_percent (int): Performance at which the device operating expressed in percentage.. [optional]  # noqa: E501
            physical_block_size (str): The block size of the installed physical disk.. [optional]  # noqa: E501
            pid (str): This field identifies the Product ID for physicalDisk.. [optional]  # noqa: E501
            power_cycle_count (int): Number of powercycles the drive has undergone.. [optional]  # noqa: E501
            power_on_hours (int): Number of hours the drive has been powered on.. [optional]  # noqa: E501
            predicted_media_life_left_percent (int): Predicted physical disk life left in percentage.. [optional]  # noqa: E501
            predictive_failure_count (int): Error count on the physical disk.. [optional]  # noqa: E501
            protocol (str): This field identifies the disk protocol used for communication.. [optional]  # noqa: E501
            raw_size (str): The raw size of the physical disk in MB.. [optional]  # noqa: E501
            read_error_count_threshold (int): The number of read errors that are permitted while accessing the drive/card.. [optional]  # noqa: E501
            read_io_error_count (int): Number of IO Errors that occured while reading data from the disk.. [optional]  # noqa: E501
            secured (str): This field identifies whether the disk is encrypted.. [optional]  # noqa: E501
            size (str): The size of the physical disk in MB.. [optional]  # noqa: E501
            thermal (str): Thermal state of the physical disk.. [optional]  # noqa: E501
            threshold_operating_temperature (int): Rated threshold operating temperature in Celsius.. [optional]  # noqa: E501
            type (str): This field identifies the type of the physical disk.. [optional]  # noqa: E501
            variant_type (str): The variant type of the physical disk.. [optional]  # noqa: E501
            wear_status_in_days (int): The number of days an SSD has gone through with the write cycles.. [optional]  # noqa: E501
            write_error_count_threshold (int): The number of write errors that are permitted while accessing the drive/card.. [optional]  # noqa: E501
            write_io_error_count (int): Number of IO Errors that occured while writing data to the disk.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            physical_disk_extensions ([StoragePhysicalDiskExtensionRelationship], none_type): An array of relationships to storagePhysicalDiskExtension resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            running_firmware ([FirmwareRunningFirmwareRelationship], none_type): An array of relationships to firmwareRunningFirmware resources.. [optional]  # noqa: E501
            sas_ports ([StorageSasPortRelationship], none_type): An array of relationships to storageSasPort resources.. [optional]  # noqa: E501
            storage_controller (StorageControllerRelationship): [optional]  # noqa: E501
            storage_enclosure (StorageEnclosureRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "storage.PhysicalDisk")
        object_type = kwargs.get('object_type', "storage.PhysicalDisk")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
