"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5208
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.kubernetes_aci_cni_tenant_cluster_allocation_relationship import KubernetesAciCniTenantClusterAllocationRelationship
    from intersight.model.kubernetes_cluster_profile_relationship import KubernetesClusterProfileRelationship
    from intersight.model.organization_organization_relationship import OrganizationOrganizationRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['KubernetesAciCniTenantClusterAllocationRelationship'] = KubernetesAciCniTenantClusterAllocationRelationship
    globals()['KubernetesClusterProfileRelationship'] = KubernetesClusterProfileRelationship
    globals()['OrganizationOrganizationRelationship'] = OrganizationOrganizationRelationship


class KubernetesAciCniProfileAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
        },
        ('object_type',): {
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
        },
    }

    validations = {
        ('aaep_name',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9][a-zA-Z0-9-_]*[a-zA-Z0-9]$',  # noqa: E501
            },
        },
        ('ext_svc_dyn_subnet_start',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\/([0-9]|[1-2][0-9]|3[0-2])$',  # noqa: E501
            },
        },
        ('ext_svc_static_subnet_start',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\/([0-9]|[1-2][0-9]|3[0-2])$',  # noqa: E501
            },
        },
        ('l3_out_network_name',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9][a-zA-Z0-9-_]*[a-zA-Z0-9]$',  # noqa: E501
            },
        },
        ('l3_out_policy_name',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9][a-zA-Z0-9-_]*[a-zA-Z0-9]$',  # noqa: E501
            },
        },
        ('l3_out_tenant',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9][a-zA-Z0-9-_]*[a-zA-Z0-9]$',  # noqa: E501
            },
        },
        ('nested_vmm_domain',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9][a-zA-Z0-9-_]*[a-zA-Z0-9]$',  # noqa: E501
            },
        },
        ('node_svc_subnet_start',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\/([0-9]|[1-2][0-9]|3[0-2])$',  # noqa: E501
            },
        },
        ('opflex_multicast_address_range',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\/([0-9]|[1-2][0-9]|3[0-2])$',  # noqa: E501
            },
        },
        ('pod_subnet_start',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\/([0-9]|[1-2][0-9]|3[0-2])$',  # noqa: E501
            },
        },
        ('svc_subnet_start',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]).([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\/([0-9]|[1-2][0-9]|3[0-2])$',  # noqa: E501
            },
        },
        ('vrf',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9][a-zA-Z0-9-_]*[a-zA-Z0-9]$',  # noqa: E501
            },
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'aaep_name': (str,),  # noqa: E501
            'ext_svc_dyn_subnet_start': (str,),  # noqa: E501
            'ext_svc_static_subnet_start': (str,),  # noqa: E501
            'infra_vlan_id': (int,),  # noqa: E501
            'l3_out_network_name': (str,),  # noqa: E501
            'l3_out_policy_name': (str,),  # noqa: E501
            'l3_out_tenant': (str,),  # noqa: E501
            'nested_vmm_domain': (str,),  # noqa: E501
            'node_svc_subnet_start': (str,),  # noqa: E501
            'node_vlan_range_end': (int,),  # noqa: E501
            'node_vlan_range_start': (int,),  # noqa: E501
            'number_of_kubernetes_clusters': (int,),  # noqa: E501
            'opflex_multicast_address_range': (str,),  # noqa: E501
            'pod_subnet_start': (str,),  # noqa: E501
            'svc_subnet_start': (str,),  # noqa: E501
            'vrf': (str,),  # noqa: E501
            'cluster_aci_allocations': ([KubernetesAciCniTenantClusterAllocationRelationship], none_type,),  # noqa: E501
            'cluster_profiles': ([KubernetesClusterProfileRelationship], none_type,),  # noqa: E501
            'organization': (OrganizationOrganizationRelationship,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'aaep_name': 'AaepName',  # noqa: E501
        'ext_svc_dyn_subnet_start': 'ExtSvcDynSubnetStart',  # noqa: E501
        'ext_svc_static_subnet_start': 'ExtSvcStaticSubnetStart',  # noqa: E501
        'infra_vlan_id': 'InfraVlanId',  # noqa: E501
        'l3_out_network_name': 'L3OutNetworkName',  # noqa: E501
        'l3_out_policy_name': 'L3OutPolicyName',  # noqa: E501
        'l3_out_tenant': 'L3OutTenant',  # noqa: E501
        'nested_vmm_domain': 'NestedVmmDomain',  # noqa: E501
        'node_svc_subnet_start': 'NodeSvcSubnetStart',  # noqa: E501
        'node_vlan_range_end': 'NodeVlanRangeEnd',  # noqa: E501
        'node_vlan_range_start': 'NodeVlanRangeStart',  # noqa: E501
        'number_of_kubernetes_clusters': 'NumberOfKubernetesClusters',  # noqa: E501
        'opflex_multicast_address_range': 'OpflexMulticastAddressRange',  # noqa: E501
        'pod_subnet_start': 'PodSubnetStart',  # noqa: E501
        'svc_subnet_start': 'SvcSubnetStart',  # noqa: E501
        'vrf': 'Vrf',  # noqa: E501
        'cluster_aci_allocations': 'ClusterAciAllocations',  # noqa: E501
        'cluster_profiles': 'ClusterProfiles',  # noqa: E501
        'organization': 'Organization',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """KubernetesAciCniProfileAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "kubernetes.AciCniProfile", must be one of ["kubernetes.AciCniProfile", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "kubernetes.AciCniProfile", must be one of ["kubernetes.AciCniProfile", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            aaep_name (str): Name of ACI AAEP (Attachable Access Entity Profile) to be used for all Kubernetes clusters using this policy.. [optional]  # noqa: E501
            ext_svc_dyn_subnet_start (str): Start of range of IP subnets for external services with dynamic IP allocation for use by Kubernetes clusters using this ACI CNI policy.. [optional]  # noqa: E501
            ext_svc_static_subnet_start (str): Start of range of IP subnets for external services with static IP allocation for use by Kubernetes clusters using this ACI CNI policy.. [optional]  # noqa: E501
            infra_vlan_id (int): Value of ACI infrastructuere VLAN ID for the ACI fabric.. [optional]  # noqa: E501
            l3_out_network_name (str): Name of ACI L3Out network to be used for all Kubernetes clusters using this policy.. [optional]  # noqa: E501
            l3_out_policy_name (str): Name of ACI L3Out policy to be used for all Kubernetes clusters using this policy.. [optional]  # noqa: E501
            l3_out_tenant (str): Tenant in ACI used by this L3Out and Common VRF.. [optional]  # noqa: E501
            nested_vmm_domain (str): VMM domain within which Kubernetes clusters using this policy are nested.. [optional]  # noqa: E501
            node_svc_subnet_start (str): Start of range of ACI Node Service IP subnets to use by Kubernetes clusters using this ACI CNI policy This is used for the service graph which is used for ACI PBR based load balancing.. [optional]  # noqa: E501
            node_vlan_range_end (int): Ending value of VLAN range used to assign Node VLAN Ids for each Kubernetes cluster using this policy.. [optional]  # noqa: E501
            node_vlan_range_start (int): Starting value of VLAN range used to assign Node VLAN Ids for each Kubernetes cluster using this policy.. [optional]  # noqa: E501
            number_of_kubernetes_clusters (int): Number of k8s clusters currently using this ACI CNI profile.. [optional]  # noqa: E501
            opflex_multicast_address_range (str): Range of IP Multicast addresses to be used by the Opflex protocol for Kubernetes clusters using this policy.. [optional]  # noqa: E501
            pod_subnet_start (str): Start of range of Kubernetes pod IP subnets to use by Kubernetes clusters using this ACI CNI policy This should be a /8 IP subnet so that multiple /16 subnets can be assigned for pod subnets of Kubernetes clusters using this profile.. [optional]  # noqa: E501
            svc_subnet_start (str): Start of range of Kubernetes Service IP subnets to use by Kubernetes clusters using this ACI CNI policy Currently this is fixed internally and read-only.. [optional]  # noqa: E501
            vrf (str): VRF (Virtual Routing and Forwarding) domain to be used within ACI fabric by all k8s clusters using this policy.. [optional]  # noqa: E501
            cluster_aci_allocations ([KubernetesAciCniTenantClusterAllocationRelationship], none_type): An array of relationships to kubernetesAciCniTenantClusterAllocation resources.. [optional]  # noqa: E501
            cluster_profiles ([KubernetesClusterProfileRelationship], none_type): An array of relationships to kubernetesClusterProfile resources.. [optional]  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "kubernetes.AciCniProfile")
        object_type = kwargs.get('object_type', "kubernetes.AciCniProfile")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
