"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5208
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.hyperflex_backup_cluster_relationship import HyperflexBackupClusterRelationship
    from intersight.model.hyperflex_cluster_relationship import HyperflexClusterRelationship
    from intersight.model.hyperflex_entity_reference import HyperflexEntityReference
    from intersight.model.hyperflex_error_stack import HyperflexErrorStack
    from intersight.model.hyperflex_map_cluster_id_to_protection_info import HyperflexMapClusterIdToProtectionInfo
    from intersight.model.hyperflex_replication_cluster_reference_to_schedule import HyperflexReplicationClusterReferenceToSchedule
    from intersight.model.hyperflex_virtual_machine import HyperflexVirtualMachine
    globals()['HyperflexBackupClusterRelationship'] = HyperflexBackupClusterRelationship
    globals()['HyperflexClusterRelationship'] = HyperflexClusterRelationship
    globals()['HyperflexEntityReference'] = HyperflexEntityReference
    globals()['HyperflexErrorStack'] = HyperflexErrorStack
    globals()['HyperflexMapClusterIdToProtectionInfo'] = HyperflexMapClusterIdToProtectionInfo
    globals()['HyperflexReplicationClusterReferenceToSchedule'] = HyperflexReplicationClusterReferenceToSchedule
    globals()['HyperflexVirtualMachine'] = HyperflexVirtualMachine


class HyperflexVmBackupInfoAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
        },
        ('object_type',): {
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
        },
        ('backup_status',): {
            'INITIALIZINGPROTECTION': "InitializingProtection",
            'PROTECTED': "Protected",
            'EXCEEDSINTERVAL': "ExceedsInterval",
        },
        ('protection_status',): {
            'PREPARE_FAILOVER_STARTED': "PREPARE_FAILOVER_STARTED",
            'PREPARE_FAILOVER_FAILED': "PREPARE_FAILOVER_FAILED",
            'PREPARE_FAILOVER_COMPLETED': "PREPARE_FAILOVER_COMPLETED",
            'FAILOVER_STARTED': "FAILOVER_STARTED",
            'FAILOVER_FAILED': "FAILOVER_FAILED",
            'FAILOVER_COMPLETED': "FAILOVER_COMPLETED",
            'PREPARE_REVERSEPROTECT_STARTED': "PREPARE_REVERSEPROTECT_STARTED",
            'PREPARE_REVERSEPROTECT_FAILED': "PREPARE_REVERSEPROTECT_FAILED",
            'PREPARE_REVERSEPROTECT_COMPLETED': "PREPARE_REVERSEPROTECT_COMPLETED",
            'REVERSEPROTECT_STARTED': "REVERSEPROTECT_STARTED",
            'REVERSEPROTECT_FAILED': "REVERSEPROTECT_FAILED",
            'ACTIVE': "ACTIVE",
            'CREATION_IN_PROGRESS': "CREATION_IN_PROGRESS",
            'CREATION_FAILED': "CREATION_FAILED",
            'LOCAL_RESTORE_STARTED': "LOCAL_RESTORE_STARTED",
            'LOCAL_RESTORE_FAILED': "LOCAL_RESTORE_FAILED",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'backup_status': (str,),  # noqa: E501
            'cluster_entity_reference': (HyperflexEntityReference,),  # noqa: E501
            'cluster_id_protection_info_map': ([HyperflexMapClusterIdToProtectionInfo], none_type,),  # noqa: E501
            'error': (HyperflexErrorStack,),  # noqa: E501
            'local_snapshot_retention_count': (int,),  # noqa: E501
            'power_on': (bool,),  # noqa: E501
            'protection_status': (str,),  # noqa: E501
            'schedule': ([HyperflexReplicationClusterReferenceToSchedule], none_type,),  # noqa: E501
            'snapshot_retention_count': (int,),  # noqa: E501
            'src_cluster_name': (str,),  # noqa: E501
            'tgt_cluster_name': (str,),  # noqa: E501
            'vm_entity_reference': (HyperflexEntityReference,),  # noqa: E501
            'vm_info': (HyperflexVirtualMachine,),  # noqa: E501
            'src_backup_cluster': (HyperflexBackupClusterRelationship,),  # noqa: E501
            'src_cluster': (HyperflexClusterRelationship,),  # noqa: E501
            'tgt_cluster': (HyperflexClusterRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'backup_status': 'BackupStatus',  # noqa: E501
        'cluster_entity_reference': 'ClusterEntityReference',  # noqa: E501
        'cluster_id_protection_info_map': 'ClusterIdProtectionInfoMap',  # noqa: E501
        'error': 'Error',  # noqa: E501
        'local_snapshot_retention_count': 'LocalSnapshotRetentionCount',  # noqa: E501
        'power_on': 'PowerOn',  # noqa: E501
        'protection_status': 'ProtectionStatus',  # noqa: E501
        'schedule': 'Schedule',  # noqa: E501
        'snapshot_retention_count': 'SnapshotRetentionCount',  # noqa: E501
        'src_cluster_name': 'SrcClusterName',  # noqa: E501
        'tgt_cluster_name': 'TgtClusterName',  # noqa: E501
        'vm_entity_reference': 'VmEntityReference',  # noqa: E501
        'vm_info': 'VmInfo',  # noqa: E501
        'src_backup_cluster': 'SrcBackupCluster',  # noqa: E501
        'src_cluster': 'SrcCluster',  # noqa: E501
        'tgt_cluster': 'TgtCluster',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperflexVmBackupInfoAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.VmBackupInfo", must be one of ["hyperflex.VmBackupInfo", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.VmBackupInfo", must be one of ["hyperflex.VmBackupInfo", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            backup_status (str): Description of the backup status of this VmBackupInfo. * `InitializingProtection` - Protection has started, but not completed. * `Protected` - Protection has completed successfully. * `ExceedsInterval` - Protection has not completed successfully in over two times the backup interval.. [optional] if omitted the server will use the default value of "InitializingProtection"  # noqa: E501
            cluster_entity_reference (HyperflexEntityReference): [optional]  # noqa: E501
            cluster_id_protection_info_map ([HyperflexMapClusterIdToProtectionInfo], none_type): [optional]  # noqa: E501
            error (HyperflexErrorStack): [optional]  # noqa: E501
            local_snapshot_retention_count (int): Retention count from backup policy for local snapshots.. [optional]  # noqa: E501
            power_on (bool): The power state of the Virtual Machine.. [optional]  # noqa: E501
            protection_status (str): Description of the protection status of this VmBackupInfo. * `PREPARE_FAILOVER_STARTED` - The protection status is prepare failover started. * `PREPARE_FAILOVER_FAILED` - The protection status is prepare failover failed. * `PREPARE_FAILOVER_COMPLETED` - The protection status is prepaire failover completed. * `FAILOVER_STARTED` - The protection status is failover started. * `FAILOVER_FAILED` - The protection status is failover failed. * `FAILOVER_COMPLETED` - The protection status is failover completed. * `PREPARE_REVERSEPROTECT_STARTED` - The protection status is prepare reverse protect started. * `PREPARE_REVERSEPROTECT_FAILED` - The protection status is prepare reverse protect failed. * `PREPARE_REVERSEPROTECT_COMPLETED` - The protection status is prepair reverse protect completed. * `REVERSEPROTECT_STARTED` - The protection status is reverse protect started. * `REVERSEPROTECT_FAILED` - The protection status is reverse protect failed. * `ACTIVE` - The protection status is active. * `CREATION_IN_PROGRESS` - The protection status is failover in progress. * `CREATION_FAILED` - The protection status is creation failed. * `LOCAL_RESTORE_STARTED` - The protection status is local restore started. * `LOCAL_RESTORE_FAILED` - The protection status is local restore failed.. [optional] if omitted the server will use the default value of "PREPARE_FAILOVER_STARTED"  # noqa: E501
            schedule ([HyperflexReplicationClusterReferenceToSchedule], none_type): [optional]  # noqa: E501
            snapshot_retention_count (int): Retention count from backup policy for remote snapshots.. [optional]  # noqa: E501
            src_cluster_name (str): Name for the source cluster this Virtual Machine is residing on.. [optional]  # noqa: E501
            tgt_cluster_name (str): Name for the target cluster this Virtual Machine is residing on.. [optional]  # noqa: E501
            vm_entity_reference (HyperflexEntityReference): [optional]  # noqa: E501
            vm_info (HyperflexVirtualMachine): [optional]  # noqa: E501
            src_backup_cluster (HyperflexBackupClusterRelationship): [optional]  # noqa: E501
            src_cluster (HyperflexClusterRelationship): [optional]  # noqa: E501
            tgt_cluster (HyperflexClusterRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.VmBackupInfo")
        object_type = kwargs.get('object_type', "hyperflex.VmBackupInfo")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
