/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.LevenshteinResults;

public class LevenshteinDetailedDistance
implements EditDistance<LevenshteinResults> {
    private static final LevenshteinDetailedDistance DEFAULT_INSTANCE = new LevenshteinDetailedDistance();
    private final Integer threshold;

    public LevenshteinDetailedDistance() {
        this(null);
    }

    public LevenshteinDetailedDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public LevenshteinResults apply(CharSequence left, CharSequence right) {
        if (this.threshold != null) {
            return LevenshteinDetailedDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDetailedDistance.unlimitedCompare(left, right);
    }

    public static LevenshteinDetailedDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    private static LevenshteinResults limitedCompare(CharSequence left, CharSequence right, int threshold) {
        int index;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = left.length();
        int m2 = right.length();
        if (n2 == 0) {
            return m2 <= threshold ? new LevenshteinResults(m2, m2, 0, 0) : new LevenshteinResults(-1, 0, 0, 0);
        }
        if (m2 == 0) {
            return n2 <= threshold ? new LevenshteinResults(n2, 0, n2, 0) : new LevenshteinResults(-1, 0, 0, 0);
        }
        boolean swapped = false;
        if (n2 > m2) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n2 = m2;
            m2 = right.length();
            swapped = true;
        }
        int[] p2 = new int[n2 + 1];
        int[] d2 = new int[n2 + 1];
        int[][] matrix = new int[m2 + 1][n2 + 1];
        for (index = 0; index <= n2; ++index) {
            matrix[0][index] = index;
        }
        for (index = 0; index <= m2; ++index) {
            matrix[index][0] = index;
        }
        int boundary = Math.min(n2, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p2[i2] = i2;
        }
        Arrays.fill(p2, boundary, p2.length, Integer.MAX_VALUE);
        Arrays.fill(d2, Integer.MAX_VALUE);
        for (int j2 = 1; j2 <= m2; ++j2) {
            int max;
            char rightJ = right.charAt(j2 - 1);
            d2[0] = j2;
            int min = Math.max(1, j2 - threshold);
            int n3 = max = j2 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, j2 + threshold);
            if (min > max) {
                return new LevenshteinResults(-1, 0, 0, 0);
            }
            if (min > 1) {
                d2[min - 1] = Integer.MAX_VALUE;
            }
            for (int i3 = min; i3 <= max; ++i3) {
                d2[i3] = left.charAt(i3 - 1) == rightJ ? p2[i3 - 1] : 1 + Math.min(Math.min(d2[i3 - 1], p2[i3]), p2[i3 - 1]);
                matrix[j2][i3] = d2[i3];
            }
            int[] tempD = p2;
            p2 = d2;
            d2 = tempD;
        }
        if (p2[n2] <= threshold) {
            return LevenshteinDetailedDistance.findDetailedResults(left, right, matrix, swapped);
        }
        return new LevenshteinResults(-1, 0, 0, 0);
    }

    private static LevenshteinResults unlimitedCompare(CharSequence left, CharSequence right) {
        int i2;
        int index;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = left.length();
        int m2 = right.length();
        if (n2 == 0) {
            return new LevenshteinResults(m2, m2, 0, 0);
        }
        if (m2 == 0) {
            return new LevenshteinResults(n2, 0, n2, 0);
        }
        boolean swapped = false;
        if (n2 > m2) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n2 = m2;
            m2 = right.length();
            swapped = true;
        }
        int[] p2 = new int[n2 + 1];
        int[] d2 = new int[n2 + 1];
        int[][] matrix = new int[m2 + 1][n2 + 1];
        for (index = 0; index <= n2; ++index) {
            matrix[0][index] = index;
        }
        for (index = 0; index <= m2; ++index) {
            matrix[index][0] = index;
        }
        for (i2 = 0; i2 <= n2; ++i2) {
            p2[i2] = i2;
        }
        for (int j2 = 1; j2 <= m2; ++j2) {
            char rightJ = right.charAt(j2 - 1);
            d2[0] = j2;
            for (i2 = 1; i2 <= n2; ++i2) {
                int cost = left.charAt(i2 - 1) == rightJ ? 0 : 1;
                d2[i2] = Math.min(Math.min(d2[i2 - 1] + 1, p2[i2] + 1), p2[i2 - 1] + cost);
                matrix[j2][i2] = d2[i2];
            }
            int[] tempD = p2;
            p2 = d2;
            d2 = tempD;
        }
        return LevenshteinDetailedDistance.findDetailedResults(left, right, matrix, swapped);
    }

    private static LevenshteinResults findDetailedResults(CharSequence left, CharSequence right, int[][] matrix, boolean swapped) {
        int delCount = 0;
        int addCount = 0;
        int subCount = 0;
        int rowIndex = right.length();
        int columnIndex = left.length();
        int dataAtLeft = 0;
        int dataAtTop = 0;
        int dataAtDiagonal = 0;
        int data = 0;
        boolean deleted = false;
        boolean added = false;
        while (rowIndex >= 0 && columnIndex >= 0) {
            dataAtLeft = columnIndex == 0 ? -1 : matrix[rowIndex][columnIndex - 1];
            dataAtTop = rowIndex == 0 ? -1 : matrix[rowIndex - 1][columnIndex];
            dataAtDiagonal = rowIndex > 0 && columnIndex > 0 ? matrix[rowIndex - 1][columnIndex - 1] : -1;
            if (dataAtLeft == -1 && dataAtTop == -1 && dataAtDiagonal == -1) break;
            data = matrix[rowIndex][columnIndex];
            if (columnIndex > 0 && rowIndex > 0 && left.charAt(columnIndex - 1) == right.charAt(rowIndex - 1)) {
                --columnIndex;
                --rowIndex;
                continue;
            }
            deleted = false;
            added = false;
            if (data - 1 == dataAtLeft && data <= dataAtDiagonal && data <= dataAtTop || dataAtDiagonal == -1 && dataAtTop == -1) {
                --columnIndex;
                if (swapped) {
                    ++addCount;
                    added = true;
                } else {
                    ++delCount;
                    deleted = true;
                }
            } else if (data - 1 == dataAtTop && data <= dataAtDiagonal && data <= dataAtLeft || dataAtDiagonal == -1 && dataAtLeft == -1) {
                --rowIndex;
                if (swapped) {
                    ++delCount;
                    deleted = true;
                } else {
                    ++addCount;
                    added = true;
                }
            }
            if (added || deleted) continue;
            ++subCount;
            --columnIndex;
            --rowIndex;
        }
        return new LevenshteinResults(addCount + delCount + subCount, addCount, delCount, subCount);
    }
}

