/*
 * Decompiled with CFR 0.152.
 */
package psfgenerator;

import bilib.commons.table.CustomizedColumn;
import bilib.commons.table.CustomizedTable;
import bilib.commons.utils.NumFormat;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import psf.Data3D;
import psf.PSF;

public class ResultPlanesTable
extends JPanel {
    public ResultPlanesTable(PSF psf) {
        Data3D data = psf.getData();
        double[][] plane = data.getPlaneInformation();
        ArrayList<CustomizedColumn> columns = new ArrayList<CustomizedColumn>();
        columns.add(new CustomizedColumn("Z-Plane", String.class, 40, false));
        columns.add(new CustomizedColumn("Max Value", String.class, 40, false));
        columns.add(new CustomizedColumn("Energy Value", String.class, 40, false));
        columns.add(new CustomizedColumn("Efficiency Radius", String.class, 40, false));
        CustomizedTable table = new CustomizedTable(columns, true);
        int i = 0;
        while (i < plane.length) {
            String z = String.format("%05d", (int)plane[i][0]);
            String m = NumFormat.sci(plane[i][1]);
            String e = NumFormat.sci(plane[i][2] * 100.0);
            String r = NumFormat.sci(plane[i][3] * psf.resLateral);
            table.append(new String[]{z, m, e, r});
            ++i;
        }
        this.setLayout(new BorderLayout());
        this.add(table.getPane(200, 200));
    }
}

