/*
 * Decompiled with CFR 0.152.
 */
package psf.richardswolf;

import bilib.commons.components.GridToolbar;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import psf.PSF;
import psf.richardswolf.KirchhoffDiffractionSimpson;

public class RichardsWolfPSF
extends PSF {
    private double ni_Default = 1.5;
    private SpinnerRangeDouble spnNI = new SpinnerRangeDouble(this.ni_Default, 0.0, 3.0, 0.1, 5);
    private JComboBox cmbAccuracy = new JComboBox<String>(new String[]{"Good", "Better", "Best"});
    private double ni = 1.5;
    private int accuracy = 0;

    public RichardsWolfPSF() {
        this.fullname = "Richards & Wolf 3D Optical Model";
        this.shortname = "RW";
    }

    @Override
    public String getDescription() {
        String desc = "<h1>" + this.fullname + "</h1>";
        desc = String.valueOf(desc) + "<p>This model describes the vectorial-based. ";
        desc = String.valueOf(desc) + "The phase aberration is given by the the Gibson & Lanni model. ";
        desc = String.valueOf(desc) + "The 3 electric field components are evaluated independently.</p>";
        return desc;
    }

    @Override
    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        if (nx < 4) {
            return "nx should be greater than 4.";
        }
        if (ny < 4) {
            return "ny should be greater than 4.";
        }
        return "";
    }

    @Override
    public void resetParameters() {
        this.spnNI.set(this.ni_Default);
        this.cmbAccuracy.setSelectedIndex(0);
    }

    @Override
    public void fetchParameters() {
        this.ni = this.spnNI.get();
        this.accuracy = this.cmbAccuracy.getSelectedIndex();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false);
        pn.place(3, 0, "<html>Refractive index immersion</html>");
        pn.place(6, 0, "<html>Accuracy computation</html>");
        pn.place(3, 1, this.spnNI);
        pn.place(6, 1, this.cmbAccuracy);
        pn.place(3, 2, new JLabel("<html>ni</html>"));
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-NI", this.spnNI, "" + this.ni_Default);
        settings.record("psf-" + this.shortname + "-accuracy", this.cmbAccuracy, (String)this.cmbAccuracy.getItemAt(0));
        return panel;
    }

    @Override
    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            double defocus = this.resAxial * 1.0E-9 * ((double)z - ((double)this.nz - 1.0) / 2.0);
            RichardsWolf plane = new RichardsWolf(z, defocus);
            plane.addMonitor(this);
            pool.register(plane);
            ++z;
        }
    }

    public class RichardsWolf
    extends Job {
        private int OVER_SAMPLING = 2;
        private int z;
        private double defocus;

        public RichardsWolf(int z, double defocus) {
            this.defocus = defocus;
            this.z = z;
        }

        @Override
        public void process() {
            double x0 = (double)(RichardsWolfPSF.this.nx - 1) / 2.0;
            double y0 = (double)(RichardsWolfPSF.this.ny - 1) / 2.0;
            double xp = x0;
            double yp = y0;
            int maxRadius = (int)Math.round(Math.sqrt(((double)RichardsWolfPSF.this.nx - x0) * ((double)RichardsWolfPSF.this.nx - x0) + ((double)RichardsWolfPSF.this.ny - y0) * ((double)RichardsWolfPSF.this.ny - y0))) + 1;
            double[] r = new double[maxRadius * this.OVER_SAMPLING];
            double[] h = new double[r.length];
            KirchhoffDiffractionSimpson I = new KirchhoffDiffractionSimpson(this.defocus, RichardsWolfPSF.this.ni, RichardsWolfPSF.this.accuracy, RichardsWolfPSF.this.NA, RichardsWolfPSF.this.lambda);
            int n = 0;
            while (n < r.length) {
                r[n] = (double)n / (double)this.OVER_SAMPLING;
                h[n] = I.calculate(r[n] * RichardsWolfPSF.this.resLateral * 1.0E-9);
                if (!this.live) {
                    return;
                }
                ++n;
            }
            double[] slice = new double[RichardsWolfPSF.this.nx * RichardsWolfPSF.this.ny];
            int x = 0;
            while (x < RichardsWolfPSF.this.nx) {
                int y = 0;
                while (y < RichardsWolfPSF.this.ny) {
                    double value;
                    double rPixel = Math.sqrt(((double)x - xp) * ((double)x - xp) + ((double)y - yp) * ((double)y - yp));
                    int index = (int)Math.floor(rPixel * (double)this.OVER_SAMPLING);
                    slice[x + RichardsWolfPSF.this.nx * y] = value = h[index] + (h[index + 1] - h[index]) * (rPixel - r[index]) * (double)this.OVER_SAMPLING;
                    ++y;
                }
                if (!this.live) {
                    return;
                }
                ++x;
            }
            ((RichardsWolfPSF)RichardsWolfPSF.this).data.data[this.z] = slice;
            this.increment(90.0 / (double)RichardsWolfPSF.this.nz, this.z + " / " + RichardsWolfPSF.this.nz);
        }
    }
}

