/*
 * Decompiled with CFR 0.152.
 */
package psf.gibsonlanni;

import bilib.commons.components.GridToolbar;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import psf.PSF;
import psf.gibsonlanni.GibsonLanniParameters;
import psf.gibsonlanni.KirchhoffDiffractionSimpson;

public class GibsonLanniPSF
extends PSF {
    private double ni_Default = 1.5;
    private double ns_Default = 1.33;
    private double ti_Default = 150.0;
    private double zpos_Default = 2000.0;
    private SpinnerRangeDouble spnNI = new SpinnerRangeDouble(this.ni_Default, 0.0, 3.0, 0.1);
    private SpinnerRangeDouble spnNS = new SpinnerRangeDouble(this.ns_Default, 0.0, 3.0, 0.1);
    private SpinnerRangeDouble spnTI = new SpinnerRangeDouble(this.ti_Default, 0.0, 9999.0, 100.0);
    private SpinnerRangeDouble spnZPos = new SpinnerRangeDouble(this.zpos_Default, -9.9999999E7, 9.9999999E7, 10.0);
    private JComboBox cmbAccuracy = new JComboBox<String>(new String[]{"Good", "Better", "Best"});
    protected int accuracy = 0;
    protected GibsonLanniParameters p;

    public GibsonLanniPSF() {
        this.fullname = "Gibson & Lanni 3D Optical Model";
        this.shortname = "GL";
        this.p = new GibsonLanniParameters();
    }

    @Override
    public String getDescription() {
        String desc = "<h1>Gibson & Lanni Optical PSF Model</p>";
        desc = String.valueOf(desc) + "<p>This model describes the scalar-based diffraction that occurs in the microscope.";
        desc = String.valueOf(desc) + "It accounts for the immersion, the cover-slip and the sample layers.</p>";
        return desc;
    }

    @Override
    public void resetParameters() {
        this.spnNI.set(this.ni_Default);
        this.spnNS.set(this.ns_Default);
        this.spnTI.set(this.ti_Default);
        this.spnZPos.set(this.zpos_Default);
        this.cmbAccuracy.setSelectedIndex(0);
    }

    @Override
    public void fetchParameters() {
        this.p.ni = this.spnNI.get();
        this.p.ns = this.spnNS.get();
        this.p.ti0 = this.spnTI.get() * 1.0E-6;
        this.p.particleAxialPosition = this.spnZPos.get() * 1.0E-9;
        this.accuracy = this.cmbAccuracy.getSelectedIndex();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false, 1);
        pn.place(2, 0, "Refractive index immersion");
        pn.place(3, 0, "Refractive index sample");
        pn.place(4, 0, "Working distance (ti)");
        pn.place(11, 0, "Particle position Z");
        pn.place(13, 0, "Accuracy computation");
        pn.place(2, 1, this.spnNI);
        pn.place(3, 1, this.spnNS);
        pn.place(4, 1, this.spnTI);
        pn.place(11, 1, this.spnZPos);
        pn.place(13, 1, this.cmbAccuracy);
        pn.place(2, 2, "<html>n<sub>i</sub></html>");
        pn.place(3, 2, "<html>n<sub>s</sub></html>");
        pn.place(4, 2, "<html>[&mu;m]</html>");
        pn.place(11, 2, "<html>[nm]</html>");
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-NI", this.spnNI, "" + this.ni_Default);
        settings.record("psf-" + this.shortname + "-NS", this.spnNS, "" + this.ns_Default);
        settings.record("psf-" + this.shortname + "-TI", this.spnTI, "" + this.ti_Default);
        settings.record("psf-" + this.shortname + "-ZPos", this.spnZPos, "" + this.zpos_Default);
        settings.record("psf-" + this.shortname + "-accuracy", this.cmbAccuracy, (String)this.cmbAccuracy.getItemAt(0));
        return panel;
    }

    @Override
    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            GibsonLanniParameters param = new GibsonLanniParameters(this.p);
            param.ti = this.p.ti0 + this.resAxial * 1.0E-9 * ((double)z - ((double)this.nz - 1.0) / 2.0);
            GibsonLanni gb = new GibsonLanni(param, this.accuracy, z);
            gb.addMonitor(this);
            pool.register(gb);
            ++z;
        }
    }

    @Override
    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        if (nx < 4) {
            return "nx should be greater than 4.";
        }
        if (ny < 4) {
            return "ny should be greater than 4.";
        }
        return "";
    }

    public class GibsonLanni
    extends Job {
        private int OVER_SAMPLING = 2;
        private GibsonLanniParameters param;
        private int z;
        private int accuracy;

        public GibsonLanni(GibsonLanniParameters param, int accuracy, int z) {
            this.accuracy = accuracy;
            this.z = z;
            this.param = param;
        }

        @Override
        public void process() {
            double x0 = (double)(GibsonLanniPSF.this.nx - 1) / 2.0;
            double y0 = (double)(GibsonLanniPSF.this.ny - 1) / 2.0;
            double xp = x0;
            double yp = y0;
            int maxRadius = (int)Math.round(Math.sqrt(((double)GibsonLanniPSF.this.nx - x0) * ((double)GibsonLanniPSF.this.nx - x0) + ((double)GibsonLanniPSF.this.ny - y0) * ((double)GibsonLanniPSF.this.ny - y0))) + 1;
            double[] r = new double[maxRadius * this.OVER_SAMPLING];
            double[] h = new double[r.length];
            KirchhoffDiffractionSimpson I = new KirchhoffDiffractionSimpson(this.param, this.accuracy, GibsonLanniPSF.this.NA, GibsonLanniPSF.this.lambda);
            int n = 0;
            while (n < r.length) {
                r[n] = (double)n / (double)this.OVER_SAMPLING;
                h[n] = I.calculate(r[n] * GibsonLanniPSF.this.resLateral * 1.0E-9);
                if (!this.live) {
                    return;
                }
                ++n;
            }
            double[] slice = new double[GibsonLanniPSF.this.nx * GibsonLanniPSF.this.ny];
            int x = 0;
            while (x < GibsonLanniPSF.this.nx) {
                int y = 0;
                while (y < GibsonLanniPSF.this.ny) {
                    double value;
                    double rPixel = Math.sqrt(((double)x - xp) * ((double)x - xp) + ((double)y - yp) * ((double)y - yp));
                    int index = (int)Math.floor(rPixel * (double)this.OVER_SAMPLING);
                    slice[x + GibsonLanniPSF.this.nx * y] = value = h[index] + (h[index + 1] - h[index]) * (rPixel - r[index]) * (double)this.OVER_SAMPLING;
                    ++y;
                }
                if (!this.live) {
                    return;
                }
                ++x;
            }
            GibsonLanniPSF.this.setPlane(this.z, slice);
            this.increment(90.0 / (double)GibsonLanniPSF.this.nz, this.z + " / " + GibsonLanniPSF.this.nz);
        }
    }
}

