/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;

public class MaximumFinder
implements ExtendedPlugInFilter,
DialogListener {
    private static double tolerance = 10.0;
    public static final int SINGLE_POINTS = 0;
    public static final int IN_TOLERANCE = 1;
    public static final int SEGMENTED = 2;
    public static final int POINT_SELECTION = 3;
    public static final int LIST = 4;
    public static final int COUNT = 5;
    private static int outputType;
    private static int dialogOutputType;
    static final String[] outputTypeNames;
    private static boolean excludeOnEdges;
    private static boolean useMinThreshold;
    private static boolean lightBackground;
    private ImagePlus imp;
    private int flags = 415;
    private boolean thresholded;
    private boolean roiSaved;
    private boolean previewing;
    private Vector checkboxes;
    private boolean thresholdWarningShown = false;
    private Label messageArea;
    private double progressDone;
    private int nPasses = 0;
    private int width;
    private int height;
    private int intEncodeXMask;
    private int intEncodeYMask;
    private int intEncodeShift;
    private int[] dirOffset;
    private Polygon points;
    static final int[] DIR_X_OFFSET;
    static final int[] DIR_Y_OFFSET;
    static final byte MAXIMUM = 1;
    static final byte LISTED = 2;
    static final byte PROCESSED = 4;
    static final byte MAX_AREA = 8;
    static final byte EQUAL = 16;
    static final byte MAX_POINT = 32;
    static final byte ELIMINATED = 64;
    static final byte[] outputTypeMasks;
    static final float SQRT2 = 1.4142135f;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        ip.resetBinaryThreshold();
        this.thresholded = ip.getMinThreshold() != -808080.0;
        GenericDialog gd = new GenericDialog(command);
        int digits = ip instanceof FloatProcessor ? 2 : 0;
        String unit = imp.getCalibration() != null ? imp.getCalibration().getValueUnit() : null;
        unit = unit == null || unit.equals("Gray Value") ? ":" : " (" + unit + "):";
        gd.addNumericField("Noise tolerance" + unit, tolerance, digits);
        gd.addChoice("Output type:", outputTypeNames, outputTypeNames[dialogOutputType]);
        gd.addCheckbox("Exclude edge maxima", excludeOnEdges);
        if (this.thresholded) {
            gd.addCheckbox("Above lower threshold", useMinThreshold);
        }
        gd.addCheckbox("Light background", lightBackground);
        gd.addPreviewCheckbox(pfr, "Preview point selection");
        gd.addMessage("    ");
        this.messageArea = (Label)gd.getMessage();
        gd.addDialogListener(this);
        this.checkboxes = gd.getCheckboxes();
        this.previewing = true;
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#find-maxima");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        this.previewing = false;
        if (!this.dialogItemChanged(gd, null)) {
            return 4096;
        }
        IJ.register(this.getClass());
        return this.flags;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        tolerance = gd.getNextNumber();
        if (tolerance < 0.0) {
            tolerance = 0.0;
        }
        dialogOutputType = gd.getNextChoiceIndex();
        outputType = this.previewing ? 3 : dialogOutputType;
        excludeOnEdges = gd.getNextBoolean();
        useMinThreshold = this.thresholded ? gd.getNextBoolean() : false;
        lightBackground = gd.getNextBoolean();
        boolean invertedLut = this.imp.isInvertedLut();
        if (useMinThreshold && (invertedLut && !lightBackground || !invertedLut && lightBackground)) {
            if (!(this.thresholdWarningShown || IJ.showMessageWithCancel("Find Maxima", "\"Above Lower Threshold\" option cannot be used\nwhen finding minima (image with light background\nor image with dark background and inverting LUT).") || this.previewing)) {
                return false;
            }
            this.thresholdWarningShown = true;
            useMinThreshold = false;
            ((Checkbox)this.checkboxes.elementAt(1)).setState(false);
        }
        if (!gd.isPreviewActive()) {
            this.messageArea.setText("");
        }
        return !gd.invalidNumber();
    }

    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
    }

    public void run(ImageProcessor ip) {
        double threshold;
        Roi roi = this.imp.getRoi();
        if (outputType == 3 && !this.roiSaved) {
            this.imp.saveRoi();
            this.roiSaved = true;
        }
        if (!(roi == null || roi.isArea() && outputType != 2)) {
            this.imp.deleteRoi();
            roi = null;
        }
        boolean invertedLut = this.imp.isInvertedLut();
        double d = threshold = useMinThreshold ? ip.getMinThreshold() : -808080.0;
        if (invertedLut && !lightBackground || !invertedLut && lightBackground) {
            threshold = -808080.0;
            float[] cTable = ip.getCalibrationTable();
            ip = ip.duplicate();
            if (cTable == null) {
                ip.invert();
            } else {
                float[] invertedCTable = new float[cTable.length];
                for (int i = cTable.length - 1; i >= 0; --i) {
                    invertedCTable[i] = -cTable[i];
                }
                ip.setCalibrationTable(invertedCTable);
            }
            ip.setRoi(roi);
        }
        ByteProcessor outIp = null;
        outIp = this.findMaxima(ip, tolerance, threshold, outputType, excludeOnEdges, false);
        if (outIp == null) {
            return;
        }
        if (!Prefs.blackBackground) {
            outIp.invertLut();
        }
        String resultName = outputType == 2 ? " Segmented" : " Maxima";
        String outname = this.imp.getTitle();
        if (this.imp.getNSlices() > 1) {
            outname = outname + "(" + this.imp.getCurrentSlice() + ")";
        }
        if (WindowManager.getImage(outname = outname + resultName) != null) {
            outname = WindowManager.getUniqueName(outname);
        }
        ImagePlus maxImp = new ImagePlus(outname, outIp);
        Calibration cal = this.imp.getCalibration().copy();
        cal.disableDensityCalibration();
        maxImp.setCalibration(cal);
        maxImp.show();
    }

    public Polygon getMaxima(ImageProcessor ip, double tolerance, boolean excludeOnEdges) {
        this.findMaxima(ip, tolerance, -808080.0, 3, excludeOnEdges, false);
        if (this.points == null) {
            return new Polygon();
        }
        return this.points;
    }

    public static int[] findMaxima(double[] xx, double tolerance, boolean excludeOnEdges) {
        boolean includeEdge = !excludeOnEdges;
        int len = xx.length;
        if (len == 0) {
            return new int[0];
        }
        if (tolerance < 0.0) {
            tolerance = 0.0;
        }
        int[] maxPositions = new int[len];
        double max = xx[0];
        double min = xx[0];
        int maxPos = 0;
        int lastMaxPos = -1;
        boolean leftValleyFound = includeEdge;
        int maxCount = 0;
        for (int jj = 1; jj < len; ++jj) {
            double val = xx[jj];
            if (val > min + tolerance) {
                leftValleyFound = true;
            }
            if (val > max && leftValleyFound) {
                max = val;
                maxPos = jj;
            }
            if (leftValleyFound) {
                lastMaxPos = maxPos;
            }
            if (val < max - tolerance && leftValleyFound) {
                maxPositions[maxCount] = maxPos;
                ++maxCount;
                leftValleyFound = false;
                min = val;
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
            if (leftValleyFound) continue;
            max = val;
        }
        if (includeEdge) {
            if (maxCount > 0 && maxPositions[maxCount - 1] != lastMaxPos) {
                maxPositions[maxCount++] = lastMaxPos;
            }
            if (maxCount == 0 && max - min >= tolerance) {
                maxPositions[maxCount++] = lastMaxPos;
            }
        }
        int[] cropped = new int[maxCount];
        System.arraycopy(maxPositions, 0, cropped, 0, maxCount);
        maxPositions = cropped;
        double[] maxValues = new double[maxCount];
        for (int jj = 0; jj < maxCount; ++jj) {
            int pos;
            double midPos = pos;
            for (pos = maxPositions[jj]; pos < len - 1 && xx[pos] == xx[pos + 1]; ++pos) {
                midPos += 0.5;
            }
            maxPositions[jj] = (int)midPos;
            maxValues[jj] = xx[maxPositions[jj]];
        }
        int[] rankPositions = Tools.rank(maxValues);
        int[] returnArr = new int[maxCount];
        for (int jj = 0; jj < maxCount; ++jj) {
            int pos;
            returnArr[maxCount - jj - 1] = pos = maxPositions[rankPositions[jj]];
        }
        return returnArr;
    }

    public static int[] findMinima(double[] xx, double tolerance, boolean includeEdges) {
        int len = xx.length;
        double[] negArr = new double[len];
        for (int jj = 0; jj < len; ++jj) {
            negArr[jj] = -xx[jj];
        }
        int[] minPositions = MaximumFinder.findMaxima(negArr, tolerance, includeEdges);
        return minPositions;
    }

    public ByteProcessor findMaxima(ImageProcessor ip, double tolerance, double threshold, int outputType, boolean excludeOnEdges, boolean isEDM) {
        ByteProcessor outIp;
        boolean excludeEdgesNow;
        if (this.dirOffset == null) {
            this.makeDirectionOffsets(ip);
        }
        Rectangle roi = ip.getRoi();
        byte[] mask = ip.getMaskArray();
        if (threshold != -808080.0 && ip.getCalibrationTable() != null && threshold > 0.0 && threshold < (double)ip.getCalibrationTable().length) {
            threshold = ip.getCalibrationTable()[(int)threshold];
        }
        ByteProcessor typeP = new ByteProcessor(this.width, this.height);
        byte[] types = (byte[])typeP.getPixels();
        float globalMin = Float.MAX_VALUE;
        float globalMax = -3.4028235E38f;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            for (int x = roi.x; x < roi.x + roi.width; ++x) {
                float v = ip.getPixelValue(x, y);
                if (globalMin > v) {
                    globalMin = v;
                }
                if (!(globalMax < v)) continue;
                globalMax = v;
            }
        }
        if (threshold != -808080.0) {
            threshold -= (double)(globalMax - globalMin) * 1.0E-6;
        }
        boolean bl = excludeEdgesNow = excludeOnEdges && outputType != 2;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Getting sorted maxima...");
        long[] maxPoints = this.getSortedMaxPoints(ip, typeP, excludeEdgesNow, isEDM, globalMin, globalMax, threshold);
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Analyzing  maxima...");
        float maxSortingError = 0.0f;
        if (ip instanceof FloatProcessor) {
            maxSortingError = 1.1f * (isEDM ? 0.70710677f : (globalMax - globalMin) / 2.0E9f);
        }
        this.analyzeAndMarkMaxima(ip, typeP, maxPoints, excludeEdgesNow, isEDM, globalMin, tolerance, outputType, maxSortingError);
        if (outputType == 3 || outputType == 4 || outputType == 5) {
            return null;
        }
        if (outputType == 2) {
            outIp = this.make8bit(ip, typeP, isEDM, globalMin, globalMax, threshold);
            this.cleanupMaxima(outIp, typeP, maxPoints);
            if (!this.watershedSegment(outIp)) {
                return null;
            }
            if (!isEDM) {
                this.cleanupExtraLines(outIp);
            }
            this.watershedPostProcess(outIp);
            if (excludeOnEdges) {
                this.deleteEdgeParticles(outIp, typeP);
            }
        } else {
            for (int i = 0; i < this.width * this.height; ++i) {
                types[i] = (byte)((types[i] & outputTypeMasks[outputType]) != 0 ? 255 : 0);
            }
            outIp = typeP;
        }
        byte[] outPixels = (byte[])outIp.getPixels();
        if (roi != null) {
            int i = 0;
            for (int y = 0; y < outIp.getHeight(); ++y) {
                int x = 0;
                while (x < outIp.getWidth()) {
                    if (x < roi.x || x >= roi.x + roi.width || y < roi.y || y >= roi.y + roi.height) {
                        outPixels[i] = 0;
                    } else if (mask != null && mask[x - roi.x + roi.width * (y - roi.y)] == 0) {
                        outPixels[i] = 0;
                    }
                    ++x;
                    ++i;
                }
            }
        }
        return outIp;
    }

    long[] getSortedMaxPoints(ImageProcessor ip, ByteProcessor typeP, boolean excludeEdgesNow, boolean isEDM, float globalMin, float globalMax, double threshold) {
        Rectangle roi = ip.getRoi();
        byte[] types = (byte[])typeP.getPixels();
        int nMax = 0;
        boolean checkThreshold = threshold != -808080.0;
        Thread thread = Thread.currentThread();
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            if (y % 50 == 0 && thread.isInterrupted()) {
                return null;
            }
            int x = roi.x;
            int i = x + y * this.width;
            while (x < roi.x + roi.width) {
                float vTrue;
                float v = ip.getPixelValue(x, y);
                float f = vTrue = isEDM ? this.trueEdmHeight(x, y, ip) : v;
                if (!(v == globalMin || excludeEdgesNow && (x == 0 || x == this.width - 1 || y == 0 || y == this.height - 1) || checkThreshold && (double)v < threshold)) {
                    boolean isMax = true;
                    boolean isInner = y != 0 && y != this.height - 1 && x != 0 && x != this.width - 1;
                    for (int d = 0; d < 8; ++d) {
                        float vNeighborTrue;
                        if (!isInner && !this.isWithin(x, y, d)) continue;
                        float vNeighbor = ip.getPixelValue(x + DIR_X_OFFSET[d], y + DIR_Y_OFFSET[d]);
                        float f2 = vNeighborTrue = isEDM ? this.trueEdmHeight(x + DIR_X_OFFSET[d], y + DIR_Y_OFFSET[d], ip) : vNeighbor;
                        if (!(vNeighbor > v) || !(vNeighborTrue > vTrue)) continue;
                        isMax = false;
                        break;
                    }
                    if (isMax) {
                        types[i] = 1;
                        ++nMax;
                    }
                }
                ++x;
                ++i;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        float vFactor = (float)(2.0E9 / (double)(globalMax - globalMin));
        long[] maxPoints = new long[nMax];
        int iMax = 0;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            int x = roi.x;
            int p = x + y * this.width;
            while (x < roi.x + roi.width) {
                if (types[p] == 1) {
                    float fValue = isEDM ? this.trueEdmHeight(x, y, ip) : ip.getPixelValue(x, y);
                    int iValue = (int)((fValue - globalMin) * vFactor);
                    maxPoints[iMax++] = (long)iValue << 32 | (long)p;
                }
                ++x;
                ++p;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        Arrays.sort(maxPoints);
        return maxPoints;
    }

    void analyzeAndMarkMaxima(ImageProcessor ip, ByteProcessor typeP, long[] maxPoints, boolean excludeEdgesNow, boolean isEDM, float globalMin, double tolerance, int outputType, float maxSortingError) {
        boolean displayOrCount;
        byte[] types = (byte[])typeP.getPixels();
        float[] edmPixels = isEDM ? (float[])ip.getPixels() : null;
        int nMax = maxPoints.length;
        int[] pList = new int[this.width * this.height];
        Vector<int[]> xyVector = null;
        Roi roi = null;
        boolean bl = displayOrCount = outputType == 3 || outputType == 4 || outputType == 5;
        if (displayOrCount) {
            xyVector = new Vector<int[]>();
        }
        if (this.imp != null) {
            roi = this.imp.getRoi();
        }
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            boolean sortingError;
            if (iMax % 100 == 0 && Thread.currentThread().isInterrupted()) {
                return;
            }
            int offset0 = (int)maxPoints[iMax];
            if ((types[offset0] & 4) != 0) continue;
            int x0 = offset0 % this.width;
            int y0 = offset0 / this.width;
            float v0 = isEDM ? this.trueEdmHeight(x0, y0, ip) : ip.getPixelValue(x0, y0);
            do {
                pList[0] = offset0;
                int n = offset0;
                types[n] = (byte)(types[n] | 0x12);
                int listLen = 1;
                int listI = 0;
                boolean isEdgeMaximum = x0 == 0 || x0 == this.width - 1 || y0 == 0 || y0 == this.height - 1;
                sortingError = false;
                boolean maxPossible = true;
                double xEqual = x0;
                double yEqual = y0;
                int nEqual = 1;
                block2: do {
                    int offset = pList[listI];
                    int x = offset % this.width;
                    int y = offset / this.width;
                    boolean isInner = y != 0 && y != this.height - 1 && x != 0 && x != this.width - 1;
                    for (int d = 0; d < 8; ++d) {
                        float v2;
                        int offset2 = offset + this.dirOffset[d];
                        if (!isInner && !this.isWithin(x, y, d) || (types[offset2] & 2) != 0 || isEDM && edmPixels[offset2] <= 0.0f) continue;
                        if ((types[offset2] & 4) != 0) {
                            maxPossible = false;
                            continue block2;
                        }
                        int x2 = x + DIR_X_OFFSET[d];
                        int y2 = y + DIR_Y_OFFSET[d];
                        float f = v2 = isEDM ? this.trueEdmHeight(x2, y2, ip) : ip.getPixelValue(x2, y2);
                        if (v2 > v0 + maxSortingError) {
                            maxPossible = false;
                            continue block2;
                        }
                        if (!(v2 >= v0 - (float)tolerance)) continue;
                        if (v2 > v0) {
                            sortingError = true;
                            offset0 = offset2;
                            v0 = v2;
                            x0 = x2;
                            y0 = y2;
                        }
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                        if (x2 == 0 || x2 == this.width - 1 || y2 == 0 || y2 == this.height - 1) {
                            isEdgeMaximum = true;
                            if (excludeEdgesNow) {
                                maxPossible = false;
                                continue block2;
                            }
                        }
                        if (v2 != v0) continue;
                        int n3 = offset2;
                        types[n3] = (byte)(types[n3] | 0x10);
                        xEqual += (double)x2;
                        yEqual += (double)y2;
                        ++nEqual;
                    }
                } while (++listI < listLen);
                if (sortingError) {
                    for (listI = 0; listI < listLen; ++listI) {
                        types[pList[listI]] = 0;
                    }
                } else {
                    int y;
                    int x;
                    int offset;
                    int resetMask = ~(maxPossible ? 2 : 18);
                    xEqual /= (double)nEqual;
                    yEqual /= (double)nEqual;
                    double minDist2 = 1.0E20;
                    int nearestI = 0;
                    for (listI = 0; listI < listLen; ++listI) {
                        double dist2;
                        offset = pList[listI];
                        x = offset % this.width;
                        y = offset / this.width;
                        int n4 = offset;
                        types[n4] = (byte)(types[n4] & resetMask);
                        int n5 = offset;
                        types[n5] = (byte)(types[n5] | 4);
                        if (!maxPossible) continue;
                        int n6 = offset;
                        types[n6] = (byte)(types[n6] | 8);
                        if ((types[offset] & 0x10) == 0 || !((dist2 = (xEqual - (double)x) * (xEqual - (double)x) + (yEqual - (double)y) * (yEqual - (double)y)) < minDist2)) continue;
                        minDist2 = dist2;
                        nearestI = listI;
                    }
                    if (!maxPossible) continue;
                    int n7 = offset = pList[nearestI];
                    types[n7] = (byte)(types[n7] | 0x20);
                    if (!displayOrCount) continue;
                    if (excludeOnEdges && isEdgeMaximum) continue;
                    x = offset % this.width;
                    y = offset / this.width;
                    if (roi != null && !roi.contains(x, y)) continue;
                    xyVector.addElement(new int[]{x, y});
                }
            } while (sortingError);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (displayOrCount && xyVector != null) {
            int npoints = xyVector.size();
            if (outputType == 3 && npoints > 0) {
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                for (int i = 0; i < npoints; ++i) {
                    int[] xy = (int[])xyVector.elementAt(i);
                    xpoints[i] = xy[0];
                    ypoints[i] = xy[1];
                }
                if (this.imp != null) {
                    PointRoi points = new PointRoi(xpoints, ypoints, npoints);
                    points.setHideLabels(true);
                    this.imp.setRoi(points);
                }
                this.points = new Polygon(xpoints, ypoints, npoints);
            } else if (outputType == 4) {
                Analyzer.resetCounter();
                ResultsTable rt = ResultsTable.getResultsTable();
                for (int i = 0; i < npoints; ++i) {
                    int[] xy = (int[])xyVector.elementAt(i);
                    rt.incrementCounter();
                    rt.addValue("X", (double)xy[0]);
                    rt.addValue("Y", (double)xy[1]);
                }
                rt.show("Results");
            } else if (outputType == 5) {
                ResultsTable rt = ResultsTable.getResultsTable();
                rt.incrementCounter();
                rt.setValue("Count", rt.getCounter() - 1, (double)npoints);
                int measurements = Analyzer.getMeasurements();
                if ((measurements & 0x400) != 0) {
                    String roiName;
                    String s = this.imp.getTitle();
                    String string = roiName = roi != null ? roi.getName() : null;
                    if (roiName != null) {
                        s = s + ":" + roiName;
                    }
                    if (this.imp.getStackSize() > 1) {
                        ImageStack stack = this.imp.getStack();
                        int currentSlice = this.imp.getCurrentSlice();
                        String label = stack.getShortSliceLabel(currentSlice);
                        String colon = s.equals("") ? "" : ":";
                        s = label != null && !label.equals("") ? s + colon + label : s + colon + currentSlice;
                    }
                    rt.setLabel(s, rt.getCounter() - 1);
                }
                rt.show("Results");
            }
        }
        if (this.previewing) {
            this.messageArea.setText((xyVector == null ? 0 : xyVector.size()) + " Maxima");
        }
    }

    ByteProcessor make8bit(ImageProcessor ip, ByteProcessor typeP, boolean isEDM, float globalMin, float globalMax, double threshold) {
        double minValue;
        byte[] types = (byte[])typeP.getPixels();
        if (isEDM) {
            threshold = 0.5;
            minValue = 1.0;
        } else {
            minValue = threshold == -808080.0 ? (double)globalMin : threshold;
        }
        double offset = minValue - ((double)globalMax - minValue) * 0.001975284584980237;
        double factor = 253.0 / ((double)globalMax - minValue);
        if (isEDM && factor > 1.0) {
            factor = 1.0;
        }
        ByteProcessor outIp = new ByteProcessor(this.width, this.height);
        byte[] pixels = (byte[])outIp.getPixels();
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                long v;
                float rawValue = ip.getPixelValue(x, y);
                pixels[i] = threshold != -808080.0 && (double)rawValue < threshold ? 0 : ((types[i] & 8) != 0 ? -1 : ((v = 1L + Math.round(((double)rawValue - offset) * factor)) < 1L ? 1 : (v <= 254L ? (int)((int)(v & 0xFFL)) : -2)));
                ++x;
                ++i;
            }
        }
        return outIp;
    }

    float trueEdmHeight(int x, int y, ImageProcessor ip) {
        int xmax = this.width - 1;
        int ymax = ip.getHeight() - 1;
        float[] pixels = (float[])ip.getPixels();
        int offset = x + y * this.width;
        float v = pixels[offset];
        if (x == 0 || y == 0 || x == xmax || y == ymax || v == 0.0f) {
            return v;
        }
        float trueH = v + 0.70710677f;
        boolean ridgeOrMax = false;
        for (int d = 0; d < 4; ++d) {
            float h;
            int d2 = (d + 4) % 8;
            float v1 = pixels[offset + this.dirOffset[d]];
            float v2 = pixels[offset + this.dirOffset[d2]];
            if (v >= v1 && v >= v2) {
                ridgeOrMax = true;
                h = (v1 + v2) / 2.0f;
            } else {
                h = Math.min(v1, v2);
            }
            h += d % 2 == 0 ? 1.0f : 1.4142135f;
            if (!(trueH > h)) continue;
            trueH = h;
        }
        if (!ridgeOrMax) {
            trueH = v;
        }
        return trueH;
    }

    void cleanupMaxima(ByteProcessor outIp, ByteProcessor typeP, long[] maxPoints) {
        byte[] pixels = (byte[])outIp.getPixels();
        byte[] types = (byte[])typeP.getPixels();
        int nMax = maxPoints.length;
        int[] pList = new int[this.width * this.height];
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            int offset;
            int offset0 = (int)maxPoints[iMax];
            if ((types[offset0] & 0x48) != 0) continue;
            int level = pixels[offset0] & 0xFF;
            int loLevel = level + 1;
            pList[0] = offset0;
            int n = offset0;
            types[n] = (byte)(types[n] | 2);
            int listLen = 1;
            int lastLen = 1;
            int listI = 0;
            boolean saddleFound = false;
            while (!saddleFound && loLevel > 0) {
                --loLevel;
                lastLen = listLen;
                listI = 0;
                block2: do {
                    offset = pList[listI];
                    int x = offset % this.width;
                    int y = offset / this.width;
                    boolean isInner = y != 0 && y != this.height - 1 && x != 0 && x != this.width - 1;
                    for (int d = 0; d < 8; ++d) {
                        int offset2 = offset + this.dirOffset[d];
                        if (!isInner && !this.isWithin(x, y, d) || (types[offset2] & 2) != 0) continue;
                        if ((types[offset2] & 8) != 0 || (types[offset2] & 0x40) != 0 && (pixels[offset2] & 0xFF) >= loLevel) {
                            saddleFound = true;
                            continue block2;
                        }
                        if ((pixels[offset2] & 0xFF) < loLevel || (types[offset2] & 0x40) != 0) continue;
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                    }
                } while (!saddleFound && ++listI < listLen);
            }
            for (listI = 0; listI < listLen; ++listI) {
                int n3 = pList[listI];
                types[n3] = (byte)(types[n3] & 0xFFFFFFFD);
            }
            for (listI = 0; listI < lastLen; ++listI) {
                offset = pList[listI];
                pixels[offset] = (byte)loLevel;
                int n4 = offset;
                types[n4] = (byte)(types[n4] | 0x40);
            }
        }
    }

    void cleanupExtraLines(ImageProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                byte v = pixels[i];
                if (v != -1 && v != 0) {
                    int nRadii = this.nRadii(pixels, x, y);
                    if (nRadii == 0) {
                        pixels[i] = -1;
                    } else if (nRadii == 1) {
                        this.removeLineFrom(pixels, x, y);
                    }
                }
                ++x;
                ++i;
            }
        }
    }

    void removeLineFrom(byte[] pixels, int x, int y) {
        boolean continues;
        pixels[x + this.width * y] = -1;
        block0: do {
            continues = false;
            boolean isInner = y != 0 && y != this.height - 1 && x != 0 && x != this.width - 1;
            for (int d = 0; d < 8; d += 2) {
                int nRadii;
                byte v;
                if (!isInner && !this.isWithin(x, y, d) || (v = pixels[x + this.width * y + this.dirOffset[d]]) == -1 || v == 0 || (nRadii = this.nRadii(pixels, x + DIR_X_OFFSET[d], y + DIR_Y_OFFSET[d])) > 1) continue;
                pixels[(x += MaximumFinder.DIR_X_OFFSET[d]) + this.width * (y += MaximumFinder.DIR_Y_OFFSET[d])] = -1;
                continues = nRadii == 1;
                continue block0;
            }
        } while (continues);
    }

    int nRadii(byte[] pixels, int x, int y) {
        int offset = x + y * this.width;
        int countTransitions = 0;
        boolean prevPixelSet = true;
        boolean firstPixelSet = true;
        boolean isInner = y != 0 && y != this.height - 1 && x != 0 && x != this.width - 1;
        for (int d = 0; d < 8; ++d) {
            boolean pixelSet = prevPixelSet;
            if (isInner || this.isWithin(x, y, d)) {
                boolean isSet;
                boolean bl = isSet = pixels[offset + this.dirOffset[d]] != -1;
                if ((d & 1) == 0) {
                    pixelSet = isSet;
                } else if (!isSet) {
                    pixelSet = false;
                }
            } else {
                pixelSet = true;
            }
            if (pixelSet && !prevPixelSet) {
                ++countTransitions;
            }
            prevPixelSet = pixelSet;
            if (d != 0) continue;
            firstPixelSet = pixelSet;
        }
        if (firstPixelSet && !prevPixelSet) {
            ++countTransitions;
        }
        return countTransitions;
    }

    private void watershedPostProcess(ImageProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        int size = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < size; ++i) {
            if ((pixels[i] & 0xFF) >= 255) continue;
            pixels[i] = 0;
        }
    }

    void deleteEdgeParticles(ByteProcessor ip, ByteProcessor typeP) {
        byte[] pixels = (byte[])ip.getPixels();
        byte[] types = (byte[])typeP.getPixels();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        ip.setValue(0.0);
        Wand wand = new Wand(ip);
        for (int x = 0; x < this.width; ++x) {
            int y = 0;
            if ((types[x + y * this.width] & 8) != 0 && pixels[x + y * this.width] != 0) {
                this.deleteParticle(x, y, ip, wand);
            }
            if ((types[x + (y = this.height - 1) * this.width] & 8) == 0 || pixels[x + y * this.width] == 0) continue;
            this.deleteParticle(x, y, ip, wand);
        }
        for (int y = 1; y < this.height - 1; ++y) {
            int x = 0;
            if ((types[x + y * this.width] & 8) != 0 && pixels[x + y * this.width] != 0) {
                this.deleteParticle(x, y, ip, wand);
            }
            if ((types[(x = this.width - 1) + y * this.width] & 8) == 0 || pixels[x + y * this.width] == 0) continue;
            this.deleteParticle(x, y, ip, wand);
        }
    }

    void deleteParticle(int x, int y, ByteProcessor ip, Wand wand) {
        wand.autoOutline(x, y, 255, 255);
        if (wand.npoints == 0) {
            IJ.log("wand error selecting edge particle at x, y = " + x + ", " + y);
            return;
        }
        PolygonRoi roi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 4);
        ip.snapshot();
        ip.setRoi(roi);
        ip.fill();
        ip.reset(ip.getMask());
    }

    private boolean watershedSegment(ByteProcessor ip) {
        boolean debug = IJ.debugMode;
        ImageStack movie = null;
        if (debug) {
            movie = new ImageStack(ip.getWidth(), ip.getHeight());
            movie.addSlice("pre-watershed EDM", ip.duplicate());
        }
        byte[] pixels = (byte[])ip.getPixels();
        int[] histogram = ip.getHistogram();
        int arraySize = this.width * this.height - histogram[0] - histogram[255];
        int[] coordinates = new int[arraySize];
        int highestValue = 0;
        int maxBinSize = 0;
        int offset = 0;
        int[] levelStart = new int[256];
        for (int v = 1; v < 255; ++v) {
            levelStart[v] = offset;
            offset += histogram[v];
            if (histogram[v] > 0) {
                highestValue = v;
            }
            if (histogram[v] <= maxBinSize) continue;
            maxBinSize = histogram[v];
        }
        int[] levelOffset = new int[highestValue + 1];
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int v = pixels[i] & 0xFF;
                if (v > 0 && v < 255) {
                    offset = levelStart[v] + levelOffset[v];
                    coordinates[offset] = x | y << this.intEncodeShift;
                    int n = v;
                    levelOffset[n] = levelOffset[n] + 1;
                }
                ++x;
                ++i;
            }
        }
        int[] setPointList = new int[Math.min(maxBinSize, (this.width * this.height + 2) / 3)];
        int[] table = this.makeFateTable();
        IJ.showStatus("Segmenting (Esc to cancel)");
        int[] directionSequence = new int[]{7, 3, 1, 5, 0, 4, 2, 6};
        for (int level = highestValue; level >= 1; --level) {
            int remaining = histogram[level];
            int idle = 0;
            while (remaining > 0 && idle < 8) {
                int sumN = 0;
                int dIndex = 0;
                do {
                    int n = this.processLevel(directionSequence[dIndex % 8], ip, table, levelStart[level], remaining, coordinates, setPointList);
                    remaining -= n;
                    sumN += n;
                    if (n > 0) {
                        idle = 0;
                    }
                    ++dIndex;
                } while (remaining > 0 && idle++ < 8);
                this.addProgress((double)sumN / (double)arraySize);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                IJ.showProgress(1.0);
                return false;
            }
            if (remaining > 0 && level > 1) {
                int nextLevel = level;
                while (--nextLevel > 1 && histogram[nextLevel] == 0) {
                }
                if (nextLevel > 0) {
                    int newNextLevelEnd = levelStart[nextLevel] + histogram[nextLevel];
                    int i2 = 0;
                    int p = levelStart[level];
                    while (i2 < remaining) {
                        int xy = coordinates[p];
                        int x = xy & this.intEncodeXMask;
                        int y = (xy & this.intEncodeYMask) >> this.intEncodeShift;
                        int pOffset = x + y * this.width;
                        if ((pixels[pOffset] & 0xFF) == 255) {
                            IJ.log("ERROR");
                        }
                        boolean addToNext = false;
                        if (x == 0 || y == 0 || x == this.width - 1 || y == this.height - 1) {
                            addToNext = true;
                        } else {
                            for (int d = 0; d < 8; ++d) {
                                if (!this.isWithin(x, y, d) || pixels[pOffset + this.dirOffset[d]] != 0) continue;
                                addToNext = true;
                                break;
                            }
                        }
                        if (addToNext) {
                            coordinates[newNextLevelEnd++] = xy;
                        }
                        ++i2;
                        ++p;
                    }
                    histogram[nextLevel] = newNextLevelEnd - levelStart[nextLevel];
                }
            }
            if (!debug || level <= 170 && (level <= 100 || level >= 110) && level >= 10) continue;
            movie.addSlice("level " + level, ip.duplicate());
        }
        if (debug) {
            new ImagePlus("Segmentation Movie", movie).show();
        }
        return true;
    }

    private int processLevel(int pass, ImageProcessor ip, int[] fateTable, int levelStart, int levelNPoints, int[] coordinates, int[] setPointList) {
        int xmax = this.width - 1;
        int ymax = this.height - 1;
        byte[] pixels = (byte[])ip.getPixels();
        int nChanged = 0;
        int nUnchanged = 0;
        int i = 0;
        int p = levelStart;
        while (i < levelNPoints) {
            int mask;
            int xy = coordinates[p];
            int x = xy & this.intEncodeXMask;
            int y = (xy & this.intEncodeYMask) >> this.intEncodeShift;
            int offset = x + y * this.width;
            int index = 0;
            if (y > 0 && (pixels[offset - this.width] & 0xFF) == 255) {
                index ^= 1;
            }
            if (x < xmax && y > 0 && (pixels[offset - this.width + 1] & 0xFF) == 255) {
                index ^= 2;
            }
            if (x < xmax && (pixels[offset + 1] & 0xFF) == 255) {
                index ^= 4;
            }
            if (x < xmax && y < ymax && (pixels[offset + this.width + 1] & 0xFF) == 255) {
                index ^= 8;
            }
            if (y < ymax && (pixels[offset + this.width] & 0xFF) == 255) {
                index ^= 0x10;
            }
            if (x > 0 && y < ymax && (pixels[offset + this.width - 1] & 0xFF) == 255) {
                index ^= 0x20;
            }
            if (x > 0 && (pixels[offset - 1] & 0xFF) == 255) {
                index ^= 0x40;
            }
            if (x > 0 && y > 0 && (pixels[offset - this.width - 1] & 0xFF) == 255) {
                index ^= 0x80;
            }
            if ((fateTable[index] & (mask = 1 << pass)) == mask) {
                setPointList[nChanged++] = offset;
            } else {
                coordinates[levelStart + nUnchanged++] = xy;
            }
            ++i;
            ++p;
        }
        for (i = 0; i < nChanged; ++i) {
            pixels[setPointList[i]] = -1;
        }
        return nChanged;
    }

    private int[] makeFateTable() {
        int[] table = new int[256];
        boolean[] isSet = new boolean[8];
        for (int item = 0; item < 256; ++item) {
            int i;
            int mask = 1;
            for (i = 0; i < 8; ++i) {
                isSet[i] = (item & mask) == mask;
                mask *= 2;
            }
            mask = 1;
            for (i = 0; i < 8; ++i) {
                if (isSet[(i + 4) % 8]) {
                    int n = item;
                    table[n] = table[n] | mask;
                }
                mask *= 2;
            }
            for (i = 0; i < 8; i += 2) {
                if (!isSet[i]) continue;
                isSet[(i + 1) % 8] = true;
                isSet[(i + 7) % 8] = true;
            }
            int transitions = 0;
            boolean mask2 = true;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (isSet[i2] == isSet[(i2 + 1) % 8]) continue;
                ++transitions;
            }
            if (transitions < 4) continue;
            table[item] = 0;
        }
        return table;
    }

    void makeDirectionOffsets(ImageProcessor ip) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        int shift = 0;
        int mult = 1;
        do {
            ++shift;
        } while ((mult *= 2) < this.width);
        this.intEncodeXMask = mult - 1;
        this.intEncodeYMask = ~this.intEncodeXMask;
        this.intEncodeShift = shift;
        this.dirOffset = new int[]{-this.width, -this.width + 1, 1, this.width + 1, this.width, this.width - 1, -1, -this.width - 1};
    }

    boolean isWithin(int x, int y, int direction) {
        int xmax = this.width - 1;
        int ymax = this.height - 1;
        switch (direction) {
            case 0: {
                return y > 0;
            }
            case 1: {
                return x < xmax && y > 0;
            }
            case 2: {
                return x < xmax;
            }
            case 3: {
                return x < xmax && y < ymax;
            }
            case 4: {
                return y < ymax;
            }
            case 5: {
                return x > 0 && y < ymax;
            }
            case 6: {
                return x > 0;
            }
            case 7: {
                return x > 0 && y > 0;
            }
        }
        return false;
    }

    private void addProgress(double deltaProgress) {
        if (this.nPasses == 0) {
            return;
        }
        this.progressDone += deltaProgress;
        IJ.showProgress(this.progressDone / (double)this.nPasses);
    }

    static {
        dialogOutputType = 3;
        outputTypeNames = new String[]{"Single Points", "Maxima Within Tolerance", "Segmented Particles", "Point Selection", "List", "Count"};
        DIR_X_OFFSET = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        DIR_Y_OFFSET = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
        outputTypeMasks = new byte[]{32, 8, 8};
    }
}

