/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CommandListener;
import ij.CompositeImage;
import ij.Executer;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.ScrollbarWithLabel;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.image.ColorModel;

public class Orthogonal_Views
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
ImageListener,
WindowListener,
AdjustmentListener,
MouseWheelListener,
FocusListener,
CommandListener {
    private ImageWindow win;
    private ImagePlus imp;
    private boolean rgb;
    private ImageStack imageStack;
    private boolean hyperstack;
    private int currentChannel;
    private int currentFrame;
    private int currentMode;
    private ImageCanvas canvas;
    private static final int H_ROI = 0;
    private static final int H_ZOOM = 1;
    private static boolean sticky = true;
    private static int xzID;
    private static int yzID;
    private static Orthogonal_Views instance;
    private ImagePlus xz_image;
    private ImagePlus yz_image;
    private ImageProcessor fp1;
    private ImageProcessor fp2;
    private double ax;
    private double ay;
    private double az;
    private boolean rotateYZ = Prefs.rotateYZ;
    private boolean flipXZ = Prefs.flipXZ;
    private int xyX;
    private int xyY;
    private Calibration cal = null;
    private Calibration cal_xz = new Calibration();
    private Calibration cal_yz = new Calibration();
    private double magnification = 1.0;
    private Color color = Roi.getColor();
    private Updater updater = new Updater();
    private double min;
    private double max;
    private Dimension screen = IJ.getScreenSize();
    private boolean syncZoom = true;
    private Point crossLoc;
    private boolean firstTime = true;
    private static int previousID;
    private static int previousX;
    private static int previousY;
    private Rectangle startingSrcRect;

    public void run(String arg) {
        int yzBitDepth;
        this.imp = IJ.getImage();
        if (instance != null) {
            instance.dispose();
            return;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.error("Othogonal Views", "This command requires a stack.");
            return;
        }
        this.hyperstack = this.imp.isHyperStack();
        if ((this.hyperstack || this.imp.isComposite()) && this.imp.getNSlices() <= 1) {
            IJ.error("Othogonal Views", "This command requires a stack, or a hypertack with Z>1.");
            return;
        }
        this.yz_image = WindowManager.getImage(yzID);
        this.rgb = this.imp.getBitDepth() == 24 || this.hyperstack;
        int n = yzBitDepth = this.hyperstack ? 24 : this.imp.getBitDepth();
        if (this.yz_image == null || this.yz_image.getHeight() != this.imp.getHeight() || this.yz_image.getBitDepth() != yzBitDepth) {
            this.yz_image = new ImagePlus();
        }
        this.xz_image = WindowManager.getImage(xzID);
        if (this.xz_image == null || this.xz_image.getWidth() != this.imp.getWidth() || this.xz_image.getBitDepth() != yzBitDepth) {
            this.xz_image = new ImagePlus();
        }
        instance = this;
        ImageProcessor ip = this.hyperstack ? new ColorProcessor(this.imp.getImage()) : this.imp.getProcessor();
        this.min = ip.getMin();
        this.max = ip.getMax();
        this.cal = this.imp.getCalibration();
        double calx = this.cal.pixelWidth;
        double caly = this.cal.pixelHeight;
        double calz = this.cal.pixelDepth;
        this.ax = 1.0;
        this.ay = caly / calx;
        this.az = calz / calx;
        this.win = this.imp.getWindow();
        this.canvas = this.win.getCanvas();
        this.addListeners(this.canvas);
        this.magnification = this.canvas.getMagnification();
        this.imp.deleteRoi();
        Rectangle r = this.canvas.getSrcRect();
        this.crossLoc = this.imp.getID() == previousID ? new Point(previousX, previousY) : new Point(r.x + r.width / 2, r.y + r.height / 2);
        this.imageStack = this.getStack();
        this.calibrate();
        if (this.createProcessors(this.imageStack)) {
            if (ip.isColorLut() || ip.isInvertedLut()) {
                ColorModel cm = ip.getColorModel();
                this.fp1.setColorModel(cm);
                this.fp2.setColorModel(cm);
            }
            this.update();
        } else {
            this.dispose();
        }
    }

    private ImageStack getStack() {
        if (this.imp.isHyperStack()) {
            int slices = this.imp.getNSlices();
            ImageStack stack = new ImageStack(this.imp.getWidth(), this.imp.getHeight());
            int c = this.imp.getChannel();
            int z = this.imp.getSlice();
            int t = this.imp.getFrame();
            for (int i = 1; i <= slices; ++i) {
                this.imp.setPositionWithoutUpdate(c, i, t);
                stack.addSlice(null, new ColorProcessor(this.imp.getImage()));
            }
            this.imp.setPosition(c, z, t);
            this.currentChannel = c;
            this.currentFrame = t;
            if (this.imp.isComposite()) {
                this.currentMode = ((CompositeImage)this.imp).getMode();
            }
            return stack;
        }
        return this.imp.getStack();
    }

    private void addListeners(ImageCanvas canvas) {
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addKeyListener(this);
        this.win.addWindowListener(this);
        this.win.addMouseWheelListener(this);
        this.win.addFocusListener(this);
        Component[] c = this.win.getComponents();
        ((ScrollbarWithLabel)c[1]).addAdjustmentListener(this);
        ImagePlus.addImageListener(this);
        Executer.addCommandListener(this);
    }

    private void calibrate() {
        String unit = this.cal.getUnit();
        double o_depth = this.cal.pixelDepth;
        double o_height = this.cal.pixelHeight;
        double o_width = this.cal.pixelWidth;
        this.cal_yz.setUnit(unit);
        if (this.rotateYZ) {
            this.cal_yz.pixelHeight = o_depth / this.az;
            this.cal_yz.pixelWidth = o_height;
        } else {
            this.cal_yz.pixelWidth = o_depth / this.az;
            this.cal_yz.pixelHeight = o_height;
        }
        this.yz_image.setCalibration(this.cal_yz);
        this.cal_xz.setUnit(unit);
        this.cal_xz.pixelWidth = o_width;
        this.cal_xz.pixelHeight = o_depth / this.az;
        this.xz_image.setCalibration(this.cal_xz);
    }

    private void updateMagnification(int x, int y) {
        double magnification = this.win.getCanvas().getMagnification();
        int z = this.imp.getSlice() - 1;
        ImageWindow xz_win = this.xz_image.getWindow();
        if (xz_win == null) {
            return;
        }
        ImageCanvas xz_ic = xz_win.getCanvas();
        double xz_mag = xz_ic.getMagnification();
        double arat = this.az / this.ax;
        int zcoord = (int)(arat * (double)z);
        if (this.flipXZ) {
            zcoord = (int)(arat * (double)(this.imp.getNSlices() - z));
        }
        while (xz_mag < magnification) {
            xz_ic.zoomIn(xz_ic.screenX(x), xz_ic.screenY(zcoord));
            xz_mag = xz_ic.getMagnification();
        }
        while (xz_mag > magnification) {
            xz_ic.zoomOut(xz_ic.screenX(x), xz_ic.screenY(zcoord));
            xz_mag = xz_ic.getMagnification();
        }
        ImageWindow yz_win = this.yz_image.getWindow();
        if (yz_win == null) {
            return;
        }
        ImageCanvas yz_ic = yz_win.getCanvas();
        double yz_mag = yz_ic.getMagnification();
        zcoord = (int)(arat * (double)z);
        while (yz_mag < magnification) {
            yz_ic.zoomIn(yz_ic.screenX(zcoord), yz_ic.screenY(y));
            yz_mag = yz_ic.getMagnification();
        }
        while (yz_mag > magnification) {
            yz_ic.zoomOut(yz_ic.screenX(zcoord), yz_ic.screenY(y));
            yz_mag = yz_ic.getMagnification();
        }
    }

    void updateViews(Point p, ImageStack is) {
        ImageCanvas ic;
        if (this.fp1 == null) {
            return;
        }
        this.updateXZView(p, is);
        double arat = this.az / this.ax;
        int width2 = this.fp1.getWidth();
        int height2 = (int)Math.round((double)this.fp1.getHeight() * this.az);
        if (width2 != this.fp1.getWidth() || height2 != this.fp1.getHeight()) {
            this.fp1.setInterpolate(true);
            ImageProcessor sfp1 = this.fp1.resize(width2, height2);
            if (!this.rgb) {
                sfp1.setMinAndMax(this.min, this.max);
            }
            this.xz_image.setProcessor("XZ " + p.y, sfp1);
        } else {
            if (!this.rgb) {
                this.fp1.setMinAndMax(this.min, this.max);
            }
            this.xz_image.setProcessor("XZ " + p.y, this.fp1);
        }
        if (this.rotateYZ) {
            this.updateYZView(p, is);
        } else {
            this.updateZYView(p, is);
        }
        width2 = (int)Math.round((double)this.fp2.getWidth() * this.az);
        height2 = this.fp2.getHeight();
        String title = "YZ ";
        if (this.rotateYZ) {
            width2 = this.fp2.getWidth();
            height2 = (int)Math.round((double)this.fp2.getHeight() * this.az);
            title = "ZY ";
        }
        if (width2 != this.fp2.getWidth() || height2 != this.fp2.getHeight()) {
            this.fp2.setInterpolate(true);
            ImageProcessor sfp2 = this.fp2.resize(width2, height2);
            if (!this.rgb) {
                sfp2.setMinAndMax(this.min, this.max);
            }
            this.yz_image.setProcessor(title + p.x, sfp2);
        } else {
            if (!this.rgb) {
                this.fp2.setMinAndMax(this.min, this.max);
            }
            this.yz_image.setProcessor(title + p.x, this.fp2);
        }
        this.calibrate();
        if (this.yz_image.getWindow() == null) {
            this.yz_image.show();
            ic = this.yz_image.getCanvas();
            ic.addKeyListener(this);
            ic.addMouseListener(this);
            ic.addMouseMotionListener(this);
            ic.setCustomRoi(true);
            this.yz_image.getWindow().addMouseWheelListener(this);
            yzID = this.yz_image.getID();
        } else {
            ic = this.yz_image.getWindow().getCanvas();
            ic.addMouseListener(this);
            ic.addMouseMotionListener(this);
            ic.setCustomRoi(true);
        }
        if (this.xz_image.getWindow() == null) {
            this.xz_image.show();
            ic = this.xz_image.getCanvas();
            ic.addKeyListener(this);
            ic.addMouseListener(this);
            ic.addMouseMotionListener(this);
            ic.setCustomRoi(true);
            this.xz_image.getWindow().addMouseWheelListener(this);
            xzID = this.xz_image.getID();
        } else {
            ic = this.xz_image.getWindow().getCanvas();
            ic.addMouseListener(this);
            ic.addMouseMotionListener(this);
            ic.setCustomRoi(true);
        }
    }

    void arrangeWindows(boolean sticky) {
        ImageWindow xyWin = this.imp.getWindow();
        if (xyWin == null) {
            return;
        }
        Point loc = xyWin.getLocation();
        if (this.xyX != loc.x || this.xyY != loc.y) {
            this.xyX = loc.x;
            this.xyY = loc.y;
            ImageWindow yzWin = null;
            long start = System.currentTimeMillis();
            while (yzWin == null && System.currentTimeMillis() - start <= 2500L) {
                yzWin = this.yz_image.getWindow();
                if (yzWin != null) continue;
                IJ.wait(50);
            }
            if (yzWin != null) {
                yzWin.setLocation(this.xyX + xyWin.getWidth(), this.xyY);
            }
            ImageWindow xzWin = null;
            start = System.currentTimeMillis();
            while (xzWin == null && System.currentTimeMillis() - start <= 2500L) {
                xzWin = this.xz_image.getWindow();
                if (xzWin != null) continue;
                IJ.wait(50);
            }
            if (xzWin != null) {
                xzWin.setLocation(this.xyX, this.xyY + xyWin.getHeight());
            }
            if (this.firstTime) {
                this.imp.getWindow().toFront();
                if (this.hyperstack) {
                    this.imp.setPosition(this.imp.getChannel(), this.imp.getNSlices() / 2, this.imp.getFrame());
                } else {
                    this.imp.setSlice(this.imp.getNSlices() / 2);
                }
                this.firstTime = false;
            }
        }
    }

    boolean createProcessors(ImageStack is) {
        ImageProcessor ip = is.getProcessor(1);
        int width = is.getWidth();
        int height = is.getHeight();
        int ds = is.getSize();
        double arat = 1.0;
        double brat = 1.0;
        int za = (int)((double)ds * arat);
        int zb = (int)((double)ds * brat);
        if (ip instanceof FloatProcessor) {
            this.fp1 = new FloatProcessor(width, za);
            this.fp2 = this.rotateYZ ? new FloatProcessor(height, zb) : new FloatProcessor(zb, height);
            return true;
        }
        if (ip instanceof ByteProcessor) {
            this.fp1 = new ByteProcessor(width, za);
            this.fp2 = this.rotateYZ ? new ByteProcessor(height, zb) : new ByteProcessor(zb, height);
            return true;
        }
        if (ip instanceof ShortProcessor) {
            this.fp1 = new ShortProcessor(width, za);
            this.fp2 = this.rotateYZ ? new ShortProcessor(height, zb) : new ShortProcessor(zb, height);
            return true;
        }
        if (ip instanceof ColorProcessor) {
            this.fp1 = new ColorProcessor(width, za);
            this.fp2 = this.rotateYZ ? new ColorProcessor(height, zb) : new ColorProcessor(zb, height);
            return true;
        }
        return false;
    }

    void updateXZView(Point p, ImageStack is) {
        int width = is.getWidth();
        int size = is.getSize();
        ImageProcessor ip = is.getProcessor(1);
        int y = p.y;
        if (ip instanceof ShortProcessor) {
            short[] newpix = new short[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
        if (ip instanceof ByteProcessor) {
            byte[] newpix = new byte[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
        if (ip instanceof FloatProcessor) {
            float[] newpix = new float[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
        if (ip instanceof ColorProcessor) {
            int[] newpix = new int[width * size];
            for (int i = 0; i < size; ++i) {
                Object pixels = is.getPixels(i + 1);
                if (this.flipXZ) {
                    System.arraycopy(pixels, width * y, newpix, width * (size - i - 1), width);
                    continue;
                }
                System.arraycopy(pixels, width * y, newpix, width * i, width);
            }
            this.fp1.setPixels(newpix);
            return;
        }
    }

    void updateYZView(Point p, ImageStack is) {
        int j;
        Object[] pixels;
        int i;
        Object[] newpix;
        int width = is.getWidth();
        int height = is.getHeight();
        int ds = is.getSize();
        ImageProcessor ip = is.getProcessor(1);
        int x = p.x;
        if (ip instanceof FloatProcessor) {
            newpix = new float[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (float[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ByteProcessor) {
            newpix = new byte[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (byte[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ShortProcessor) {
            newpix = new short[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (short[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ColorProcessor) {
            newpix = new int[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (int[])is.getPixels(i + 1);
                for (j = 0; j < height; ++j) {
                    newpix[(ds - i - 1) * height + j] = pixels[x + j * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (!this.flipXZ) {
            this.fp2.flipVertical();
        }
    }

    void updateZYView(Point p, ImageStack is) {
        int y;
        Object[] pixels;
        int i;
        Object[] newpix;
        int width = is.getWidth();
        int height = is.getHeight();
        int ds = is.getSize();
        ImageProcessor ip = is.getProcessor(1);
        int x = p.x;
        if (ip instanceof FloatProcessor) {
            newpix = new float[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (float[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ByteProcessor) {
            newpix = new byte[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (byte[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ShortProcessor) {
            newpix = new short[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (short[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
        if (ip instanceof ColorProcessor) {
            newpix = new int[ds * height];
            for (i = 0; i < ds; ++i) {
                pixels = (int[])is.getPixels(i + 1);
                for (y = 0; y < height; ++y) {
                    newpix[i + y * ds] = pixels[x + y * width];
                }
            }
            this.fp2.setPixels(newpix);
        }
    }

    void drawCross(ImagePlus imp, Point p, GeneralPath path) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        float x = p.x;
        float y = p.y;
        path.moveTo(0.0f, y);
        path.lineTo(width, y);
        path.moveTo(x, 0.0f);
        path.lineTo(x, height);
    }

    void dispose() {
        this.updater.quit();
        this.updater = null;
        this.imp.setOverlay(null);
        this.canvas.removeMouseListener(this);
        this.canvas.removeMouseMotionListener(this);
        this.canvas.removeKeyListener(this);
        this.canvas.setCustomRoi(false);
        this.xz_image.setOverlay(null);
        ImageWindow win1 = this.xz_image.getWindow();
        if (win1 != null) {
            win1.removeMouseWheelListener(this);
            ImageCanvas ic = win1.getCanvas();
            if (ic != null) {
                ic.removeKeyListener(this);
                ic.removeMouseListener(this);
                ic.removeMouseMotionListener(this);
                ic.setCustomRoi(false);
            }
        }
        this.yz_image.setOverlay(null);
        ImageWindow win2 = this.yz_image.getWindow();
        if (win2 != null) {
            win2.removeMouseWheelListener(this);
            ImageCanvas ic = win2.getCanvas();
            if (ic != null) {
                ic.removeKeyListener(this);
                ic.removeMouseListener(this);
                ic.removeMouseMotionListener(this);
                ic.setCustomRoi(false);
            }
        }
        ImagePlus.removeImageListener(this);
        Executer.removeCommandListener(this);
        this.win.removeWindowListener(this);
        this.win.removeMouseWheelListener(this);
        this.win.removeFocusListener(this);
        Component[] c = this.win.getComponents();
        ((ScrollbarWithLabel)c[1]).removeAdjustmentListener(this);
        this.win.setResizable(true);
        instance = null;
        previousID = this.imp.getID();
        previousX = this.crossLoc.x;
        previousY = this.crossLoc.y;
        this.imageStack = null;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        ImageCanvas xyCanvas = this.imp.getCanvas();
        this.startingSrcRect = (Rectangle)xyCanvas.getSrcRect().clone();
        this.mouseDragged(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (IJ.spaceBarDown()) {
            return;
        }
        if (e.getSource().equals(this.canvas)) {
            this.crossLoc = this.canvas.getCursorLoc();
        } else if (e.getSource().equals(this.xz_image.getCanvas())) {
            int slice;
            this.crossLoc.x = this.xz_image.getCanvas().getCursorLoc().x;
            int pos = this.xz_image.getCanvas().getCursorLoc().y;
            int z = (int)Math.round((double)pos / this.az);
            int n = slice = this.flipXZ ? this.imp.getNSlices() - z : z + 1;
            if (this.hyperstack) {
                this.imp.setPosition(this.imp.getChannel(), slice, this.imp.getFrame());
            } else {
                this.imp.setSlice(slice);
            }
        } else if (e.getSource().equals(this.yz_image.getCanvas())) {
            int pos;
            if (this.rotateYZ) {
                this.crossLoc.y = this.yz_image.getCanvas().getCursorLoc().x;
                pos = this.yz_image.getCanvas().getCursorLoc().y;
            } else {
                this.crossLoc.y = this.yz_image.getCanvas().getCursorLoc().y;
                pos = this.yz_image.getCanvas().getCursorLoc().x;
            }
            int z = (int)Math.round((double)pos / this.az);
            if (this.hyperstack) {
                this.imp.setPosition(this.imp.getChannel(), z + 1, this.imp.getFrame());
            } else {
                this.imp.setSlice(z + 1);
            }
        }
        this.update();
    }

    public void mouseReleased(MouseEvent e) {
        ImageCanvas ic = this.imp.getCanvas();
        Rectangle srcRect = ic.getSrcRect();
        if (srcRect.x != this.startingSrcRect.x || srcRect.y != this.startingSrcRect.y) {
            int dy = srcRect.y - this.startingSrcRect.y;
            ImageCanvas yzic = this.yz_image.getCanvas();
            Rectangle yzSrcRect = yzic.getSrcRect();
            if (this.rotateYZ) {
                yzSrcRect.x += dy;
                if (yzSrcRect.x < 0) {
                    yzSrcRect.x = 0;
                }
                if (yzSrcRect.x > this.yz_image.getWidth() - yzSrcRect.width) {
                    yzSrcRect.y = this.yz_image.getWidth() - yzSrcRect.width;
                }
            } else {
                yzSrcRect.y += dy;
                if (yzSrcRect.y < 0) {
                    yzSrcRect.y = 0;
                }
                if (yzSrcRect.y > this.yz_image.getHeight() - yzSrcRect.height) {
                    yzSrcRect.y = this.yz_image.getHeight() - yzSrcRect.height;
                }
            }
            yzic.repaint();
            int dx = srcRect.x - this.startingSrcRect.x;
            ImageCanvas xzic = this.xz_image.getCanvas();
            Rectangle xzSrcRect = xzic.getSrcRect();
            xzSrcRect.x += dx;
            if (xzSrcRect.x < 0) {
                xzSrcRect.x = 0;
            }
            if (xzSrcRect.x > this.xz_image.getWidth() - xzSrcRect.width) {
                xzSrcRect.x = this.xz_image.getWidth() - xzSrcRect.width;
            }
            xzic.repaint();
        }
    }

    void update() {
        if (this.updater != null) {
            this.updater.doUpdate();
        }
    }

    private void exec() {
        ImageStack is;
        if (this.canvas == null) {
            return;
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        if (this.hyperstack) {
            int mode;
            int c = this.imp.getChannel();
            int t = this.imp.getFrame();
            if (c != this.currentChannel || t != this.currentFrame) {
                this.imageStack = null;
            }
            if (this.imp.isComposite() && (mode = ((CompositeImage)this.imp).getMode()) != this.currentMode) {
                this.imageStack = null;
            }
        }
        if ((is = this.imageStack) == null) {
            is = this.imageStack = this.getStack();
        }
        double arat = this.az / this.ax;
        double brat = this.az / this.ay;
        Point p = this.crossLoc;
        if (p.y >= height) {
            p.y = height - 1;
        }
        if (p.x >= width) {
            p.x = width - 1;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        this.updateViews(p, is);
        GeneralPath path = new GeneralPath();
        this.drawCross(this.imp, p, path);
        this.imp.setOverlay(path, this.color, new BasicStroke(1.0f));
        this.canvas.setCustomRoi(true);
        this.updateCrosses(p.x, p.y, arat, brat);
        if (this.syncZoom) {
            this.updateMagnification(p.x, p.y);
        }
        this.arrangeWindows(sticky);
    }

    private void updateCrosses(int x, int y, double arat, double brat) {
        int z = this.imp.getNSlices();
        int zlice = this.imp.getSlice() - 1;
        int zcoord = (int)Math.round(arat * (double)zlice);
        if (this.flipXZ) {
            zcoord = (int)Math.round(arat * (double)(z - zlice));
        }
        ImageCanvas xzCanvas = this.xz_image.getCanvas();
        Point p = new Point(x, zcoord);
        GeneralPath path = new GeneralPath();
        this.drawCross(this.xz_image, p, path);
        this.xz_image.setOverlay(path, this.color, new BasicStroke(1.0f));
        if (this.rotateYZ) {
            zcoord = this.flipXZ ? (int)Math.round(brat * (double)(z - zlice)) : (int)Math.round(brat * (double)zlice);
            p = new Point(y, zcoord);
        } else {
            zcoord = (int)Math.round(arat * (double)zlice);
            p = new Point(zcoord, y);
        }
        path = new GeneralPath();
        this.drawCross(this.yz_image, p, path);
        this.yz_image.setOverlay(path, this.color, new BasicStroke(1.0f));
        IJ.showStatus(this.imp.getLocationAsString(this.crossLoc.x, this.crossLoc.y));
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 27) {
            IJ.beep();
            this.dispose();
        } else if (IJ.shiftKeyDown()) {
            int width = this.imp.getWidth();
            int height = this.imp.getHeight();
            switch (key) {
                case 37: {
                    --this.crossLoc.x;
                    if (this.crossLoc.x >= 0) break;
                    this.crossLoc.x = 0;
                    break;
                }
                case 39: {
                    ++this.crossLoc.x;
                    if (this.crossLoc.x < width) break;
                    this.crossLoc.x = width - 1;
                    break;
                }
                case 38: {
                    --this.crossLoc.y;
                    if (this.crossLoc.y >= 0) break;
                    this.crossLoc.y = 0;
                    break;
                }
                case 40: {
                    ++this.crossLoc.y;
                    if (this.crossLoc.y < height) break;
                    this.crossLoc.y = height - 1;
                    break;
                }
                default: {
                    return;
                }
            }
            this.update();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void imageClosed(ImagePlus imp) {
        this.dispose();
    }

    public void imageOpened(ImagePlus imp) {
    }

    public void imageUpdated(ImagePlus imp) {
        if (imp == this.imp) {
            ImageProcessor ip = imp.getProcessor();
            this.min = ip.getMin();
            this.max = ip.getMax();
            this.update();
        }
    }

    public String commandExecuting(String command) {
        if (command.equals("In") || command.equals("Out")) {
            ImagePlus cimp = WindowManager.getCurrentImage();
            if (cimp == null) {
                return command;
            }
            if (cimp == this.imp) {
                ImageCanvas ic = this.imp.getCanvas();
                if (ic == null) {
                    return null;
                }
                int x = ic.screenX(this.crossLoc.x);
                int y = ic.screenY(this.crossLoc.y);
                if (command.equals("In")) {
                    ic.zoomIn(x, y);
                    if (ic.getMagnification() <= 1.0) {
                        this.imp.repaintWindow();
                    }
                } else {
                    ic.zoomOut(x, y);
                    if (ic.getMagnification() < 1.0) {
                        this.imp.repaintWindow();
                    }
                }
                this.xyX = this.crossLoc.x;
                this.xyY = this.crossLoc.y;
                this.update();
                return null;
            }
            if (cimp == this.xz_image || cimp == this.yz_image) {
                this.syncZoom = false;
                return command;
            }
            return command;
        }
        if (command.equals("Flip Vertically") && this.xz_image != null) {
            if (this.xz_image == WindowManager.getCurrentImage()) {
                this.flipXZ = !this.flipXZ;
                this.update();
                return null;
            }
            return command;
        }
        return command;
    }

    public void windowActivated(WindowEvent e) {
        this.arrangeWindows(sticky);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
        this.arrangeWindows(sticky);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.update();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getSource().equals(this.xz_image.getWindow())) {
            this.crossLoc.y += e.getWheelRotation();
        } else if (e.getSource().equals(this.yz_image.getWindow())) {
            this.crossLoc.x += e.getWheelRotation();
        }
        this.update();
    }

    public void focusGained(FocusEvent e) {
        ImageCanvas ic = this.imp.getCanvas();
        if (ic != null) {
            this.canvas.requestFocus();
        }
        this.arrangeWindows(sticky);
    }

    public void focusLost(FocusEvent e) {
        this.arrangeWindows(sticky);
    }

    public static ImagePlus getImage() {
        if (instance != null) {
            return Orthogonal_Views.instance.imp;
        }
        return null;
    }

    public static synchronized boolean isOrthoViewsImage(ImagePlus imp) {
        if (imp == null || instance == null) {
            return false;
        }
        return imp == Orthogonal_Views.instance.imp || imp == Orthogonal_Views.instance.xz_image || imp == Orthogonal_Views.instance.yz_image;
    }

    public static Orthogonal_Views getInstance() {
        return instance;
    }

    public int[] getCrossLoc() {
        int[] loc = new int[]{this.crossLoc.x, this.crossLoc.y, this.imp.getSlice() - 1};
        return loc;
    }

    public void setCrossLoc(int x, int y, int z) {
        this.crossLoc.setLocation(x, y);
        if (this.hyperstack) {
            this.imp.setPosition(this.imp.getChannel(), z + 1, this.imp.getFrame());
        } else {
            this.imp.setSlice(z + 1);
        }
        this.update();
    }

    public ImagePlus getXZImage() {
        return this.xz_image;
    }

    public ImagePlus getYZImage() {
        return this.yz_image;
    }

    private class Updater
    extends Thread {
        long request;

        Updater() {
            super("Othogonal Views Updater");
            this.request = 0L;
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doUpdate() {
            if (this.isInterrupted()) {
                return;
            }
            Updater updater = this;
            synchronized (updater) {
                ++this.request;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            IJ.wait(10);
            this.interrupt();
            Updater updater = this;
            synchronized (updater) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    long r;
                    Updater updater = this;
                    synchronized (updater) {
                        r = this.request;
                    }
                    if (r > 0L) {
                        Orthogonal_Views.this.exec();
                    }
                    updater = this;
                    synchronized (updater) {
                        if (r == this.request) {
                            this.request = 0L;
                            this.wait();
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

