/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.DicomTools;
import ij.util.StringSorter;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static String[] excludedTypes = new String[]{".txt", ".lut", ".roi", ".pty", ".hdr", ".java", ".ijm", ".py", ".js", ".bsh", ".xml"};
    private static boolean staticSortFileNames = true;
    private static boolean staticOpenAsVirtualStack;
    private boolean convertToRGB;
    private boolean sortFileNames = true;
    private boolean openAsVirtualStack;
    private double scale = 100.0;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private boolean isRegex;
    private String legacyRegex;
    private FileInfo fi;
    private String info1;
    private ImagePlus image;
    private boolean saveImage;

    public static ImagePlus open(String path) {
        FolderOpener fo = new FolderOpener();
        fo.saveImage = true;
        fo.run(path);
        return fo.image;
    }

    public ImagePlus openFolder(String path) {
        this.saveImage = true;
        this.run(path);
        return this.image;
    }

    public void run(String arg) {
        Overlay overlay;
        boolean allSameCalibration;
        Calibration cal;
        double max;
        double min;
        ImageStack stack;
        String title;
        String[] list;
        String directory;
        block86: {
            int index;
            directory = null;
            if (arg != null && !arg.equals("")) {
                directory = arg;
            } else {
                String macroOptions;
                if (!IJ.macroRunning()) {
                    this.sortFileNames = staticSortFileNames;
                    this.openAsVirtualStack = staticOpenAsVirtualStack;
                }
                arg = null;
                String title2 = "Open Image Sequence...";
                String string = macroOptions = IJ.macroRunning() ? Macro.getOptions() : null;
                if (macroOptions != null) {
                    File f;
                    directory = Macro.getValue(macroOptions, title2, null);
                    if (directory != null && !(f = new File(directory = OpenDialog.lookupPathVariable(directory))).isDirectory() && (f.exists() || directory.lastIndexOf(".") > directory.length() - 5)) {
                        directory = f.getParent();
                    }
                    this.legacyRegex = Macro.getValue(macroOptions, "or", "");
                    if (this.legacyRegex.equals("")) {
                        this.legacyRegex = null;
                    }
                }
                if (directory == null) {
                    if (Prefs.useFileChooser && !IJ.isMacOSX()) {
                        OpenDialog od = new OpenDialog(title2, arg);
                        directory = od.getDirectory();
                        String name = od.getFileName();
                        if (name == null) {
                            return;
                        }
                    } else {
                        directory = IJ.getDirectory(title2);
                    }
                }
            }
            if (directory == null) {
                return;
            }
            list = new File(directory).list();
            if (list == null) {
                return;
            }
            title = directory;
            if (title.endsWith(File.separator) || title.endsWith("/")) {
                title = title.substring(0, title.length() - 1);
            }
            if ((index = title.lastIndexOf(File.separatorChar)) != -1) {
                title = title.substring(index + 1);
            }
            if (title.endsWith(":")) {
                title = title.substring(0, title.length() - 1);
            }
            IJ.register(FolderOpener.class);
            list = this.trimFileList(list);
            if (list == null) {
                return;
            }
            if (IJ.debugMode) {
                IJ.log("FolderOpener: " + directory + " (" + list.length + " files)");
            }
            int width = 0;
            int height = 0;
            int stackSize = 1;
            int bitDepth = 0;
            stack = null;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            cal = null;
            allSameCalibration = true;
            IJ.resetEscape();
            overlay = null;
            try {
                ImagePlus imp;
                for (int i = 0; i < list.length; ++i) {
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages(true);
                    imp = opener.openImage(directory, list[i]);
                    IJ.redirectErrorMessages(false);
                    if (imp == null) continue;
                    width = imp.getWidth();
                    height = imp.getHeight();
                    bitDepth = imp.getBitDepth();
                    this.fi = imp.getOriginalFileInfo();
                    if (arg == null) {
                        if (this.showDialog(imp, list)) break;
                        return;
                    }
                    this.n = list.length;
                    this.start = 1;
                    this.increment = 1;
                    break;
                }
                if (width == 0) {
                    IJ.error("Sequence Reader", "This folder does not appear to contain\nany TIFF, JPEG, BMP, DICOM, GIF, FITS or PGM files.\n \n   \"" + directory + "\"");
                    return;
                }
                if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                    this.filter = null;
                }
                if (this.filter != null) {
                    int filteredImages = 0;
                    for (int i = 0; i < list.length; ++i) {
                        if (this.isRegex && this.containsRegex(list[i], this.filter)) {
                            ++filteredImages;
                            continue;
                        }
                        if (list[i].contains(this.filter)) {
                            ++filteredImages;
                            continue;
                        }
                        list[i] = null;
                    }
                    if (filteredImages == 0) {
                        if (this.isRegex) {
                            IJ.error("Sequence Reader", "None of the file names contain the regular expression.");
                        } else {
                            IJ.error("Sequence Reader", "None of the " + list.length + " files contain\n the string '" + this.filter + "' in their name.");
                        }
                        return;
                    }
                    String[] list2 = new String[filteredImages];
                    int j = 0;
                    for (int i = 0; i < list.length; ++i) {
                        if (list[i] == null) continue;
                        list2[j++] = list[i];
                    }
                    list = list2;
                }
                if (this.sortFileNames) {
                    list = StringSorter.sortNumerically(list);
                }
                if (this.n < 1) {
                    this.n = list.length;
                }
                if (this.start < 1 || this.start > list.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > list.length) {
                    this.n = list.length - this.start + 1;
                }
                int count = 0;
                int counter = 0;
                imp = null;
                boolean firstMessage = true;
                for (int i = this.start - 1; i < list.length; ++i) {
                    String info;
                    if (counter++ % this.increment != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages(true);
                    if ("RoiSet.zip".equals(list[i])) {
                        IJ.open(directory + list[i]);
                        imp = null;
                    } else if (!this.openAsVirtualStack || stack == null) {
                        imp = opener.openImage(directory, list[i]);
                    }
                    IJ.redirectErrorMessages(false);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        bitDepth = imp.getBitDepth();
                        cal = imp.getCalibration();
                        if (this.convertToRGB) {
                            bitDepth = 24;
                        }
                        ColorModel cm = imp.getProcessor().getColorModel();
                        if (this.openAsVirtualStack) {
                            stack = new VirtualStack(width, height, cm, directory);
                            ((VirtualStack)stack).setBitDepth(bitDepth);
                        } else {
                            stack = this.scale < 100.0 ? new ImageStack((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0), cm) : new ImageStack(width, height, cm);
                        }
                        this.info1 = (String)imp.getProperty("Info");
                    }
                    if (imp == null) continue;
                    stackSize = imp.getStackSize();
                    if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.log(list[i] + ": wrong size; " + width + "x" + height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found");
                        continue;
                    }
                    String label = imp.getTitle();
                    if (stackSize == 1 && (info = (String)imp.getProperty("Info")) != null) {
                        label = label + "\n" + info;
                    }
                    if (imp.getCalibration().pixelWidth != cal.pixelWidth) {
                        allSameCalibration = false;
                    }
                    ImageStack inputStack = imp.getStack();
                    Overlay overlay2 = imp.getOverlay();
                    if (overlay2 != null && !this.openAsVirtualStack) {
                        if (overlay == null) {
                            overlay = new Overlay();
                        }
                        for (int j = 0; j < overlay2.size(); ++j) {
                            Roi roi = overlay2.get(j);
                            int position = roi.getPosition();
                            if (position == 0) {
                                roi.setPosition(count + 1);
                            }
                            overlay.add(roi);
                        }
                    }
                    for (int slice = 1; slice <= stackSize; ++slice) {
                        ImageProcessor ip = inputStack.getProcessor(slice);
                        String label2 = label;
                        if (stackSize > 1) {
                            String sliceLabel = inputStack.getSliceLabel(slice);
                            if (sliceLabel != null) {
                                label2 = sliceLabel;
                            } else if (label2 != null && !label2.equals("")) {
                                label2 = label2 + ":" + slice;
                            }
                        }
                        int bitDepth2 = imp.getBitDepth();
                        if (!this.openAsVirtualStack) {
                            if (this.convertToRGB) {
                                ip = ip.convertToRGB();
                                bitDepth2 = 24;
                            }
                            if (bitDepth2 != bitDepth) {
                                if (bitDepth == 8 && bitDepth2 == 24) {
                                    ip = ip.convertToByte(true);
                                    bitDepth2 = 8;
                                } else if (bitDepth == 32) {
                                    ip = ip.convertToFloat();
                                    bitDepth2 = 32;
                                } else if (bitDepth == 24) {
                                    ip = ip.convertToRGB();
                                    bitDepth2 = 24;
                                }
                            }
                            if (bitDepth2 != bitDepth) {
                                IJ.log(list[i] + ": wrong bit depth; " + bitDepth + " expected, " + bitDepth2 + " found");
                                break;
                            }
                        }
                        if (slice == 1) {
                            ++count;
                        }
                        IJ.showStatus(count + "/" + this.n);
                        IJ.showProgress(count, this.n);
                        if (this.scale < 100.0) {
                            ip = ip.resize((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0));
                        }
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        if (this.openAsVirtualStack) {
                            if (slice == 1) {
                                ((VirtualStack)stack).addSlice(list[i]);
                                continue;
                            }
                            if (slice != 2 || !firstMessage) continue;
                            IJ.log(list[i] + " [" + stackSize + "]: only the first slice will be used in virtual stack");
                            firstMessage = false;
                            continue;
                        }
                        stack.addSlice(label2, ip);
                    }
                    if (count < this.n) {
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory("FolderOpener");
                if (stack == null) break block86;
                stack.trim();
            }
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus(title, stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            if (this.fi == null) {
                this.fi = new FileInfo();
            }
            this.fi.fileFormat = 0;
            this.fi.fileName = "";
            this.fi.directory = directory;
            imp2.setFileInfo(this.fi);
            imp2.setOverlay(overlay);
            if (allSameCalibration) {
                if (this.scale != 100.0 && cal.scaled()) {
                    cal.pixelWidth /= this.scale / 100.0;
                    cal.pixelHeight /= this.scale / 100.0;
                }
                if (cal.pixelWidth != 1.0 && cal.pixelDepth == 1.0) {
                    cal.pixelDepth = cal.pixelWidth;
                }
                if (cal.pixelWidth <= 1.0E-4 && cal.getUnit().equals("cm")) {
                    cal.pixelWidth *= 10000.0;
                    cal.pixelHeight *= 10000.0;
                    cal.pixelDepth *= 10000.0;
                    cal.setUnit("um");
                }
                imp2.setCalibration(cal);
            }
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                stack = DicomTools.sort(stack);
                imp2.setStack(stack);
                double voxelDepth = DicomTools.getVoxelDepth(stack);
                if (voxelDepth > 0.0) {
                    if (IJ.debugMode) {
                        IJ.log("DICOM voxel depth set to " + voxelDepth + " (" + cal.pixelDepth + ")");
                    }
                    cal.pixelDepth = voxelDepth;
                    imp2.setCalibration(cal);
                }
            }
            if (imp2.getStackSize() == 1) {
                imp2.setProperty("Label", list[0]);
                if (this.info1 != null) {
                    imp2.setProperty("Info", this.info1);
                }
            }
            if (arg == null && !this.saveImage) {
                imp2.show();
                if (stack.isVirtual() && (overlay = stack.getProcessor(1).getOverlay()) != null) {
                    imp2.setOverlay(overlay);
                }
            }
            if (this.saveImage) {
                this.image = imp2;
            }
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        FolderOpenerDialog gd = new FolderOpenerDialog("Sequence Options", imp, list);
        gd.addNumericField("Number of images:", fileCount, 0);
        gd.addNumericField("Starting image:", 1.0, 0);
        gd.addNumericField("Increment:", 1.0, 0);
        gd.addNumericField("Scale images:", this.scale, 0, 4, "%");
        gd.addStringField("File name contains:", "", 10);
        gd.setInsets(0, 45, 0);
        gd.addMessage("(enclose regex in parens)", null, Color.darkGray);
        gd.addCheckbox("Convert_to_RGB", this.convertToRGB);
        gd.addCheckbox("Sort names numerically", this.sortFileNames);
        gd.addCheckbox("Use virtual stack", this.openAsVirtualStack);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#seq1");
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.scale = gd.getNextNumber();
        if (this.scale < 5.0) {
            this.scale = 5.0;
        }
        if (this.scale > 100.0) {
            this.scale = 100.0;
        }
        this.filter = gd.getNextString();
        this.filter = this.checkForRegex(this.filter);
        if (this.legacyRegex != null) {
            this.filter = this.legacyRegex;
            this.isRegex = true;
        }
        this.convertToRGB = gd.getNextBoolean();
        this.sortFileNames = gd.getNextBoolean();
        this.openAsVirtualStack = gd.getNextBoolean();
        if (this.openAsVirtualStack) {
            this.scale = 100.0;
        }
        if (!IJ.macroRunning()) {
            staticSortFileNames = this.sortFileNames;
            staticOpenAsVirtualStack = this.openAsVirtualStack;
        }
        return true;
    }

    private String checkForRegex(String filter) {
        if (filter.length() >= 2 && filter.startsWith("(") && filter.endsWith(")")) {
            filter = filter.substring(1, filter.length() - 1);
            this.isRegex = true;
        } else {
            this.isRegex = false;
        }
        IJ.showStatus("");
        return filter;
    }

    private boolean containsRegex(String name, String regex) {
        boolean contains = false;
        try {
            contains = this.legacyRegex != null ? name.matches(this.filter) : name.replaceAll(regex, "").length() != name.length();
            IJ.showStatus("");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            int index = msg.indexOf("\n");
            if (index > 0) {
                msg = msg.substring(0, index);
            }
            IJ.showStatus("Regex error: " + msg);
            contains = true;
        }
        return contains;
    }

    public String[] trimFileList(String[] rawlist) {
        int count = 0;
        for (int i = 0; i < rawlist.length; ++i) {
            String name = rawlist[i];
            if (name.startsWith(".") || name.equals("Thumbs.db") || FolderOpener.excludedFileType(name)) {
                rawlist[i] = null;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] list = rawlist;
        if (count < rawlist.length) {
            list = new String[count];
            int index = 0;
            for (int i = 0; i < rawlist.length; ++i) {
                if (rawlist[i] == null) continue;
                list[index++] = rawlist[i];
            }
        }
        return list;
    }

    public static boolean excludedFileType(String name) {
        if (name == null) {
            return true;
        }
        for (int i = 0; i < excludedTypes.length; ++i) {
            if (!name.endsWith(excludedTypes[i])) continue;
            return true;
        }
        return false;
    }

    public void openAsVirtualStack(boolean b) {
        this.openAsVirtualStack = b;
    }

    public void sortFileNames(boolean b) {
        this.sortFileNames = b;
    }

    public String[] sortFileList(String[] list) {
        return StringSorter.sortNumerically(list);
    }

    class FolderOpenerDialog
    extends GenericDialog {
        ImagePlus imp;
        int fileCount;
        boolean eightBits;
        boolean rgb;
        String[] list;

        public FolderOpenerDialog(String title, ImagePlus imp, String[] list) {
            super(title);
            this.imp = imp;
            this.list = list;
            this.fileCount = list.length;
        }

        protected void setup() {
            this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
            this.rgb = ((Checkbox)this.checkbox.elementAt(1)).getState();
            this.setStackInfo();
        }

        public void itemStateChanged(ItemEvent e) {
        }

        public void textValueChanged(TextEvent e) {
            this.setStackInfo();
        }

        void setStackInfo() {
            int n2;
            int width = this.imp.getWidth();
            int height = this.imp.getHeight();
            int depth = this.imp.getStackSize();
            int bytesPerPixel = 1;
            int n = this.getNumber(this.numberField.elementAt(0));
            int start = this.getNumber(this.numberField.elementAt(1));
            int inc = this.getNumber(this.numberField.elementAt(2));
            double scale = this.getNumber(this.numberField.elementAt(3));
            if (scale < 5.0) {
                scale = 5.0;
            }
            if (scale > 100.0) {
                scale = 100.0;
            }
            if (n < 1) {
                n = this.fileCount;
            }
            if (start < 1 || start > this.fileCount) {
                start = 1;
            }
            if (start + n - 1 > this.fileCount) {
                n = this.fileCount - start + 1;
            }
            if (inc < 1) {
                inc = 1;
            }
            TextField tf = (TextField)this.stringField.elementAt(0);
            String filter = tf.getText();
            if (!(filter = FolderOpener.this.checkForRegex(filter)).equals("") && !filter.equals("*")) {
                n2 = 0;
                for (int i = 0; i < this.list.length; ++i) {
                    if (FolderOpener.this.isRegex && FolderOpener.this.containsRegex(this.list[i], filter)) {
                        ++n2;
                        continue;
                    }
                    if (this.list[i].indexOf(filter) < 0) continue;
                    ++n2;
                }
                if (n2 < n) {
                    n = n2;
                }
            }
            switch (this.imp.getType()) {
                case 1: {
                    bytesPerPixel = 2;
                    break;
                }
                case 2: 
                case 4: {
                    bytesPerPixel = 4;
                }
            }
            if (this.eightBits) {
                bytesPerPixel = 1;
            }
            if (this.rgb) {
                bytesPerPixel = 4;
            }
            width = (int)((double)width * scale / 100.0);
            height = (int)((double)height * scale / 100.0);
            n2 = (this.fileCount - start + 1) * depth / inc;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n) {
                n2 = n;
            }
            double size = (double)width * (double)height * (double)n2 * (double)bytesPerPixel / 1048576.0;
            ((Label)this.theLabel).setText(width + " x " + height + " x " + n2 + " (" + IJ.d2s(size, 1) + "MB)");
        }

        public int getNumber(Object field) {
            Double d;
            TextField tf = (TextField)field;
            String theText = tf.getText();
            try {
                d = new Double(theText);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return (int)d.doubleValue();
            }
            return 0;
        }
    }
}

