/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumFormat {
    public static double parseNumber(String line, double def) {
        double[] numbers = NumFormat.parseNumbers(line);
        if (numbers.length >= 1) {
            return numbers[0];
        }
        return def;
    }

    public static double[] parseNumbersAfter(String keyword, String line) {
        String[] parts = line.trim().toLowerCase().split(keyword.toLowerCase());
        if (parts.length == 2) {
            return NumFormat.parseNumbers(parts[1]);
        }
        return new double[0];
    }

    public static double[] parseNumbers(String line) {
        ArrayList<String> num = new ArrayList<String>();
        Pattern p = Pattern.compile("[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?");
        Matcher m = p.matcher(line);
        while (m.find()) {
            num.add(m.group());
        }
        double[] number = new double[num.size()];
        int i = 0;
        while (i < num.size()) {
            number[i] = Double.parseDouble((String)num.get(i));
            ++i;
        }
        return number;
    }

    public static String sci(double a) {
        String n;
        double b = Math.abs(a);
        String string = n = a < 0.0 ? "-" : "";
        if (a == 0.0) {
            return "0.0";
        }
        if (b > 3000.0) {
            return String.format(String.valueOf(n) + "%6.3E", b);
        }
        if (b > 300.0) {
            return String.format(String.valueOf(n) + "%4.1f", b);
        }
        if (b > 30.0) {
            return String.format(String.valueOf(n) + "%3.2f", b);
        }
        if (b > 3.0) {
            return String.format(String.valueOf(n) + "%2.4f", b);
        }
        if (b > 0.003) {
            return String.format(String.valueOf(n) + "%1.4f", b);
        }
        return String.format(String.valueOf(n) + "%6.3E", b).trim();
    }

    public static String unit(int n, String unit) {
        double dn = n;
        if (dn < 1.0E-9) {
            return String.valueOf(new DecimalFormat("0.00 p").format(dn * 1.0E9)) + unit;
        }
        if (dn < 1.0E-6) {
            return String.valueOf(new DecimalFormat("0.00 n").format(dn * 1000000.0)) + unit;
        }
        if (dn < 0.001) {
            return String.valueOf(new DecimalFormat("0.00 m").format(dn * 1000.0)) + unit;
        }
        if (dn < 1.0) {
            return String.valueOf(new DecimalFormat("0.00 ").format(dn)) + unit;
        }
        if (dn < 1000.0) {
            return String.valueOf(new DecimalFormat("0.00 K").format(dn * 0.001)) + unit;
        }
        if (dn < 1000000.0) {
            return String.valueOf(new DecimalFormat("0.00 M").format(dn * 1.0E-6)) + unit;
        }
        if (dn < 1.0E9) {
            return String.valueOf(new DecimalFormat("0.00 G").format(dn * 1.0E-9)) + unit;
        }
        return String.valueOf(new DecimalFormat("0.00 T").format(dn * 1.0E-12)) + unit;
    }

    public static String seconds(double ns) {
        return String.format("%5.1f s", ns * 1.0E-9);
    }

    public static String time(double ns) {
        if (ns < 3000.0) {
            return String.format("%3.2f ns", ns);
        }
        if ((ns *= 0.001) < 3000.0) {
            return String.format("%3.2f us", ns);
        }
        if ((ns *= 0.001) < 3000.0) {
            return String.format("%3.2f ms", ns);
        }
        if ((ns *= 0.001) < 10800.0) {
            return String.format("%3.2f s", ns);
        }
        return String.format("%3.2f h", ns /= 3600.0);
    }

    public static String bytes(double bytes) {
        if (bytes < 3000.0) {
            return String.format("%3.0f", bytes);
        }
        if ((bytes /= 1024.0) < 3000.0) {
            return String.format("%3.1f Kb", bytes);
        }
        if ((bytes /= 1024.0) < 3000.0) {
            return String.format("%3.1f Mb", bytes);
        }
        if ((bytes /= 1024.0) < 3000.0) {
            return String.format("%3.1f Gb", bytes);
        }
        return String.format("%3.1f Tb", bytes /= 1024.0);
    }

    public static String toPercent(String value) {
        try {
            return NumFormat.toPercent(Double.parseDouble(value));
        }
        catch (Exception exception) {
            return value;
        }
    }

    public static String toPercent(double value) {
        return String.valueOf(String.format("%5.3f", value * 100.0)) + "%";
    }
}

