/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.random;

import bilib.commons.components.GridPanel;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.random.Noise;
import bilib.commons.settings.Settings;
import javax.swing.JPanel;

public class NoisePoisson
extends Noise {
    private double mean = 0.0;
    private SpinnerRangeDouble spnMean = new SpinnerRangeDouble(1.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0, "0.000");

    public NoisePoisson(double mean) {
        this.mean = mean;
    }

    @Override
    public String getName() {
        return "Poisson";
    }

    @Override
    public void fetchParameters() {
        this.mean = this.spnMean.get();
    }

    @Override
    public double nextValue() {
        return this.poidev(this.mean);
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridPanel panel = new GridPanel(false);
        panel.place(1, 0, "Mean/Variance");
        panel.place(1, 1, this.spnMean);
        settings.record("random-" + this.getName() + "-mean", this.spnMean, "1");
        settings.loadRecordedItems();
        return panel;
    }

    private double poidev(double xm) {
        double em;
        double sq = 0.0;
        double alxm = 0.0;
        double g = 0.0;
        double oldm = -1.0;
        if (xm < 12.0) {
            if (xm != oldm) {
                oldm = xm;
                g = Math.exp(-xm);
            }
            em = -1.0;
            double t = 1.0;
            do {
                em += 1.0;
            } while ((t *= this.random.nextDouble()) > g);
        } else {
            if (xm != oldm) {
                oldm = xm;
                sq = Math.sqrt(2.0 * xm);
                alxm = Math.log(xm);
                g = xm * alxm - this.gammln(xm + 1.0);
            }
            while (true) {
                double y;
                if ((em = sq * (y = Math.tan(Math.PI * this.random.nextDouble())) + xm) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                double t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - this.gammln(em + 1.0) - g);
                if (!(this.random.nextDouble() > t)) break;
            }
        }
        return em;
    }

    double gammln(double xx) {
        double x;
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += cof[j] / (y += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }
}

