/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.buttons;

import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ButtonFactory {
    private static JButton icon(JButton bn) {
        ImageIcon icon;
        URL url = ButtonFactory.class.getResource(String.valueOf(bn.getText().toLowerCase()) + ".png");
        if (url != null && (icon = new ImageIcon(url, "")) != null) {
            JButton bni = new JButton(icon);
            Dimension d = new Dimension(icon.getIconWidth(), icon.getIconHeight() + 2);
            bni.setMaximumSize(d);
            bni.setPreferredSize(d);
            return bni;
        }
        return bn;
    }

    public static JButton about(boolean tryIcon) {
        JButton bn = new JButton("About");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("About ...");
        return bn;
    }

    public static JButton close(boolean tryIcon) {
        JButton bn = new JButton("Close");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Save the settings and close");
        return bn;
    }

    public static JButton prefs(boolean tryIcon) {
        JButton bn = new JButton("Prefs");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Manage the settings");
        return bn;
    }

    public static JButton help(boolean tryIcon) {
        JButton bn = new JButton("Help");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Get online help");
        return bn;
    }

    public static JButton run(boolean tryIcon) {
        JButton bn = new JButton("Run");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Start the processing");
        return bn;
    }

    public static JButton save(boolean tryIcon) {
        JButton bn = new JButton("Save");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Save");
        return bn;
    }

    public static JButton snapshot(boolean tryIcon) {
        JButton bn = new JButton("Snapshot");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Snapshot");
        return bn;
    }

    public static JButton stop(boolean tryIcon) {
        JButton bn = new JButton("Stop");
        if (tryIcon) {
            bn = ButtonFactory.icon(bn);
        }
        bn.setToolTipText("Abort the processing");
        return bn;
    }
}

