# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class PnlAccountType(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"total": "float", "title": "str", "accounts": "list[PnlAccount]"}

    attribute_map = {"total": "total", "title": "title", "accounts": "accounts"}

    def __init__(self, total=None, title=None, accounts=None):  # noqa: E501
        """PnlAccountType - a model defined in OpenAPI"""  # noqa: E501

        self._total = None
        self._title = None
        self._accounts = None
        self.discriminator = None

        if total is not None:
            self.total = total
        if title is not None:
            self.title = title
        if accounts is not None:
            self.accounts = accounts

    @property
    def total(self):
        """Gets the total of this PnlAccountType.  # noqa: E501

        Total movement on this account type  # noqa: E501

        :return: The total of this PnlAccountType.  # noqa: E501
        :rtype: float
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this PnlAccountType.

        Total movement on this account type  # noqa: E501

        :param total: The total of this PnlAccountType.  # noqa: E501
        :type: float
        """

        self._total = total

    @property
    def title(self):
        """Gets the title of this PnlAccountType.  # noqa: E501

        Name of this account type, it will be either Trading Income or Other Income for Revenue section / Direct Cost or Operating Expenses for Expense section  # noqa: E501

        :return: The title of this PnlAccountType.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this PnlAccountType.

        Name of this account type, it will be either Trading Income or Other Income for Revenue section / Direct Cost or Operating Expenses for Expense section  # noqa: E501

        :param title: The title of this PnlAccountType.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def accounts(self):
        """Gets the accounts of this PnlAccountType.  # noqa: E501

        A list of the movement on each account detail during the query period. Refer to the account detail element below  # noqa: E501

        :return: The accounts of this PnlAccountType.  # noqa: E501
        :rtype: list[PnlAccount]
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """Sets the accounts of this PnlAccountType.

        A list of the movement on each account detail during the query period. Refer to the account detail element below  # noqa: E501

        :param accounts: The accounts of this PnlAccountType.  # noqa: E501
        :type: list[PnlAccount]
        """

        self._accounts = accounts
