# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class PnlAccountClass(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"total": "float", "account_types": "list[PnlAccountType]"}

    attribute_map = {"total": "total", "account_types": "accountTypes"}

    def __init__(self, total=None, account_types=None):  # noqa: E501
        """PnlAccountClass - a model defined in OpenAPI"""  # noqa: E501

        self._total = None
        self._account_types = None
        self.discriminator = None

        if total is not None:
            self.total = total
        if account_types is not None:
            self.account_types = account_types

    @property
    def total(self):
        """Gets the total of this PnlAccountClass.  # noqa: E501

        Total revenue/expense value  # noqa: E501

        :return: The total of this PnlAccountClass.  # noqa: E501
        :rtype: float
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this PnlAccountClass.

        Total revenue/expense value  # noqa: E501

        :param total: The total of this PnlAccountClass.  # noqa: E501
        :type: float
        """

        self._total = total

    @property
    def account_types(self):
        """Gets the account_types of this PnlAccountClass.  # noqa: E501

        Contains trading income and other income for revenue section / operating expenses and direct cost for expense section if the data is available for each section. Refer to the account type element below  # noqa: E501

        :return: The account_types of this PnlAccountClass.  # noqa: E501
        :rtype: list[PnlAccountType]
        """
        return self._account_types

    @account_types.setter
    def account_types(self, account_types):
        """Sets the account_types of this PnlAccountClass.

        Contains trading income and other income for revenue section / operating expenses and direct cost for expense section if the data is available for each section. Refer to the account type element below  # noqa: E501

        :param account_types: The account_types of this PnlAccountClass.  # noqa: E501
        :type: list[PnlAccountType]
        """

        self._account_types = account_types
