# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class LineItemResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "account_id": "str",
        "reporting_code": "str",
        "line_amount": "float",
        "account_type": "str",
    }

    attribute_map = {
        "account_id": "accountId",
        "reporting_code": "reportingCode",
        "line_amount": "lineAmount",
        "account_type": "accountType",
    }

    def __init__(
        self, account_id=None, reporting_code=None, line_amount=None, account_type=None
    ):  # noqa: E501
        """LineItemResponse - a model defined in OpenAPI"""  # noqa: E501

        self._account_id = None
        self._reporting_code = None
        self._line_amount = None
        self._account_type = None
        self.discriminator = None

        if account_id is not None:
            self.account_id = account_id
        if reporting_code is not None:
            self.reporting_code = reporting_code
        if line_amount is not None:
            self.line_amount = line_amount
        if account_type is not None:
            self.account_type = account_type

    @property
    def account_id(self):
        """Gets the account_id of this LineItemResponse.  # noqa: E501

        Xero Identifier of account  # noqa: E501

        :return: The account_id of this LineItemResponse.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this LineItemResponse.

        Xero Identifier of account  # noqa: E501

        :param account_id: The account_id of this LineItemResponse.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def reporting_code(self):
        """Gets the reporting_code of this LineItemResponse.  # noqa: E501

        Shown if set  # noqa: E501

        :return: The reporting_code of this LineItemResponse.  # noqa: E501
        :rtype: str
        """
        return self._reporting_code

    @reporting_code.setter
    def reporting_code(self, reporting_code):
        """Sets the reporting_code of this LineItemResponse.

        Shown if set  # noqa: E501

        :param reporting_code: The reporting_code of this LineItemResponse.  # noqa: E501
        :type: str
        """

        self._reporting_code = reporting_code

    @property
    def line_amount(self):
        """Gets the line_amount of this LineItemResponse.  # noqa: E501

        Amount of line item  # noqa: E501

        :return: The line_amount of this LineItemResponse.  # noqa: E501
        :rtype: float
        """
        return self._line_amount

    @line_amount.setter
    def line_amount(self, line_amount):
        """Sets the line_amount of this LineItemResponse.

        Amount of line item  # noqa: E501

        :param line_amount: The line_amount of this LineItemResponse.  # noqa: E501
        :type: float
        """

        self._line_amount = line_amount

    @property
    def account_type(self):
        """Gets the account_type of this LineItemResponse.  # noqa: E501

        Account type  # noqa: E501

        :return: The account_type of this LineItemResponse.  # noqa: E501
        :rtype: str
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """Sets the account_type of this LineItemResponse.

        Account type  # noqa: E501

        :param account_type: The account_type of this LineItemResponse.  # noqa: E501
        :type: str
        """

        self._account_type = account_type
