# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class BankStatementAccountingResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "bank_account_id": "str",
        "bank_account_name": "str",
        "bank_account_currency_code": "str",
        "statements": "list[StatementResponse]",
    }

    attribute_map = {
        "bank_account_id": "bankAccountId",
        "bank_account_name": "bankAccountName",
        "bank_account_currency_code": "bankAccountCurrencyCode",
        "statements": "statements",
    }

    def __init__(
        self,
        bank_account_id=None,
        bank_account_name=None,
        bank_account_currency_code=None,
        statements=None,
    ):  # noqa: E501
        """BankStatementAccountingResponse - a model defined in OpenAPI"""  # noqa: E501

        self._bank_account_id = None
        self._bank_account_name = None
        self._bank_account_currency_code = None
        self._statements = None
        self.discriminator = None

        if bank_account_id is not None:
            self.bank_account_id = bank_account_id
        if bank_account_name is not None:
            self.bank_account_name = bank_account_name
        if bank_account_currency_code is not None:
            self.bank_account_currency_code = bank_account_currency_code
        if statements is not None:
            self.statements = statements

    @property
    def bank_account_id(self):
        """Gets the bank_account_id of this BankStatementAccountingResponse.  # noqa: E501

        Xero Identifier of bank account  # noqa: E501

        :return: The bank_account_id of this BankStatementAccountingResponse.  # noqa: E501
        :rtype: str
        """
        return self._bank_account_id

    @bank_account_id.setter
    def bank_account_id(self, bank_account_id):
        """Sets the bank_account_id of this BankStatementAccountingResponse.

        Xero Identifier of bank account  # noqa: E501

        :param bank_account_id: The bank_account_id of this BankStatementAccountingResponse.  # noqa: E501
        :type: str
        """

        self._bank_account_id = bank_account_id

    @property
    def bank_account_name(self):
        """Gets the bank_account_name of this BankStatementAccountingResponse.  # noqa: E501

        Name of bank account  # noqa: E501

        :return: The bank_account_name of this BankStatementAccountingResponse.  # noqa: E501
        :rtype: str
        """
        return self._bank_account_name

    @bank_account_name.setter
    def bank_account_name(self, bank_account_name):
        """Sets the bank_account_name of this BankStatementAccountingResponse.

        Name of bank account  # noqa: E501

        :param bank_account_name: The bank_account_name of this BankStatementAccountingResponse.  # noqa: E501
        :type: str
        """

        self._bank_account_name = bank_account_name

    @property
    def bank_account_currency_code(self):
        """Gets the bank_account_currency_code of this BankStatementAccountingResponse.  # noqa: E501

        Currency code of the bank account  # noqa: E501

        :return: The bank_account_currency_code of this BankStatementAccountingResponse.  # noqa: E501
        :rtype: str
        """
        return self._bank_account_currency_code

    @bank_account_currency_code.setter
    def bank_account_currency_code(self, bank_account_currency_code):
        """Sets the bank_account_currency_code of this BankStatementAccountingResponse.

        Currency code of the bank account  # noqa: E501

        :param bank_account_currency_code: The bank_account_currency_code of this BankStatementAccountingResponse.  # noqa: E501
        :type: str
        """

        self._bank_account_currency_code = bank_account_currency_code

    @property
    def statements(self):
        """Gets the statements of this BankStatementAccountingResponse.  # noqa: E501

        List of bank statements and linked accounting data for the requested period  # noqa: E501

        :return: The statements of this BankStatementAccountingResponse.  # noqa: E501
        :rtype: list[StatementResponse]
        """
        return self._statements

    @statements.setter
    def statements(self, statements):
        """Sets the statements of this BankStatementAccountingResponse.

        List of bank statements and linked accounting data for the requested period  # noqa: E501

        :param statements: The statements of this BankStatementAccountingResponse.  # noqa: E501
        :type: list[StatementResponse]
        """

        self._statements = statements
