# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_azure_auth']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3,<4',
 'cryptography>=35.0.0,<36.0.0',
 'fastapi>0.68.0',
 'python-jose[cryptography]>=3.3.0,<4.0.0']

setup_kwargs = {
    'name': 'fastapi-azure-auth',
    'version': '3.0.3',
    'description': 'Easy and secure implementation of Azure AD for your FastAPI APIs',
    'long_description': '<h1 align="center">\n  <img margin="0 10px 0 0" src="https://avatars.githubusercontent.com/u/35199565" width="124px"/>\n  <img margin="0 10px 0 0" src="https://raw.githubusercontent.com/Intility/fastapi-azure-auth/main/docs/static/img/global/fastad.png" width="124px"/><br/>\n  FastAPI-Azure-Auth\n</h1>\n\n<p align="center">\n    <em>Azure AD Authentication for FastAPI apps made easy.</em>\n</p>\n<p align="center">\n    <!-- Line 1 -->\n    <a href="https://python.org">\n        <img src="https://img.shields.io/badge/python-v3.9+-blue.svg?logo=python&logoColor=white&label=python" alt="Python version">\n    </a>\n    <a href="https://fastapi.tiangolo.com/">\n        <img src="https://img.shields.io/badge/FastAPI-0.68.0+%20-blue.svg?logo=fastapi&logoColor=white&label=fastapi" alt="FastAPI Version">\n    </a>\n    <a href="https://pypi.org/pypi/fastapi-azure-auth">\n        <img src="https://img.shields.io/pypi/v/fastapi-azure-auth.svg?logo=pypi&logoColor=white&label=pypi" alt="Package version">\n    </a>\n    <!-- Line 2 -->\n    <br/>\n    <a href="https://codecov.io/gh/intility/fastapi-azure-auth">\n        <img src="https://codecov.io/gh/intility/fastapi-azure-auth/branch/main/graph/badge.svg?token=BTFGII4GYR" alt="Codecov">\n    </a>\n    <a href="https://github.com/pre-commit/pre-commit">\n        <img src="https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white" alt="Pre-commit">\n    </a>\n    <a href="https://github.com/psf/black">\n        <img src="https://img.shields.io/badge/code%20style-black-000000.svg" alt="Black">\n    </a>\n    <a href="http://mypy-lang.org">\n        <img src="http://www.mypy-lang.org/static/mypy_badge.svg" alt="mypy">\n    </a>\n    <a href="https://pycqa.github.io/isort/">\n        <img src="https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336" alt="isort">\n    </a>\n    <!-- Line 3 -->\n    <br/>\n    <a href="https://docs.microsoft.com/en-us/azure/active-directory/develop/single-and-multi-tenant-apps">\n        <img src="https://img.shields.io/badge/Single--tenant-Supported-blue?logo=Microsoft%20Azure&logoColor=white">\n    </a>\n    <a href="https://docs.microsoft.com/en-us/azure/active-directory/develop/single-and-multi-tenant-apps">\n        <img src="https://img.shields.io/badge/Multi--tenant-Supported-blue?logo=Microsoft%20Azure&logoColor=white">\n    </a>\n</p>\n\n\n## 🚀 Description\n\n> FastAPI is a modern, fast (high-performance), web framework for building APIs with Python, based on standard Python type hints.  \n\nAt Intility we use FastAPI for both internal (single-tenant) and customer-facing (multi-tenant) APIs. This package enables our developers (and you 😊) to create features without worrying about authentication and authorization.\n\nAlso, [we\'re hiring!](https://intility.no/en/career/)\n\n## 📚 Resources\n\nThe [documentation](https://intility.github.io/fastapi-azure-auth/) contains a full tutorial on how to configure Azure AD \nand FastAPI for both single- and multi-tenant applications. It includes examples on how to lock down\nyour APIs to certain scopes, tenants, roles etc. For first time users it\'s strongly advised to set up your \napplication exactly how it\'s described there, and then alter it to your needs later. \n\n[**MIT License**](https://github.com/Intility/fastapi-azure-auth/blob/main/LICENSE)\n| [**Documentation**](https://intility.github.io/fastapi-azure-auth/)\n| [**GitHub**](https://github.com/snok/django-guid)\n\n\n## ⚡ Setup\n\nThis is a tl;dr intended to give you an idea of what this package does and how to use it. \nFor a more in-depth tutorial and settings reference you should read the \n[documentation](https://intility.github.io/fastapi-azure-auth/).\n\n\n#### 1. Install this library:\n```bash\npip install fastapi-azure-auth\n# or\npoetry add fastapi-azure-auth\n```\n\n#### 2. Configure your FastAPI app\nInclude `swagger_ui_oauth2_redirect_url` and `swagger_ui_init_oauth` in your FastAPI app initialization:\n\n```python\n# file: main.py\napp = FastAPI(\n    ...\n    swagger_ui_oauth2_redirect_url=\'/oauth2-redirect\',\n    swagger_ui_init_oauth={\n        \'usePkceWithAuthorizationCodeGrant\': True,\n        \'clientId\': settings.OPENAPI_CLIENT_ID,\n    },\n)\n```\n\n#### 3. Setup CORS\nEnsure you have CORS enabled for your local environment, such as `http://localhost:8000`. \n\n#### 4. Configure FastAPI-Azure-Auth\nConfigure either your [`SingleTenantAzureAuthorizationCodeBearer`](https://intility.github.io/fastapi-azure-auth/settings/single_tenant)\nor [`MultiTenantAzureAuthorizationCodeBearer`](https://intility.github.io/fastapi-azure-auth/settings/multi_tenant).\n\n\n```python\n# file: demoproj/api/dependencies.py\nfrom fastapi_azure_auth.auth import SingleTenantAzureAuthorizationCodeBearer\n\nazure_scheme = SingleTenantAzureAuthorizationCodeBearer(\n    app_client_id=settings.APP_CLIENT_ID,\n    tenant_id=settings.TENANT_ID,\n    scopes={\n        f\'api://{settings.APP_CLIENT_ID}/user_impersonation\': \'user_impersonation\',\n    }\n)\n```\nor for multi-tenant applications:\n```python\n# file: demoproj/api/dependencies.py\nfrom fastapi_azure_auth.auth import MultiTenantAzureAuthorizationCodeBearer\n\nazure_scheme = MultiTenantAzureAuthorizationCodeBearer(\n    app_client_id=settings.APP_CLIENT_ID,\n    scopes={\n        f\'api://{settings.APP_CLIENT_ID}/user_impersonation\': \'user_impersonation\',\n    },    \n    validate_iss=False\n)\n```\nTo validate the `iss`, configure an \n[`iss_callable`](https://intility.github.io/fastapi-azure-auth/multi-tenant/accept_specific_tenants_only). \n\n#### 5. Configure dependencies\n\nAdd `azure_scheme` as a dependency for your views/routers, using either `Security()` or `Depends()`.\n```python\n# file: main.py\nfrom demoproj.api.dependencies import azure_scheme\n\napp.include_router(api_router, prefix=settings.API_V1_STR, dependencies=[Security(azure_scheme, scopes=\'user_impersonation\')])\n```\n\n#### 6. Load config on startup\n\nOptional but recommended. \n\n```python\n# file: main.py\n@app.on_event(\'startup\')\nasync def load_config() -> None:\n    """\n    Load OpenID config on startup.\n    """\n    await azure_scheme.openid_config.load_config()\n```\n\n\n## 📄 Example OpenAPI documentation\nYour OpenAPI documentation will get an `Authorize` button, which can be used to authenticate.\n![authorize](docs/static/img/single-and-multi-tenant/fastapi_1_authorize_button.png)\n\nThe user can select which scopes to authenticate with, based on your configuration.\n![scopes](docs/static/img/single-and-multi-tenant/fastapi_3_authenticate.png)\n',
    'author': 'Jonas Krüger Svensson',
    'author_email': 'jonas.svensson@intility.no',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/intility/fastapi-azure-auth',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
