# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduledQueryResult',
    'AwaitableGetScheduledQueryResult',
    'get_scheduled_query',
    'get_scheduled_query_output',
]

@pulumi.output_type
class GetScheduledQueryResult:
    def __init__(__self__, arn=None, s_q_error_report_configuration=None, s_q_kms_key_id=None, s_q_name=None, s_q_notification_configuration=None, s_q_query_string=None, s_q_schedule_configuration=None, s_q_scheduled_query_execution_role_arn=None, s_q_target_configuration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if s_q_error_report_configuration and not isinstance(s_q_error_report_configuration, str):
            raise TypeError("Expected argument 's_q_error_report_configuration' to be a str")
        pulumi.set(__self__, "s_q_error_report_configuration", s_q_error_report_configuration)
        if s_q_kms_key_id and not isinstance(s_q_kms_key_id, str):
            raise TypeError("Expected argument 's_q_kms_key_id' to be a str")
        pulumi.set(__self__, "s_q_kms_key_id", s_q_kms_key_id)
        if s_q_name and not isinstance(s_q_name, str):
            raise TypeError("Expected argument 's_q_name' to be a str")
        pulumi.set(__self__, "s_q_name", s_q_name)
        if s_q_notification_configuration and not isinstance(s_q_notification_configuration, str):
            raise TypeError("Expected argument 's_q_notification_configuration' to be a str")
        pulumi.set(__self__, "s_q_notification_configuration", s_q_notification_configuration)
        if s_q_query_string and not isinstance(s_q_query_string, str):
            raise TypeError("Expected argument 's_q_query_string' to be a str")
        pulumi.set(__self__, "s_q_query_string", s_q_query_string)
        if s_q_schedule_configuration and not isinstance(s_q_schedule_configuration, str):
            raise TypeError("Expected argument 's_q_schedule_configuration' to be a str")
        pulumi.set(__self__, "s_q_schedule_configuration", s_q_schedule_configuration)
        if s_q_scheduled_query_execution_role_arn and not isinstance(s_q_scheduled_query_execution_role_arn, str):
            raise TypeError("Expected argument 's_q_scheduled_query_execution_role_arn' to be a str")
        pulumi.set(__self__, "s_q_scheduled_query_execution_role_arn", s_q_scheduled_query_execution_role_arn)
        if s_q_target_configuration and not isinstance(s_q_target_configuration, str):
            raise TypeError("Expected argument 's_q_target_configuration' to be a str")
        pulumi.set(__self__, "s_q_target_configuration", s_q_target_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="sQErrorReportConfiguration")
    def s_q_error_report_configuration(self) -> Optional[str]:
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        """
        return pulumi.get(self, "s_q_error_report_configuration")

    @property
    @pulumi.getter(name="sQKmsKeyId")
    def s_q_kms_key_id(self) -> Optional[str]:
        """
        The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with alias/. If ErrorReportConfiguration uses SSE_KMS as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "s_q_kms_key_id")

    @property
    @pulumi.getter(name="sQName")
    def s_q_name(self) -> Optional[str]:
        """
        The name of the scheduled query. Scheduled query names must be unique within each Region.
        """
        return pulumi.get(self, "s_q_name")

    @property
    @pulumi.getter(name="sQNotificationConfiguration")
    def s_q_notification_configuration(self) -> Optional[str]:
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        """
        return pulumi.get(self, "s_q_notification_configuration")

    @property
    @pulumi.getter(name="sQQueryString")
    def s_q_query_string(self) -> Optional[str]:
        """
        The query string to run. Parameter names can be specified in the query string @ character followed by an identifier. The named Parameter @scheduled_runtime is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of @scheduled_runtime paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the @scheduled_runtime parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "s_q_query_string")

    @property
    @pulumi.getter(name="sQScheduleConfiguration")
    def s_q_schedule_configuration(self) -> Optional[str]:
        """
        Configuration for when the scheduled query is executed.
        """
        return pulumi.get(self, "s_q_schedule_configuration")

    @property
    @pulumi.getter(name="sQScheduledQueryExecutionRoleArn")
    def s_q_scheduled_query_execution_role_arn(self) -> Optional[str]:
        """
        The ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "s_q_scheduled_query_execution_role_arn")

    @property
    @pulumi.getter(name="sQTargetConfiguration")
    def s_q_target_configuration(self) -> Optional[str]:
        """
        Configuration of target store where scheduled query results are written to.
        """
        return pulumi.get(self, "s_q_target_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ScheduledQueryTag']]:
        return pulumi.get(self, "tags")


class AwaitableGetScheduledQueryResult(GetScheduledQueryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledQueryResult(
            arn=self.arn,
            s_q_error_report_configuration=self.s_q_error_report_configuration,
            s_q_kms_key_id=self.s_q_kms_key_id,
            s_q_name=self.s_q_name,
            s_q_notification_configuration=self.s_q_notification_configuration,
            s_q_query_string=self.s_q_query_string,
            s_q_schedule_configuration=self.s_q_schedule_configuration,
            s_q_scheduled_query_execution_role_arn=self.s_q_scheduled_query_execution_role_arn,
            s_q_target_configuration=self.s_q_target_configuration,
            tags=self.tags)


def get_scheduled_query(arn: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledQueryResult:
    """
    The AWS::Timestream::ScheduledQuery resource creates a Timestream Scheduled Query.
    """
    __args__ = dict()
    __args__['arn'] = arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:timestream:getScheduledQuery', __args__, opts=opts, typ=GetScheduledQueryResult).value

    return AwaitableGetScheduledQueryResult(
        arn=__ret__.arn,
        s_q_error_report_configuration=__ret__.s_q_error_report_configuration,
        s_q_kms_key_id=__ret__.s_q_kms_key_id,
        s_q_name=__ret__.s_q_name,
        s_q_notification_configuration=__ret__.s_q_notification_configuration,
        s_q_query_string=__ret__.s_q_query_string,
        s_q_schedule_configuration=__ret__.s_q_schedule_configuration,
        s_q_scheduled_query_execution_role_arn=__ret__.s_q_scheduled_query_execution_role_arn,
        s_q_target_configuration=__ret__.s_q_target_configuration,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_scheduled_query)
def get_scheduled_query_output(arn: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScheduledQueryResult]:
    """
    The AWS::Timestream::ScheduledQuery resource creates a Timestream Scheduled Query.
    """
    ...
