# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    def __init__(__self__, agent_version=None, ami_id=None, architecture=None, elastic_ips=None, hostname=None, id=None, install_updates_on_boot=None, instance_type=None, layer_ids=None, os=None, private_dns_name=None, private_ip=None, public_dns_name=None, public_ip=None, ssh_key_name=None, volumes=None):
        if agent_version and not isinstance(agent_version, str):
            raise TypeError("Expected argument 'agent_version' to be a str")
        pulumi.set(__self__, "agent_version", agent_version)
        if ami_id and not isinstance(ami_id, str):
            raise TypeError("Expected argument 'ami_id' to be a str")
        pulumi.set(__self__, "ami_id", ami_id)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if elastic_ips and not isinstance(elastic_ips, list):
            raise TypeError("Expected argument 'elastic_ips' to be a list")
        pulumi.set(__self__, "elastic_ips", elastic_ips)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if install_updates_on_boot and not isinstance(install_updates_on_boot, bool):
            raise TypeError("Expected argument 'install_updates_on_boot' to be a bool")
        pulumi.set(__self__, "install_updates_on_boot", install_updates_on_boot)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if layer_ids and not isinstance(layer_ids, list):
            raise TypeError("Expected argument 'layer_ids' to be a list")
        pulumi.set(__self__, "layer_ids", layer_ids)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if private_dns_name and not isinstance(private_dns_name, str):
            raise TypeError("Expected argument 'private_dns_name' to be a str")
        pulumi.set(__self__, "private_dns_name", private_dns_name)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_dns_name and not isinstance(public_dns_name, str):
            raise TypeError("Expected argument 'public_dns_name' to be a str")
        pulumi.set(__self__, "public_dns_name", public_dns_name)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if ssh_key_name and not isinstance(ssh_key_name, str):
            raise TypeError("Expected argument 'ssh_key_name' to be a str")
        pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[str]:
        return pulumi.get(self, "ami_id")

    @property
    @pulumi.getter
    def architecture(self) -> Optional[str]:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="elasticIps")
    def elastic_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "elastic_ips")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> Optional[bool]:
        return pulumi.get(self, "install_updates_on_boot")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="layerIds")
    def layer_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "layer_ids")

    @property
    @pulumi.getter
    def os(self) -> Optional[str]:
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> Optional[str]:
        return pulumi.get(self, "private_dns_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDnsName")
    def public_dns_name(self) -> Optional[str]:
        return pulumi.get(self, "public_dns_name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> Optional[str]:
        return pulumi.get(self, "ssh_key_name")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "volumes")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            agent_version=self.agent_version,
            ami_id=self.ami_id,
            architecture=self.architecture,
            elastic_ips=self.elastic_ips,
            hostname=self.hostname,
            id=self.id,
            install_updates_on_boot=self.install_updates_on_boot,
            instance_type=self.instance_type,
            layer_ids=self.layer_ids,
            os=self.os,
            private_dns_name=self.private_dns_name,
            private_ip=self.private_ip,
            public_dns_name=self.public_dns_name,
            public_ip=self.public_ip,
            ssh_key_name=self.ssh_key_name,
            volumes=self.volumes)


def get_instance(id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Resource Type definition for AWS::OpsWorks::Instance
    """
    __args__ = dict()
    __args__['id'] = id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:opsworks:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        agent_version=__ret__.agent_version,
        ami_id=__ret__.ami_id,
        architecture=__ret__.architecture,
        elastic_ips=__ret__.elastic_ips,
        hostname=__ret__.hostname,
        id=__ret__.id,
        install_updates_on_boot=__ret__.install_updates_on_boot,
        instance_type=__ret__.instance_type,
        layer_ids=__ret__.layer_ids,
        os=__ret__.os,
        private_dns_name=__ret__.private_dns_name,
        private_ip=__ret__.private_ip,
        public_dns_name=__ret__.public_dns_name,
        public_ip=__ret__.public_ip,
        ssh_key_name=__ret__.ssh_key_name,
        volumes=__ret__.volumes)


@_utilities.lift_output_func(get_instance)
def get_instance_output(id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Resource Type definition for AWS::OpsWorks::Instance
    """
    ...
