# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSiteResult',
    'AwaitableGetSiteResult',
    'get_site',
    'get_site_output',
]

@pulumi.output_type
class GetSiteResult:
    def __init__(__self__, description=None, location=None, site_arn=None, site_id=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if location and not isinstance(location, dict):
            raise TypeError("Expected argument 'location' to be a dict")
        pulumi.set(__self__, "location", location)
        if site_arn and not isinstance(site_arn, str):
            raise TypeError("Expected argument 'site_arn' to be a str")
        pulumi.set(__self__, "site_arn", site_arn)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the site.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional['outputs.SiteLocation']:
        """
        The location of the site.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="siteArn")
    def site_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the site.
        """
        return pulumi.get(self, "site_arn")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[str]:
        """
        The ID of the site.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.SiteTag']]:
        """
        The tags for the site.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSiteResult(GetSiteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSiteResult(
            description=self.description,
            location=self.location,
            site_arn=self.site_arn,
            site_id=self.site_id,
            tags=self.tags)


def get_site(global_network_id: Optional[str] = None,
             site_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSiteResult:
    """
    The AWS::NetworkManager::Site type describes a site.


    :param str global_network_id: The ID of the global network.
    :param str site_id: The ID of the site.
    """
    __args__ = dict()
    __args__['globalNetworkId'] = global_network_id
    __args__['siteId'] = site_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:networkmanager:getSite', __args__, opts=opts, typ=GetSiteResult).value

    return AwaitableGetSiteResult(
        description=__ret__.description,
        location=__ret__.location,
        site_arn=__ret__.site_arn,
        site_id=__ret__.site_id,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_site)
def get_site_output(global_network_id: Optional[pulumi.Input[str]] = None,
                    site_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSiteResult]:
    """
    The AWS::NetworkManager::Site type describes a site.


    :param str global_network_id: The ID of the global network.
    :param str site_id: The ID of the site.
    """
    ...
