# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InferenceSchedulerArgs', 'InferenceScheduler']

@pulumi.input_type
class InferenceSchedulerArgs:
    def __init__(__self__, *,
                 data_input_configuration: pulumi.Input['DataInputConfigurationPropertiesArgs'],
                 data_output_configuration: pulumi.Input['DataOutputConfigurationPropertiesArgs'],
                 data_upload_frequency: pulumi.Input['InferenceSchedulerDataUploadFrequency'],
                 model_name: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 data_delay_offset_in_minutes: Optional[pulumi.Input[int]] = None,
                 inference_scheduler_name: Optional[pulumi.Input[str]] = None,
                 server_side_kms_key_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InferenceSchedulerTagArgs']]]] = None):
        """
        The set of arguments for constructing a InferenceScheduler resource.
        :param pulumi.Input['DataInputConfigurationPropertiesArgs'] data_input_configuration: Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
        :param pulumi.Input['DataOutputConfigurationPropertiesArgs'] data_output_configuration: Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
        :param pulumi.Input['InferenceSchedulerDataUploadFrequency'] data_upload_frequency: How often data is uploaded to the source S3 bucket for the input data.
        :param pulumi.Input[str] model_name: The name of the previously trained ML model being used to create the inference scheduler.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
        :param pulumi.Input[int] data_delay_offset_in_minutes: A period of time (in minutes) by which inference on the data is delayed after the data starts.
        :param pulumi.Input[str] inference_scheduler_name: The name of the inference scheduler being created.
        :param pulumi.Input[str] server_side_kms_key_id: Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data by Amazon Lookout for Equipment.
        :param pulumi.Input[Sequence[pulumi.Input['InferenceSchedulerTagArgs']]] tags: Any tags associated with the inference scheduler.
        """
        pulumi.set(__self__, "data_input_configuration", data_input_configuration)
        pulumi.set(__self__, "data_output_configuration", data_output_configuration)
        pulumi.set(__self__, "data_upload_frequency", data_upload_frequency)
        pulumi.set(__self__, "model_name", model_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if data_delay_offset_in_minutes is not None:
            pulumi.set(__self__, "data_delay_offset_in_minutes", data_delay_offset_in_minutes)
        if inference_scheduler_name is not None:
            pulumi.set(__self__, "inference_scheduler_name", inference_scheduler_name)
        if server_side_kms_key_id is not None:
            pulumi.set(__self__, "server_side_kms_key_id", server_side_kms_key_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataInputConfiguration")
    def data_input_configuration(self) -> pulumi.Input['DataInputConfigurationPropertiesArgs']:
        """
        Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
        """
        return pulumi.get(self, "data_input_configuration")

    @data_input_configuration.setter
    def data_input_configuration(self, value: pulumi.Input['DataInputConfigurationPropertiesArgs']):
        pulumi.set(self, "data_input_configuration", value)

    @property
    @pulumi.getter(name="dataOutputConfiguration")
    def data_output_configuration(self) -> pulumi.Input['DataOutputConfigurationPropertiesArgs']:
        """
        Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
        """
        return pulumi.get(self, "data_output_configuration")

    @data_output_configuration.setter
    def data_output_configuration(self, value: pulumi.Input['DataOutputConfigurationPropertiesArgs']):
        pulumi.set(self, "data_output_configuration", value)

    @property
    @pulumi.getter(name="dataUploadFrequency")
    def data_upload_frequency(self) -> pulumi.Input['InferenceSchedulerDataUploadFrequency']:
        """
        How often data is uploaded to the source S3 bucket for the input data.
        """
        return pulumi.get(self, "data_upload_frequency")

    @data_upload_frequency.setter
    def data_upload_frequency(self, value: pulumi.Input['InferenceSchedulerDataUploadFrequency']):
        pulumi.set(self, "data_upload_frequency", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Input[str]:
        """
        The name of the previously trained ML model being used to create the inference scheduler.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="dataDelayOffsetInMinutes")
    def data_delay_offset_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        A period of time (in minutes) by which inference on the data is delayed after the data starts.
        """
        return pulumi.get(self, "data_delay_offset_in_minutes")

    @data_delay_offset_in_minutes.setter
    def data_delay_offset_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_delay_offset_in_minutes", value)

    @property
    @pulumi.getter(name="inferenceSchedulerName")
    def inference_scheduler_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the inference scheduler being created.
        """
        return pulumi.get(self, "inference_scheduler_name")

    @inference_scheduler_name.setter
    def inference_scheduler_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inference_scheduler_name", value)

    @property
    @pulumi.getter(name="serverSideKmsKeyId")
    def server_side_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data by Amazon Lookout for Equipment.
        """
        return pulumi.get(self, "server_side_kms_key_id")

    @server_side_kms_key_id.setter
    def server_side_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_kms_key_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InferenceSchedulerTagArgs']]]]:
        """
        Any tags associated with the inference scheduler.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InferenceSchedulerTagArgs']]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""InferenceScheduler is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class InferenceScheduler(pulumi.CustomResource):
    warnings.warn("""InferenceScheduler is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_delay_offset_in_minutes: Optional[pulumi.Input[int]] = None,
                 data_input_configuration: Optional[pulumi.Input[pulumi.InputType['DataInputConfigurationPropertiesArgs']]] = None,
                 data_output_configuration: Optional[pulumi.Input[pulumi.InputType['DataOutputConfigurationPropertiesArgs']]] = None,
                 data_upload_frequency: Optional[pulumi.Input['InferenceSchedulerDataUploadFrequency']] = None,
                 inference_scheduler_name: Optional[pulumi.Input[str]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 server_side_kms_key_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InferenceSchedulerTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource schema for LookoutEquipment InferenceScheduler.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] data_delay_offset_in_minutes: A period of time (in minutes) by which inference on the data is delayed after the data starts.
        :param pulumi.Input[pulumi.InputType['DataInputConfigurationPropertiesArgs']] data_input_configuration: Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
        :param pulumi.Input[pulumi.InputType['DataOutputConfigurationPropertiesArgs']] data_output_configuration: Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
        :param pulumi.Input['InferenceSchedulerDataUploadFrequency'] data_upload_frequency: How often data is uploaded to the source S3 bucket for the input data.
        :param pulumi.Input[str] inference_scheduler_name: The name of the inference scheduler being created.
        :param pulumi.Input[str] model_name: The name of the previously trained ML model being used to create the inference scheduler.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
        :param pulumi.Input[str] server_side_kms_key_id: Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data by Amazon Lookout for Equipment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InferenceSchedulerTagArgs']]]] tags: Any tags associated with the inference scheduler.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InferenceSchedulerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for LookoutEquipment InferenceScheduler.

        :param str resource_name: The name of the resource.
        :param InferenceSchedulerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InferenceSchedulerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_delay_offset_in_minutes: Optional[pulumi.Input[int]] = None,
                 data_input_configuration: Optional[pulumi.Input[pulumi.InputType['DataInputConfigurationPropertiesArgs']]] = None,
                 data_output_configuration: Optional[pulumi.Input[pulumi.InputType['DataOutputConfigurationPropertiesArgs']]] = None,
                 data_upload_frequency: Optional[pulumi.Input['InferenceSchedulerDataUploadFrequency']] = None,
                 inference_scheduler_name: Optional[pulumi.Input[str]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 server_side_kms_key_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InferenceSchedulerTagArgs']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""InferenceScheduler is deprecated: InferenceScheduler is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InferenceSchedulerArgs.__new__(InferenceSchedulerArgs)

            __props__.__dict__["data_delay_offset_in_minutes"] = data_delay_offset_in_minutes
            if data_input_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'data_input_configuration'")
            __props__.__dict__["data_input_configuration"] = data_input_configuration
            if data_output_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'data_output_configuration'")
            __props__.__dict__["data_output_configuration"] = data_output_configuration
            if data_upload_frequency is None and not opts.urn:
                raise TypeError("Missing required property 'data_upload_frequency'")
            __props__.__dict__["data_upload_frequency"] = data_upload_frequency
            __props__.__dict__["inference_scheduler_name"] = inference_scheduler_name
            if model_name is None and not opts.urn:
                raise TypeError("Missing required property 'model_name'")
            __props__.__dict__["model_name"] = model_name
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["server_side_kms_key_id"] = server_side_kms_key_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["inference_scheduler_arn"] = None
        super(InferenceScheduler, __self__).__init__(
            'aws-native:lookoutequipment:InferenceScheduler',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InferenceScheduler':
        """
        Get an existing InferenceScheduler resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InferenceSchedulerArgs.__new__(InferenceSchedulerArgs)

        __props__.__dict__["data_delay_offset_in_minutes"] = None
        __props__.__dict__["data_input_configuration"] = None
        __props__.__dict__["data_output_configuration"] = None
        __props__.__dict__["data_upload_frequency"] = None
        __props__.__dict__["inference_scheduler_arn"] = None
        __props__.__dict__["inference_scheduler_name"] = None
        __props__.__dict__["model_name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["server_side_kms_key_id"] = None
        __props__.__dict__["tags"] = None
        return InferenceScheduler(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataDelayOffsetInMinutes")
    def data_delay_offset_in_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        A period of time (in minutes) by which inference on the data is delayed after the data starts.
        """
        return pulumi.get(self, "data_delay_offset_in_minutes")

    @property
    @pulumi.getter(name="dataInputConfiguration")
    def data_input_configuration(self) -> pulumi.Output['outputs.DataInputConfigurationProperties']:
        """
        Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
        """
        return pulumi.get(self, "data_input_configuration")

    @property
    @pulumi.getter(name="dataOutputConfiguration")
    def data_output_configuration(self) -> pulumi.Output['outputs.DataOutputConfigurationProperties']:
        """
        Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output.
        """
        return pulumi.get(self, "data_output_configuration")

    @property
    @pulumi.getter(name="dataUploadFrequency")
    def data_upload_frequency(self) -> pulumi.Output['InferenceSchedulerDataUploadFrequency']:
        """
        How often data is uploaded to the source S3 bucket for the input data.
        """
        return pulumi.get(self, "data_upload_frequency")

    @property
    @pulumi.getter(name="inferenceSchedulerArn")
    def inference_scheduler_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the inference scheduler being created.
        """
        return pulumi.get(self, "inference_scheduler_arn")

    @property
    @pulumi.getter(name="inferenceSchedulerName")
    def inference_scheduler_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the inference scheduler being created.
        """
        return pulumi.get(self, "inference_scheduler_name")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Output[str]:
        """
        The name of the previously trained ML model being used to create the inference scheduler.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="serverSideKmsKeyId")
    def server_side_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data by Amazon Lookout for Equipment.
        """
        return pulumi.get(self, "server_side_kms_key_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.InferenceSchedulerTag']]]:
        """
        Any tags associated with the inference scheduler.
        """
        return pulumi.get(self, "tags")

