# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VersionArgs', 'Version']

@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[str],
                 code_sha256: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input['VersionProvisionedConcurrencyConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Version resource.
        """
        pulumi.set(__self__, "function_name", function_name)
        if code_sha256 is not None:
            pulumi.set(__self__, "code_sha256", code_sha256)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if provisioned_concurrency_config is not None:
            pulumi.set(__self__, "provisioned_concurrency_config", provisioned_concurrency_config)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "code_sha256")

    @code_sha256.setter
    def code_sha256(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_sha256", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> Optional[pulumi.Input['VersionProvisionedConcurrencyConfigurationArgs']]:
        return pulumi.get(self, "provisioned_concurrency_config")

    @provisioned_concurrency_config.setter
    def provisioned_concurrency_config(self, value: Optional[pulumi.Input['VersionProvisionedConcurrencyConfigurationArgs']]):
        pulumi.set(self, "provisioned_concurrency_config", value)


warnings.warn("""Version is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class Version(pulumi.CustomResource):
    warnings.warn("""Version is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_sha256: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input[pulumi.InputType['VersionProvisionedConcurrencyConfigurationArgs']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lambda::Version

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lambda::Version

        :param str resource_name: The name of the resource.
        :param VersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_sha256: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input[pulumi.InputType['VersionProvisionedConcurrencyConfigurationArgs']]] = None,
                 __props__=None):
        pulumi.log.warn("""Version is deprecated: Version is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VersionArgs.__new__(VersionArgs)

            __props__.__dict__["code_sha256"] = code_sha256
            __props__.__dict__["description"] = description
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["provisioned_concurrency_config"] = provisioned_concurrency_config
            __props__.__dict__["version"] = None
        super(Version, __self__).__init__(
            'aws-native:lambda:Version',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Version':
        """
        Get an existing Version resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VersionArgs.__new__(VersionArgs)

        __props__.__dict__["code_sha256"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["function_name"] = None
        __props__.__dict__["provisioned_concurrency_config"] = None
        __props__.__dict__["version"] = None
        return Version(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "code_sha256")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> pulumi.Output[Optional['outputs.VersionProvisionedConcurrencyConfiguration']]:
        return pulumi.get(self, "provisioned_concurrency_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "version")

