# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['NetworkAnalyzerConfigurationArgs', 'NetworkAnalyzerConfiguration']

@pulumi.input_type
class NetworkAnalyzerConfigurationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAnalyzerConfigurationTagArgs']]]] = None,
                 trace_content: Optional[pulumi.Input['TraceContentPropertiesArgs']] = None,
                 wireless_devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wireless_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a NetworkAnalyzerConfiguration resource.
        :param pulumi.Input[str] description: The description of the new resource
        :param pulumi.Input[str] name: Name of the network analyzer configuration
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAnalyzerConfigurationTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['TraceContentPropertiesArgs'] trace_content: Trace content for your wireless gateway and wireless device resources
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wireless_devices: List of wireless gateway resources that have been added to the network analyzer configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wireless_gateways: List of wireless gateway resources that have been added to the network analyzer configuration
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trace_content is not None:
            pulumi.set(__self__, "trace_content", trace_content)
        if wireless_devices is not None:
            pulumi.set(__self__, "wireless_devices", wireless_devices)
        if wireless_gateways is not None:
            pulumi.set(__self__, "wireless_gateways", wireless_gateways)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the new resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network analyzer configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAnalyzerConfigurationTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAnalyzerConfigurationTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="traceContent")
    def trace_content(self) -> Optional[pulumi.Input['TraceContentPropertiesArgs']]:
        """
        Trace content for your wireless gateway and wireless device resources
        """
        return pulumi.get(self, "trace_content")

    @trace_content.setter
    def trace_content(self, value: Optional[pulumi.Input['TraceContentPropertiesArgs']]):
        pulumi.set(self, "trace_content", value)

    @property
    @pulumi.getter(name="wirelessDevices")
    def wireless_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of wireless gateway resources that have been added to the network analyzer configuration
        """
        return pulumi.get(self, "wireless_devices")

    @wireless_devices.setter
    def wireless_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wireless_devices", value)

    @property
    @pulumi.getter(name="wirelessGateways")
    def wireless_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of wireless gateway resources that have been added to the network analyzer configuration
        """
        return pulumi.get(self, "wireless_gateways")

    @wireless_gateways.setter
    def wireless_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wireless_gateways", value)


class NetworkAnalyzerConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAnalyzerConfigurationTagArgs']]]]] = None,
                 trace_content: Optional[pulumi.Input[pulumi.InputType['TraceContentPropertiesArgs']]] = None,
                 wireless_devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wireless_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create and manage NetworkAnalyzerConfiguration resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the new resource
        :param pulumi.Input[str] name: Name of the network analyzer configuration
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAnalyzerConfigurationTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[pulumi.InputType['TraceContentPropertiesArgs']] trace_content: Trace content for your wireless gateway and wireless device resources
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wireless_devices: List of wireless gateway resources that have been added to the network analyzer configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wireless_gateways: List of wireless gateway resources that have been added to the network analyzer configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkAnalyzerConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create and manage NetworkAnalyzerConfiguration resource.

        :param str resource_name: The name of the resource.
        :param NetworkAnalyzerConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAnalyzerConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAnalyzerConfigurationTagArgs']]]]] = None,
                 trace_content: Optional[pulumi.Input[pulumi.InputType['TraceContentPropertiesArgs']]] = None,
                 wireless_devices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wireless_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAnalyzerConfigurationArgs.__new__(NetworkAnalyzerConfigurationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trace_content"] = trace_content
            __props__.__dict__["wireless_devices"] = wireless_devices
            __props__.__dict__["wireless_gateways"] = wireless_gateways
            __props__.__dict__["arn"] = None
        super(NetworkAnalyzerConfiguration, __self__).__init__(
            'aws-native:iotwireless:NetworkAnalyzerConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NetworkAnalyzerConfiguration':
        """
        Get an existing NetworkAnalyzerConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NetworkAnalyzerConfigurationArgs.__new__(NetworkAnalyzerConfigurationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["trace_content"] = None
        __props__.__dict__["wireless_devices"] = None
        __props__.__dict__["wireless_gateways"] = None
        return NetworkAnalyzerConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Arn for network analyzer configuration, Returned upon successful create.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the new resource
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the network analyzer configuration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAnalyzerConfigurationTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="traceContent")
    def trace_content(self) -> pulumi.Output[Optional['outputs.TraceContentProperties']]:
        """
        Trace content for your wireless gateway and wireless device resources
        """
        return pulumi.get(self, "trace_content")

    @property
    @pulumi.getter(name="wirelessDevices")
    def wireless_devices(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of wireless gateway resources that have been added to the network analyzer configuration
        """
        return pulumi.get(self, "wireless_devices")

    @property
    @pulumi.getter(name="wirelessGateways")
    def wireless_gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of wireless gateway resources that have been added to the network analyzer configuration
        """
        return pulumi.get(self, "wireless_gateways")

