# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    def __init__(__self__, created_at=None, dead_letter_queue_url=None, default_encryption_key=None, default_expiration_days=None, last_updated_at=None, tags=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if dead_letter_queue_url and not isinstance(dead_letter_queue_url, str):
            raise TypeError("Expected argument 'dead_letter_queue_url' to be a str")
        pulumi.set(__self__, "dead_letter_queue_url", dead_letter_queue_url)
        if default_encryption_key and not isinstance(default_encryption_key, str):
            raise TypeError("Expected argument 'default_encryption_key' to be a str")
        pulumi.set(__self__, "default_encryption_key", default_encryption_key)
        if default_expiration_days and not isinstance(default_expiration_days, int):
            raise TypeError("Expected argument 'default_expiration_days' to be a int")
        pulumi.set(__self__, "default_expiration_days", default_expiration_days)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The time of this integration got created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deadLetterQueueUrl")
    def dead_letter_queue_url(self) -> Optional[str]:
        """
        The URL of the SQS dead letter queue
        """
        return pulumi.get(self, "dead_letter_queue_url")

    @property
    @pulumi.getter(name="defaultEncryptionKey")
    def default_encryption_key(self) -> Optional[str]:
        """
        The default encryption key
        """
        return pulumi.get(self, "default_encryption_key")

    @property
    @pulumi.getter(name="defaultExpirationDays")
    def default_expiration_days(self) -> Optional[int]:
        """
        The default number of days until the data within the domain expires.
        """
        return pulumi.get(self, "default_expiration_days")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[str]:
        """
        The time of this integration got last updated at
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DomainTag']]:
        """
        The tags (keys and values) associated with the domain
        """
        return pulumi.get(self, "tags")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            created_at=self.created_at,
            dead_letter_queue_url=self.dead_letter_queue_url,
            default_encryption_key=self.default_encryption_key,
            default_expiration_days=self.default_expiration_days,
            last_updated_at=self.last_updated_at,
            tags=self.tags)


def get_domain(domain_name: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    A domain defined for 3rd party data source in Profile Service


    :param str domain_name: The unique name of the domain.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:customerprofiles:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        created_at=__ret__.created_at,
        dead_letter_queue_url=__ret__.dead_letter_queue_url,
        default_encryption_key=__ret__.default_encryption_key,
        default_expiration_days=__ret__.default_expiration_days,
        last_updated_at=__ret__.last_updated_at,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_domain)
def get_domain_output(domain_name: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainResult]:
    """
    A domain defined for 3rd party data source in Profile Service


    :param str domain_name: The unique name of the domain.
    """
    ...
