# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ProfilingGroupArgs', 'ProfilingGroup']

@pulumi.input_type
class ProfilingGroupArgs:
    def __init__(__self__, *,
                 agent_permissions: Optional[pulumi.Input['AgentPermissionsPropertiesArgs']] = None,
                 anomaly_detection_notification_configuration: Optional[pulumi.Input[Sequence[pulumi.Input['ProfilingGroupChannelArgs']]]] = None,
                 compute_platform: Optional[pulumi.Input['ProfilingGroupComputePlatform']] = None,
                 profiling_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ProfilingGroupTagArgs']]]] = None):
        """
        The set of arguments for constructing a ProfilingGroup resource.
        :param pulumi.Input['AgentPermissionsPropertiesArgs'] agent_permissions: The agent permissions attached to this profiling group.
        :param pulumi.Input[Sequence[pulumi.Input['ProfilingGroupChannelArgs']]] anomaly_detection_notification_configuration: Configuration for Notification Channels for Anomaly Detection feature in CodeGuru Profiler which enables customers to detect anomalies in the application profile for those methods that represent the highest proportion of CPU time or latency
        :param pulumi.Input['ProfilingGroupComputePlatform'] compute_platform: The compute platform of the profiling group.
        :param pulumi.Input[str] profiling_group_name: The name of the profiling group.
        :param pulumi.Input[Sequence[pulumi.Input['ProfilingGroupTagArgs']]] tags: The tags associated with a profiling group.
        """
        if agent_permissions is not None:
            pulumi.set(__self__, "agent_permissions", agent_permissions)
        if anomaly_detection_notification_configuration is not None:
            pulumi.set(__self__, "anomaly_detection_notification_configuration", anomaly_detection_notification_configuration)
        if compute_platform is not None:
            pulumi.set(__self__, "compute_platform", compute_platform)
        if profiling_group_name is not None:
            pulumi.set(__self__, "profiling_group_name", profiling_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentPermissions")
    def agent_permissions(self) -> Optional[pulumi.Input['AgentPermissionsPropertiesArgs']]:
        """
        The agent permissions attached to this profiling group.
        """
        return pulumi.get(self, "agent_permissions")

    @agent_permissions.setter
    def agent_permissions(self, value: Optional[pulumi.Input['AgentPermissionsPropertiesArgs']]):
        pulumi.set(self, "agent_permissions", value)

    @property
    @pulumi.getter(name="anomalyDetectionNotificationConfiguration")
    def anomaly_detection_notification_configuration(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfilingGroupChannelArgs']]]]:
        """
        Configuration for Notification Channels for Anomaly Detection feature in CodeGuru Profiler which enables customers to detect anomalies in the application profile for those methods that represent the highest proportion of CPU time or latency
        """
        return pulumi.get(self, "anomaly_detection_notification_configuration")

    @anomaly_detection_notification_configuration.setter
    def anomaly_detection_notification_configuration(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfilingGroupChannelArgs']]]]):
        pulumi.set(self, "anomaly_detection_notification_configuration", value)

    @property
    @pulumi.getter(name="computePlatform")
    def compute_platform(self) -> Optional[pulumi.Input['ProfilingGroupComputePlatform']]:
        """
        The compute platform of the profiling group.
        """
        return pulumi.get(self, "compute_platform")

    @compute_platform.setter
    def compute_platform(self, value: Optional[pulumi.Input['ProfilingGroupComputePlatform']]):
        pulumi.set(self, "compute_platform", value)

    @property
    @pulumi.getter(name="profilingGroupName")
    def profiling_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profiling group.
        """
        return pulumi.get(self, "profiling_group_name")

    @profiling_group_name.setter
    def profiling_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profiling_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfilingGroupTagArgs']]]]:
        """
        The tags associated with a profiling group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfilingGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)


class ProfilingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_permissions: Optional[pulumi.Input[pulumi.InputType['AgentPermissionsPropertiesArgs']]] = None,
                 anomaly_detection_notification_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfilingGroupChannelArgs']]]]] = None,
                 compute_platform: Optional[pulumi.Input['ProfilingGroupComputePlatform']] = None,
                 profiling_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfilingGroupTagArgs']]]]] = None,
                 __props__=None):
        """
        This resource schema represents the Profiling Group resource in the Amazon CodeGuru Profiler service.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AgentPermissionsPropertiesArgs']] agent_permissions: The agent permissions attached to this profiling group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfilingGroupChannelArgs']]]] anomaly_detection_notification_configuration: Configuration for Notification Channels for Anomaly Detection feature in CodeGuru Profiler which enables customers to detect anomalies in the application profile for those methods that represent the highest proportion of CPU time or latency
        :param pulumi.Input['ProfilingGroupComputePlatform'] compute_platform: The compute platform of the profiling group.
        :param pulumi.Input[str] profiling_group_name: The name of the profiling group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfilingGroupTagArgs']]]] tags: The tags associated with a profiling group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProfilingGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource schema represents the Profiling Group resource in the Amazon CodeGuru Profiler service.

        :param str resource_name: The name of the resource.
        :param ProfilingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfilingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_permissions: Optional[pulumi.Input[pulumi.InputType['AgentPermissionsPropertiesArgs']]] = None,
                 anomaly_detection_notification_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfilingGroupChannelArgs']]]]] = None,
                 compute_platform: Optional[pulumi.Input['ProfilingGroupComputePlatform']] = None,
                 profiling_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfilingGroupTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfilingGroupArgs.__new__(ProfilingGroupArgs)

            __props__.__dict__["agent_permissions"] = agent_permissions
            __props__.__dict__["anomaly_detection_notification_configuration"] = anomaly_detection_notification_configuration
            __props__.__dict__["compute_platform"] = compute_platform
            __props__.__dict__["profiling_group_name"] = profiling_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(ProfilingGroup, __self__).__init__(
            'aws-native:codeguruprofiler:ProfilingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProfilingGroup':
        """
        Get an existing ProfilingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProfilingGroupArgs.__new__(ProfilingGroupArgs)

        __props__.__dict__["agent_permissions"] = None
        __props__.__dict__["anomaly_detection_notification_configuration"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["compute_platform"] = None
        __props__.__dict__["profiling_group_name"] = None
        __props__.__dict__["tags"] = None
        return ProfilingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPermissions")
    def agent_permissions(self) -> pulumi.Output[Optional['outputs.AgentPermissionsProperties']]:
        """
        The agent permissions attached to this profiling group.
        """
        return pulumi.get(self, "agent_permissions")

    @property
    @pulumi.getter(name="anomalyDetectionNotificationConfiguration")
    def anomaly_detection_notification_configuration(self) -> pulumi.Output[Optional[Sequence['outputs.ProfilingGroupChannel']]]:
        """
        Configuration for Notification Channels for Anomaly Detection feature in CodeGuru Profiler which enables customers to detect anomalies in the application profile for those methods that represent the highest proportion of CPU time or latency
        """
        return pulumi.get(self, "anomaly_detection_notification_configuration")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the specified profiling group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computePlatform")
    def compute_platform(self) -> pulumi.Output[Optional['ProfilingGroupComputePlatform']]:
        """
        The compute platform of the profiling group.
        """
        return pulumi.get(self, "compute_platform")

    @property
    @pulumi.getter(name="profilingGroupName")
    def profiling_group_name(self) -> pulumi.Output[str]:
        """
        The name of the profiling group.
        """
        return pulumi.get(self, "profiling_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ProfilingGroupTag']]]:
        """
        The tags associated with a profiling group.
        """
        return pulumi.get(self, "tags")

