# AUTOGENERATED! DO NOT EDIT! File to edit: 01_helper.ipynb (unless otherwise specified).

__all__ = ['urlrequest', 'updatescore', 'shiftstartandduedate', 'updatepriority']

# Cell
import urllib.parse, urllib.request
import json
from urllib.parse import urlencode, quote_plus
import http.client
import time
from datetime import datetime, timedelta

# Cell
def urlrequest(url, apikey, param=None):
    req = urllib.request.Request(url)
    req.add_header("Authorization", apikey)
    resp = urllib.request.urlopen(req, timeout=200)
    responsedata = resp.read()
    data = json.loads(responsedata)
    return data

# Cell
def updatescore(fieldid, taskid, value, apikey):
    conn = http.client.HTTPSConnection("api.clickup.com")

    payload = "{\r\n  \"value\": " + value + "\r\n}"

    headers = {
        'authorization': apikey,
        'content-type': "application/json",
        'cache-control': "no-cache"
        }

    conn.request("POST", "/api/v2/task/" + taskid + "/field/" + fieldid + "/", payload, headers)

    res = conn.getresponse()
    data = res.read()
    return data.decode("utf-8")

# Cell
def shiftstartandduedate(taskid, startvalue, duevalue, aantaldagen, apikey):
    startvalue = startvalue + ((60 * 1000 * 60 * 24) * aantaldagen)
    duevalue = duevalue + ((60 * 1000 * 60 * 24) * aantaldagen)
    conn = http.client.HTTPSConnection("api.clickup.com")

    payload = "{\r\n  \"start_date\": " + str(startvalue) + ",\r\n  \"due_date\": " + str(duevalue) + "\r\n}"

    headers = {
        'authorization': apikey,
        'content-type': "application/json",
        'cache-control': "no-cache"
        }

    conn.request("PUT", "/api/v2/task/" + taskid + "/", payload, headers)

    res = conn.getresponse()
    data = res.read()
    return data.decode("utf-8")

# Cell
def updatepriority(taskid, value, apikey):
    conn = http.client.HTTPSConnection("api.clickup.com")

    payload = "{\r\n  \"priority\": " + value + "\r\n}"

    headers = {
        'authorization': apikey,
        'content-type': "application/json",
        'cache-control': "no-cache"
        }

    conn.request("PUT", "/api/v2/task/" + taskid + "/", payload, headers)

    res = conn.getresponse()
    data = res.read()
    return data.decode("utf-8")