# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['CU']

# Cell
import ClickUpShiftScore.helper as h
import time

# Cell
class CU:
    def __init__(self, _apikey):
        self.apikey = _apikey
        teamdata = h.urlrequest("https://api.clickup.com/api/v2/team", self.apikey)
        teamid = teamdata["teams"][0]["id"]
        spacedata = h.urlrequest("https://api.clickup.com/api/v2/team/" + teamid + "/space", self.apikey)
        spaceid = spacedata["spaces"][0]["id"]
        self.folderdata = h.urlrequest("https://api.clickup.com/api/v2/space/" + spaceid + "/folder", self.apikey)


    def updatetasks(self, keuze, dagen):
        t = (int(time.time()))
        for folder in self.folderdata["folders"]:
            folderid = folder["id"]
            print(folder["name"])
            listdata = h.urlrequest("https://api.clickup.com/api/v2/folder/" + folderid + "/list", self.apikey)
            for list in listdata["lists"]:
                listid = list["id"]
                taskdata = h.urlrequest("https://api.clickup.com/api/v2/list/" + listid + "/task", self.apikey)
                for task in taskdata["tasks"]:

                    try:
                        if keuze == "score":
                            if  (task["custom_fields"][4].get('value') is None) or (((t * 1000) - int(task["date_updated"])) / 1000 / 60 / 60 / 24 < dagen) :
                                score = ( ((5 - int(task["custom_fields"][0]["value"])) +
                                 (2*  int(task["custom_fields"][1]["value"]) ) +
                                (2 * int(task["custom_fields"][2]["value"])) +
                                int(task["custom_fields"][3]["value"])) / 6)
                                print('score updated for: ')
                                print(task["name"])
                                h.updatescore(task["custom_fields"][4]["id"],task["id"],str(score), self.apikey)
                        if keuze == "shift":
                            if task["status"]["status"] == "Open":
                                h.shiftstartandduedate(task["id"], int(task["start_date"]), int(task["due_date"]), dagen, self.apikey)
                        elif keuze == "priority" and ((task["priority"] == None) or (((t * 1000) - int(task["date_updated"])) / 1000 / 60 / 60 / 24 < dagen)):
                            score = ( ((5 - int(task["custom_fields"][0]["value"])) +
                                 (2*  int(task["custom_fields"][1]["value"]) ) +
                                (2 * int(task["custom_fields"][2]["value"])) +
                                int(task["custom_fields"][3]["value"])) / 6)
                            print("prio updated for: ")
                            print(task["name"])
                            if score >= 4:
                                h.updatepriority(task["id"],"1",self.apikey)
                            elif score >= 3:
                                h.updatepriority(task["id"],"2", self.apikey)
                            elif score >= 2:
                                h.updatepriority(task["id"],"3", self.apikey)
                            else:
                                h.updatepriority(task["id"],"4", self.apikey)
                    except Exception as e:
                        print(e)
                        print(task["name"])