"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainZone = void 0;
const route53 = require("aws-cdk-lib/aws-route53");
class DomainZone {
    static define(scope, props) {
        if (DomainZone.isZone(props.zone)) {
            return props.zone;
        }
        return route53.PublicHostedZone.fromLookup(scope, 'Zone', {
            domainName: props.zone,
        });
    }
    static isZone(value) {
        return (typeof value !== 'undefined'
            && typeof value !== 'string'
            && 'hostedZoneId' in value
            && 'zoneName' in value
            && 'hostedZoneArn' in value);
    }
}
exports.DomainZone = DomainZone;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvem9uZS9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtREFBbUQ7QUFPbkQsTUFBc0IsVUFBVTtJQUV2QixNQUFNLENBQUMsTUFBTSxDQUFDLEtBQWdCLEVBQUUsS0FBc0I7UUFDM0QsSUFBSSxVQUFVLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUNqQyxPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUM7U0FDbkI7UUFDRCxPQUFPLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRTtZQUN4RCxVQUFVLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDdkIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBVTtRQUM5QixPQUFPLENBQ0wsT0FBTyxLQUFLLEtBQUssV0FBVztlQUN6QixPQUFPLEtBQUssS0FBSyxRQUFRO2VBQ3pCLGNBQWMsSUFBSSxLQUFLO2VBQ3ZCLFVBQVUsSUFBSSxLQUFLO2VBQ25CLGVBQWUsSUFBSSxLQUFLLENBQzVCLENBQUM7SUFDSixDQUFDO0NBRUY7QUFyQkQsZ0NBcUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtcm91dGU1Myc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBEb21haW5ab25lUHJvcHMge1xuICB6b25lOiBzdHJpbmcgfCByb3V0ZTUzLklIb3N0ZWRab25lO1xufVxuXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgRG9tYWluWm9uZSB7XG5cbiAgcHVibGljIHN0YXRpYyBkZWZpbmUoc2NvcGU6IENvbnN0cnVjdCwgcHJvcHM6IERvbWFpblpvbmVQcm9wcyk6IHJvdXRlNTMuSUhvc3RlZFpvbmUge1xuICAgIGlmIChEb21haW5ab25lLmlzWm9uZShwcm9wcy56b25lKSkge1xuICAgICAgcmV0dXJuIHByb3BzLnpvbmU7XG4gICAgfVxuICAgIHJldHVybiByb3V0ZTUzLlB1YmxpY0hvc3RlZFpvbmUuZnJvbUxvb2t1cChzY29wZSwgJ1pvbmUnLCB7XG4gICAgICBkb21haW5OYW1lOiBwcm9wcy56b25lLFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBzdGF0aWMgaXNab25lKHZhbHVlOiBhbnkpOiB2YWx1ZSBpcyByb3V0ZTUzLklIb3N0ZWRab25lIHtcbiAgICByZXR1cm4gKFxuICAgICAgdHlwZW9mIHZhbHVlICE9PSAndW5kZWZpbmVkJ1xuICAgICAgJiYgdHlwZW9mIHZhbHVlICE9PSAnc3RyaW5nJ1xuICAgICAgJiYgJ2hvc3RlZFpvbmVJZCcgaW4gdmFsdWVcbiAgICAgICYmICd6b25lTmFtZScgaW4gdmFsdWVcbiAgICAgICYmICdob3N0ZWRab25lQXJuJyBpbiB2YWx1ZVxuICAgICk7XG4gIH1cblxufVxuIl19