"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FQDN = void 0;
const constructs_1 = require("constructs");
class FQDN extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (typeof props.subdomain !== 'string') {
            this.value = props.zone.zoneName;
            return;
        }
        // format subdomain with a trailing dot and remove double dot
        // if trailing dot was provided by user
        const subdomain = `${props.subdomain}.`.replace('..', '');
        this.value = `${subdomain}${props.zone.zoneName}`;
    }
}
exports.FQDN = FQDN;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZnFkbi9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSwyQ0FBdUM7QUFRdkMsTUFBYSxJQUFLLFNBQVEsc0JBQVM7SUFJakMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFnQjtRQUN4RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksT0FBTyxLQUFLLENBQUMsU0FBUyxLQUFLLFFBQVEsRUFBRTtZQUN2QyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQ2pDLE9BQU87U0FDUjtRQUVELDZEQUE2RDtRQUM3RCx1Q0FBdUM7UUFDdkMsTUFBTSxTQUFTLEdBQUcsR0FBRyxLQUFLLENBQUMsU0FBUyxHQUFHLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUcxRCxJQUFJLENBQUMsS0FBSyxHQUFHLEdBQUcsU0FBUyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDcEQsQ0FBQztDQUNGO0FBbkJELG9CQW1CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRlFETlByb3BzIHtcbiAgem9uZTogcm91dGU1My5JSG9zdGVkWm9uZTtcbiAgc3ViZG9tYWluPzogc3RyaW5nO1xufVxuXG5cbmV4cG9ydCBjbGFzcyBGUUROIGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBGUUROUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgaWYgKHR5cGVvZiBwcm9wcy5zdWJkb21haW4gIT09ICdzdHJpbmcnKSB7XG4gICAgICB0aGlzLnZhbHVlID0gcHJvcHMuem9uZS56b25lTmFtZTtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICAvLyBmb3JtYXQgc3ViZG9tYWluIHdpdGggYSB0cmFpbGluZyBkb3QgYW5kIHJlbW92ZSBkb3VibGUgZG90XG4gICAgLy8gaWYgdHJhaWxpbmcgZG90IHdhcyBwcm92aWRlZCBieSB1c2VyXG4gICAgY29uc3Qgc3ViZG9tYWluID0gYCR7cHJvcHMuc3ViZG9tYWlufS5gLnJlcGxhY2UoJy4uJywgJycpO1xuXG5cbiAgICB0aGlzLnZhbHVlID0gYCR7c3ViZG9tYWlufSR7cHJvcHMuem9uZS56b25lTmFtZX1gO1xuICB9XG59XG4iXX0=