import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as route53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
import { ICloudFrontConfiguration, IDomain } from './contract';
import { DomainProps } from './props';
export declare class Domain extends Construct implements IDomain {
    /**
     * Route53 hosted zone used to assign the domain into.
     */
    readonly zone: route53.IHostedZone;
    /**
     * Fully-qualified domain name.
     */
    readonly fqdn: string;
    /**
     * Certificate Manager certificate.
     */
    readonly certificate: acm.ICertificate;
    /**
     * Has IPv6 AAAA records been created.
     * Can be used to conditionally configure IPv6 support
     * to CloudFront distribution.
     */
    readonly enableIpv6: boolean;
    private region;
    private assigned;
    /**
     * Initializing a `new Domain` construct instance will lookup the Route53 hosted zone
     * and define ACM DNS-validated certificate.
     *
     * After initialization you must use `assign(alias)` method to to configure `A`/`AAAA` records
     * with the `alias` as the record value.
     */
    constructor(scope: Construct, id: string, props: DomainProps);
    /**
     * Assign an alias as record target with the fully-qualified domain name.
     * This will create both `A` & `AAAA` DNS records, unless `disableIpV6` was set to `true`
     * during initialization of `Domain` construct (resulting in only `A` record being created).
     *
     * @param alias Route53 alias record target used to assign as A/AAAA record value.
     *
     * @example
     * domain.addTarget(new targets.CloudFrontTarget(distribution))
     */
    addTarget(alias: route53.IAliasRecordTarget): void;
    /**
     * Helper method to configure CloudFront distribution with the domain,
     * certificate and IPv6 support.
     *
     * @returns CloudFront configuration for certificate, domainNames and IPv6
     */
    configureCloudFront(): ICloudFrontConfiguration;
}
