/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.zip.Deflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileWriter {
    public MatFileWriter(String fileName, Collection<MLArray> data) throws IOException {
        this(new File(fileName), data);
    }

    public MatFileWriter(File file, Collection<MLArray> data) throws IOException {
        this(new DataOutputStream(new FileOutputStream(file)), data);
    }

    public MatFileWriter(DataOutputStream output, Collection<MLArray> data) throws IOException {
        this.writeHeader(output);
        for (MLArray matrix : data) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.writeMatrix(dos, matrix);
            Deflater compresser = new Deflater();
            compresser.setInput(baos.toByteArray());
            compresser.finish();
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            byte[] buffer = new byte[128];
            int toread = 0;
            do {
                toread = compresser.deflate(buffer);
                compressed.write(buffer);
            } while (toread > 0);
            output.writeInt(15);
            output.writeInt(compressed.size());
            output.write(compressed.toByteArray());
        }
        output.close();
    }

    private void writeHeader(DataOutputStream os) throws IOException {
        MatFileHeader header = MatFileHeader.createHeader();
        char[] dest = new char[116];
        char[] src = header.getDescription().toCharArray();
        System.arraycopy(src, 0, dest, 0, src.length);
        int i = 0;
        while (i < dest.length) {
            os.writeByte(dest[i]);
            ++i;
        }
        os.write(new byte[8]);
        int version = header.getVersion();
        os.writeByte(version >> 8);
        os.writeByte(version);
        os.write(header.getEndianIndicator());
    }

    private void writeMatrix(DataOutputStream output, MLArray array) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.writeFlags(dos, array);
        this.writeDimensions(dos, array);
        this.writeName(dos, array);
        switch (array.getType()) {
            case 4: {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferDOS = new DataOutputStream(buffer);
                Character[] ac = ((MLChar)array).exportChar();
                int i = 0;
                while (i < ac.length) {
                    bufferDOS.writeByte((byte)ac[i].charValue());
                    ++i;
                }
                OSArrayTag tag = new OSArrayTag(16, buffer.toByteArray());
                tag.writeTo(dos);
                break;
            }
            case 6: {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferDOS = new DataOutputStream(buffer);
                Double[] ad = (Double[])((MLDouble)array).exportReal();
                int i = 0;
                while (i < ad.length) {
                    bufferDOS.writeDouble(ad[i]);
                    ++i;
                }
                OSArrayTag tag = new OSArrayTag(9, buffer.toByteArray());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                ad = (Double[])((MLDouble)array).exportImaginary();
                i = 0;
                while (i < ad.length) {
                    bufferDOS.writeDouble(ad[i]);
                    ++i;
                }
                tag = new OSArrayTag(9, buffer.toByteArray());
                tag.writeTo(dos);
                break;
            }
            case 2: {
                int itag = 262149;
                dos.writeInt(itag);
                dos.writeInt(((MLStructure)array).getMaxFieldLenth());
                OSArrayTag tag = new OSArrayTag(1, ((MLStructure)array).getKeySetToByteArray());
                tag.writeTo(dos);
                for (MLArray a : ((MLStructure)array).getAllFields()) {
                    this.writeMatrix(dos, a);
                }
                break;
            }
            case 1: {
                for (MLArray a : ((MLCell)array).cells()) {
                    this.writeMatrix(dos, a);
                }
                break;
            }
            case 5: {
                int i;
                int[] ai;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferDOS = new DataOutputStream(buffer);
                int[] nArray = ai = ((MLSparse)array).getIR();
                int n = ai.length;
                int n2 = 0;
                while (n2 < n) {
                    i = nArray[n2];
                    bufferDOS.writeInt(i);
                    ++n2;
                }
                OSArrayTag tag = new OSArrayTag(5, buffer.toByteArray());
                tag.writeTo(dos);
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                nArray = ai = ((MLSparse)array).getJC();
                n = ai.length;
                n2 = 0;
                while (n2 < n) {
                    i = nArray[n2];
                    bufferDOS.writeInt(i);
                    ++n2;
                }
                tag = new OSArrayTag(5, buffer.toByteArray());
                tag.writeTo(dos);
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                Double[] ad = ((MLSparse)array).exportReal();
                i = 0;
                while (i < ad.length) {
                    bufferDOS.writeDouble(ad[i]);
                    ++i;
                }
                tag = new OSArrayTag(9, buffer.toByteArray());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                ad = ((MLSparse)array).exportImaginary();
                i = 0;
                while (i < ad.length) {
                    bufferDOS.writeDouble(ad[i]);
                    ++i;
                }
                tag = new OSArrayTag(9, buffer.toByteArray());
                tag.writeTo(dos);
                break;
            }
            default: {
                throw new MatlabIOException("Cannot write matrix of type: " + MLArray.typeToString(array.getType()));
            }
        }
        output.writeInt(14);
        output.writeInt(baos.size());
        output.write(baos.toByteArray());
    }

    private void writeFlags(DataOutputStream os, MLArray array) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferDOS = new DataOutputStream(buffer);
        bufferDOS.writeInt(array.getFlags());
        if (array.isSparse()) {
            bufferDOS.writeInt(((MLSparse)array).getMaxNZ());
        } else {
            bufferDOS.writeInt(0);
        }
        OSArrayTag tag = new OSArrayTag(6, buffer.toByteArray());
        tag.writeTo(os);
    }

    private void writeDimensions(DataOutputStream os, MLArray array) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferDOS = new DataOutputStream(buffer);
        int[] dims = array.getDimensions();
        int i = 0;
        while (i < dims.length) {
            bufferDOS.writeInt(dims[i]);
            ++i;
        }
        OSArrayTag tag = new OSArrayTag(6, buffer.toByteArray());
        tag.writeTo(os);
    }

    private void writeName(DataOutputStream os, MLArray array) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferDOS = new DataOutputStream(buffer);
        byte[] nameByteArray = array.getNameToByteArray();
        buffer = new ByteArrayOutputStream();
        bufferDOS = new DataOutputStream(buffer);
        bufferDOS.write(nameByteArray);
        OSArrayTag tag = new OSArrayTag(16, buffer.toByteArray());
        tag.writeTo(os);
    }

    private class OSArrayTag
    extends MatTag {
        private byte[] data;
        private int padding;

        public OSArrayTag(int type, byte[] data) {
            super(type, data.length);
            this.data = data;
            this.padding = this.getPadding(data.length, false);
        }

        public void writeTo(DataOutputStream os) throws IOException {
            os.writeInt(this.type);
            os.writeInt(this.size);
            os.write(this.data);
            if (this.padding > 0) {
                os.write(new byte[this.padding]);
            }
        }
    }
}

