/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlPrint {
    protected final String mIndention;

    public XmlPrint() {
        this("\t");
    }

    public XmlPrint(String indention) {
        this.mIndention = indention;
    }

    public void print(Document doc) {
        this.print(doc, (OutputStream)System.out);
    }

    public void print(Document doc, OutputStream out) {
        this.print(doc, (Writer)new OutputStreamWriter(out));
    }

    public void print(Document doc, Writer writer) {
        this.print(doc, writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public void print(Document doc, PrintWriter writer) {
        this.printDeclaration(doc, writer);
        this.print(doc.getRootElement(), writer);
    }

    public void print(Element elem) {
        this.print(elem, (OutputStream)System.out);
    }

    public void print(Element elem, OutputStream out) {
        this.print(elem, (Writer)new OutputStreamWriter(out));
    }

    public void print(Element elem, Writer writer) {
        this.print(elem, writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public void print(Element elem, PrintWriter writer) {
        this.print(elem, "", writer);
    }

    public void print(Element elem, String indention, PrintWriter writer) {
        writer.print(String.valueOf(indention) + "<" + elem.getName());
        Iterator itAtt = elem.attributeIterator();
        Iterator itElem = elem.elementIterator();
        if (elem.hasMixedContent() || elem.hasContent() && !itElem.hasNext()) {
            Iterator it = elem.nodeIterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (node instanceof CharacterData) {
                    if (node instanceof Comment || node.getText().trim().length() == 0) continue;
                    throw new IllegalArgumentException("text content not supported: \"" + node.getText() + "\"");
                }
                if (node instanceof Element || node instanceof Attribute) continue;
                throw new IllegalArgumentException("only attributes and elements are supported");
            }
        }
        while (itAtt.hasNext()) {
            Attribute att = (Attribute)itAtt.next();
            String attName = att.getName();
            String attValue = att.getValue();
            writer.print(" " + attName + "=\"" + XmlPrint.escapeAttributeValue(attValue) + "\"");
        }
        if (!itElem.hasNext()) {
            writer.println("/>");
        } else {
            writer.println(">");
            while (itElem.hasNext()) {
                this.print((Element)itElem.next(), String.valueOf(indention) + this.getIndention(), writer);
            }
            writer.println(String.valueOf(indention) + "</" + elem.getName() + ">");
        }
        writer.flush();
    }

    private static String escapeAttributeValue(String value) {
        return value.replaceAll("\"", "&quot;").replaceAll("<", "&lt;");
    }

    public String toString(Document doc) {
        StringWriter sw = new StringWriter();
        this.print(doc, (Writer)sw);
        return sw.toString();
    }

    public String toString(Element elem) {
        StringWriter sw = new StringWriter();
        this.print(elem, (Writer)sw);
        return sw.toString();
    }

    protected void printDeclaration(Document doc, PrintWriter writer) {
        String encoding = doc.getXMLEncoding();
        writer.write("<?xml version=\"1.0\"");
        if (encoding == null || encoding.equals("UTF8")) {
            writer.write(" encoding=\"UTF-8\"");
        } else {
            writer.write(" encoding=\"" + encoding + "\"");
        }
        writer.write("?>");
        writer.println();
    }

    protected String getIndention() {
        return this.mIndention;
    }
}

