/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.numeric;

public class Zero {
    public static final int DEFAULT_PRECISION = 10;
    public static final double DEFAULT_TOLERANCE = 1.0E-10;
    public static final double EPS_TOLERANCE = Math.pow(2.0, -52.0);
    public final int mPrecision;
    public final double mZeroPos;
    public final double mZeroNeg;

    public Zero() {
        this(10);
    }

    public Zero(double tolerance) {
        if (Double.isNaN(tolerance) || Double.isInfinite(tolerance)) {
            throw new IllegalArgumentException("illegal tolerance: " + tolerance);
        }
        this.mZeroPos = Math.abs(tolerance);
        this.mZeroNeg = -this.mZeroPos;
        this.mPrecision = (int)Math.round(-Math.log10(this.mZeroPos));
    }

    public Zero(int precision) {
        this.mPrecision = Math.abs(precision);
        this.mZeroPos = Math.pow(10.0, -this.mPrecision);
        this.mZeroNeg = -this.mZeroPos;
    }

    public int sgn(double value) {
        if (value < this.mZeroNeg) {
            return -1;
        }
        if (value > this.mZeroPos) {
            return 1;
        }
        return 0;
    }

    public boolean isZero(double value) {
        return this.mZeroNeg <= value && value <= this.mZeroPos;
    }

    public boolean isNonZero(double value) {
        return this.mZeroNeg > value || value > this.mZeroPos;
    }

    public boolean isZeroNeg(double value) {
        return value <= this.mZeroPos;
    }

    public boolean isZeroPos(double value) {
        return value >= this.mZeroNeg;
    }

    public boolean isNegative(double value) {
        return value < this.mZeroNeg;
    }

    public boolean isPositive(double value) {
        return value > this.mZeroPos;
    }

    public boolean isNegPos(double valueA, double valueB) {
        return valueA < this.mZeroNeg && valueB > this.mZeroPos || valueB < this.mZeroNeg && valueA > this.mZeroPos;
    }

    public boolean isOne(double value) {
        return this.isZero(value - 1.0);
    }

    public boolean isInteger(double value) {
        return this.isZero(value - (double)Math.round(value));
    }

    public double roundZero(double value) {
        if (value < this.mZeroNeg || value > this.mZeroPos) {
            return value;
        }
        return 0.0;
    }

    public double roundInteger(double value) {
        long lvalue = Math.round(value);
        return this.isZero(value - (double)lvalue) ? (double)lvalue : value;
    }

    public boolean isTrueZero() {
        return this.mZeroPos == 0.0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.mZeroPos);
        return (int)(l >>> 32 ^ l & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Zero) {
            return this.mZeroPos == ((Zero)obj).mZeroPos;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + this.mZeroPos + "}";
    }
}

