/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.logging;

import ch.javasoft.util.logging.LogFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogFragmenter {
    private final Logger mLogger;
    private Level mLevel = null;

    public LogFragmenter(String logger) {
        this(Logger.getLogger(logger));
    }

    public LogFragmenter(Logger logger) {
        this.mLogger = logger;
    }

    public void start(String msg, Level level) throws IllegalStateException {
        if (this.mLevel != null) {
            throw new IllegalStateException("fragment logging already started");
        }
        this.mLevel = level;
        this.mLogger.logp(this.mLevel, null, null, msg, (Object)LogFormatter.LogParameter.FRAGMENTED_LOG_START);
    }

    public void severeStart(String msg) {
        this.start(msg, Level.SEVERE);
    }

    public void warningStart(String msg) {
        this.start(msg, Level.WARNING);
    }

    public void infoStart(String msg) {
        this.start(msg, Level.INFO);
    }

    public void configStart(String msg) {
        this.start(msg, Level.CONFIG);
    }

    public void fineStart(String msg) {
        this.start(msg, Level.FINE);
    }

    public void finerStart(String msg) {
        this.start(msg, Level.FINER);
    }

    public void finestStart(String msg) {
        this.start(msg, Level.FINEST);
    }

    public void append(String msg) {
        if (this.mLevel == null) {
            throw new IllegalStateException("fragment logging not started yet");
        }
        this.mLogger.logp(this.mLevel, null, null, msg, (Object)LogFormatter.LogParameter.FRAGMENTED_LOG_CONTINUE);
    }

    public void end() {
        this.end("");
    }

    public void end(String msg) {
        if (this.mLevel == null) {
            throw new IllegalStateException("fragment logging not started yet");
        }
        this.mLogger.logp(this.mLevel, null, null, msg, (Object)LogFormatter.LogParameter.FRAGMENTED_LOG_END);
        this.mLevel = null;
    }

    public void cleanUp() {
        if (this.mLevel != null) {
            this.end();
        }
    }

    public boolean isStarted() {
        return this.mLevel != null;
    }
}

