/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import ch.javasoft.util.Arrays;
import java.math.BigInteger;
import java.util.Comparator;

public class Unsigned {
    public static final Comparator<Long> LONG_COMPARATOR = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            return Unsigned.compare(o1, o2);
        }
    };

    public static final short getUnsigned(byte value) {
        return (short)(0xFF & value);
    }

    public static final int getUnsigned(short value) {
        return 0xFFFF & value;
    }

    public static final long getUnsigned(int value) {
        return 0xFFFFFFFFL & (long)value;
    }

    public static final BigInteger getUnsigned(long value) {
        BigInteger bigInteger;
        if (value >= 0L) {
            bigInteger = BigInteger.valueOf(value);
        } else {
            byte[] byArray = new byte[9];
            byArray[1] = (byte)(value >>> 56);
            byArray[2] = (byte)(value >>> 48);
            byArray[3] = (byte)(value >>> 40);
            byArray[4] = (byte)(value >>> 32);
            byArray[5] = (byte)(value >>> 24);
            byArray[6] = (byte)(value >>> 16);
            byArray[7] = (byte)(value >>> 8);
            byArray[8] = (byte)value;
            bigInteger = new BigInteger(byArray);
        }
        return bigInteger;
    }

    public static final int sort(long[] values) {
        int npos;
        int rots;
        int len = values.length;
        java.util.Arrays.sort(values, 0, len);
        int nneg = java.util.Arrays.binarySearch(values, 0L);
        if (nneg < 0) {
            nneg = -(nneg + 1);
        }
        int rfrom = (rots = nneg - (npos = len - nneg)) >= 0 ? 0 : nneg;
        int rto = rots >= 0 ? nneg : len;
        Arrays.rotate(values, rots, rfrom, rto);
        int swaps = rots >= 0 ? npos : nneg;
        int i = 0;
        while (i < swaps) {
            Arrays.swap(values, i, len - swaps + i);
            ++i;
        }
        return npos;
    }

    public static int binarySearch(long[] a, long key) {
        return Unsigned.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        return Unsigned.binarySearch0(a, fromIndex, toIndex, key);
    }

    private static int binarySearch0(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            int cmp = Unsigned.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static final int compare(long l1, long l2) {
        if (l1 >= 0L && l2 >= 0L || l1 < 0L && l2 < 0L) {
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }
        return l1 < 0L ? 1 : -1;
    }

    private Unsigned() {
    }
}

