/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import ch.javasoft.util.Timer;
import java.util.Arrays;
import java.util.Random;

public class Sort {
    private static final int maxQuiSort = 512;
    private static final int maxCpySort = 2048;

    public static void sort(int[] arr) {
        Sort.sort(arr, 512, 2048);
    }

    public static void sortCountSwap(int[] arr) {
        Sort.sort(arr, 0, 0);
    }

    public static void sortCountCopy(int[] arr) {
        Sort.sort(arr, 0, Integer.MAX_VALUE);
    }

    public static void sortQuick(int[] arr) {
        Sort.sort(arr, Integer.MAX_VALUE, 0);
    }

    private static void sort(int[] arr, int maxQuiSort, int maxCpySort) {
        int andNeg = -1;
        int andPos = -1;
        int orNeg = 0;
        int orPos = 0;
        int start = 0;
        int end = arr.length;
        while (start < end) {
            if (arr[start] < 0) {
                andNeg &= arr[start];
                orNeg |= arr[start];
                ++start;
            }
            if (arr[end - 1] >= 0) {
                andPos &= arr[--end];
                orPos |= arr[end];
            }
            if (start >= end || arr[start] < 0 || arr[end - 1] >= 0) continue;
            int tmp = arr[--end];
            arr[end] = arr[start];
            arr[start] = tmp;
            andNeg &= arr[start];
            orNeg |= arr[start];
            andPos &= arr[end];
            orPos |= arr[end];
            ++start;
        }
        int xorNeg = andNeg ^ orNeg;
        int xorPos = andPos ^ orPos;
        if (start > 1) {
            if (start < maxQuiSort) {
                Arrays.sort(arr, 0, start);
            } else if (start < maxCpySort) {
                Sort.sort00to07cpy(arr, 0, start, xorNeg);
            } else {
                Sort.sort30to24(arr, 0, start, true, xorNeg);
            }
        }
        if (arr.length - start > 1) {
            if (arr.length - start < maxQuiSort) {
                Arrays.sort(arr, start, arr.length);
            } else if (arr.length - start < maxCpySort) {
                Sort.sort00to07cpy(arr, start, arr.length, xorPos);
            } else {
                Sort.sort30to24(arr, start, arr.length, false, xorPos);
            }
        }
    }

    private static void sort30to20(int[] arr, int start, int end, boolean neg) {
        int[] counts = new int[2048];
        int ii = start;
        while (ii < end) {
            int pos;
            int n = pos = arr[ii] >> 20 & 0x7FF;
            counts[n] = counts[n] + 1;
            ++ii;
        }
        counts[0] = counts[0] + start;
        ii = 1;
        while (ii < 2048) {
            counts[ii] = counts[ii] + counts[ii - 1];
            ++ii;
        }
        int[] ccounts = (int[])counts.clone();
        int index = end - 1;
        while (index >= start) {
            int pos;
            if (arr[index] < 0 != neg) {
                arr[index] = arr[index] ^ Integer.MIN_VALUE;
                --index;
                continue;
            }
            int n = pos = arr[index] >> 20 & 0x7FF;
            counts[n] = counts[n] - 1;
            if (counts[pos] < index) {
                int tmp = arr[counts[pos]];
                arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                arr[index] = tmp;
                continue;
            }
            arr[counts[pos]] = arr[index];
            if (counts[pos] != index) continue;
            --index;
        }
        int ii2 = 0;
        while (ii2 < 2048) {
            int pEnd = ccounts[ii2];
            int pStart = ii2 == 0 ? start : ccounts[ii2 - 1];
            if (pEnd - pStart > 1) {
                Sort.sort19to10(arr, pStart, pEnd, neg);
            }
            if (pEnd == end) break;
            ++ii2;
        }
    }

    private static void sort19to10(int[] arr, int start, int end, boolean neg) {
        int[] counts = new int[1024];
        int ii = start;
        while (ii < end) {
            int pos;
            int n = pos = arr[ii] >> 10 & 0x3FF;
            counts[n] = counts[n] + 1;
            ++ii;
        }
        counts[0] = counts[0] + start;
        ii = 1;
        while (ii < 1024) {
            counts[ii] = counts[ii] + counts[ii - 1];
            ++ii;
        }
        int[] ccounts = (int[])counts.clone();
        int index = end - 1;
        while (index >= start) {
            int pos;
            if (arr[index] < 0 != neg) {
                arr[index] = arr[index] ^ Integer.MIN_VALUE;
                --index;
                continue;
            }
            int n = pos = arr[index] >> 10 & 0x3FF;
            counts[n] = counts[n] - 1;
            if (counts[pos] < index) {
                int tmp = arr[counts[pos]];
                arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                arr[index] = tmp;
                continue;
            }
            arr[counts[pos]] = arr[index];
            if (counts[pos] != index) continue;
            --index;
        }
        int ii2 = 0;
        while (ii2 < 1024) {
            int pEnd = ccounts[ii2];
            int pStart = ii2 == 0 ? start : ccounts[ii2 - 1];
            if (pEnd - pStart > 1) {
                Sort.sort09to00(arr, pStart, pEnd, neg);
            }
            if (pEnd == end) break;
            ++ii2;
        }
    }

    private static void sort09to00(int[] arr, int start, int end, boolean neg) {
        int pos;
        int[] counts = new int[1024];
        int ii = start;
        while (ii < end) {
            int n = pos = arr[ii] & 0x3FF;
            counts[n] = counts[n] + 1;
            ++ii;
        }
        counts[0] = counts[0] + start;
        ii = 1;
        while (ii < 1024) {
            counts[ii] = counts[ii] + counts[ii - 1];
            ++ii;
        }
        int index = end - 1;
        while (index >= start) {
            if (arr[index] < 0 != neg) {
                arr[index] = arr[index] ^ Integer.MIN_VALUE;
                --index;
                continue;
            }
            int n = pos = arr[index] & 0x3FF;
            counts[n] = counts[n] - 1;
            if (counts[pos] < index) {
                int tmp = arr[counts[pos]];
                arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                arr[index] = tmp;
                continue;
            }
            arr[counts[pos]] = arr[index];
            if (counts[pos] != index) continue;
            --index;
        }
    }

    private static void sort30to24(int[] arr, int start, int end, boolean neg, int xor) {
        if ((xor & 0xFF000000) != 0) {
            int and = -1;
            int or = 0;
            int[] counts = new int[128];
            int ii = start;
            while (ii < end) {
                int pos;
                int n = pos = arr[ii] >> 24 & 0x7F;
                counts[n] = counts[n] + 1;
                and &= arr[ii];
                or |= arr[ii];
                ++ii;
            }
            xor = and ^ or;
            counts[0] = counts[0] + start;
            ii = 1;
            while (ii < 128) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int[] ccounts = (int[])counts.clone();
            int index = end - 1;
            while (index >= start) {
                int pos;
                if (arr[index] < 0 != neg) {
                    arr[index] = arr[index] ^ Integer.MIN_VALUE;
                    --index;
                    continue;
                }
                int n = pos = arr[index] >> 24 & 0x7F;
                counts[n] = counts[n] - 1;
                if (counts[pos] < index) {
                    int tmp = arr[counts[pos]];
                    arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                    arr[index] = tmp;
                    continue;
                }
                arr[counts[pos]] = arr[index];
                if (counts[pos] != index) continue;
                --index;
            }
            int ii2 = 0;
            while (ii2 < 128) {
                int pEnd = ccounts[ii2];
                int pStart = ii2 == 0 ? start : ccounts[ii2 - 1];
                if (pEnd - pStart > 1) {
                    if (pEnd - pStart < 512) {
                        Arrays.sort(arr, pStart, pEnd);
                    } else if (pEnd - pStart < 2048) {
                        Sort.sort00to07cpy(arr, pStart, pEnd, xor & 0xFFFFFF);
                    } else {
                        Sort.sort23to16(arr, pStart, pEnd, neg, xor & 0xFFFFFF);
                    }
                }
                if (pEnd != end) {
                    ++ii2;
                    continue;
                }
                break;
            }
        } else {
            Sort.sort23to16(arr, start, end, neg, xor & 0xFFFFFF);
        }
    }

    private static void sort23to16(int[] arr, int start, int end, boolean neg, int xor) {
        if ((xor & 0xFF0000) != 0) {
            int and = -1;
            int or = 0;
            int[] counts = new int[256];
            int ii = start;
            while (ii < end) {
                int pos;
                int n = pos = arr[ii] >> 16 & 0xFF;
                counts[n] = counts[n] + 1;
                and &= arr[ii];
                or |= arr[ii];
                ++ii;
            }
            xor = and ^ or;
            counts[0] = counts[0] + start;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int[] ccounts = (int[])counts.clone();
            int index = end - 1;
            while (index >= start) {
                int pos;
                if (arr[index] < 0 != neg) {
                    arr[index] = arr[index] ^ Integer.MIN_VALUE;
                    --index;
                    continue;
                }
                int n = pos = arr[index] >> 16 & 0xFF;
                counts[n] = counts[n] - 1;
                if (counts[pos] < index) {
                    int tmp = arr[counts[pos]];
                    arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                    arr[index] = tmp;
                    continue;
                }
                arr[counts[pos]] = arr[index];
                if (counts[pos] != index) continue;
                --index;
            }
            int ii2 = 0;
            while (ii2 < 256) {
                int pEnd = ccounts[ii2];
                int pStart = ii2 == 0 ? start : ccounts[ii2 - 1];
                if (pEnd - pStart > 1) {
                    if (pEnd - pStart < 512) {
                        Arrays.sort(arr, pStart, pEnd);
                    } else if (pEnd - pStart < 2048) {
                        Sort.sort00to07cpy(arr, pStart, pEnd, xor & 0xFFFF);
                    } else {
                        Sort.sort15to08(arr, pStart, pEnd, neg, xor & 0xFFFF);
                    }
                }
                if (pEnd != end) {
                    ++ii2;
                    continue;
                }
                break;
            }
        } else {
            Sort.sort15to08(arr, start, end, neg, xor & 0xFFFF);
        }
    }

    private static void sort15to08(int[] arr, int start, int end, boolean neg, int xor) {
        if ((xor & 0xFF00) != 0) {
            int and = -1;
            int or = 0;
            int[] counts = new int[256];
            int ii = start;
            while (ii < end) {
                int pos;
                int n = pos = arr[ii] >> 8 & 0xFF;
                counts[n] = counts[n] + 1;
                and &= arr[ii];
                or |= arr[ii];
                ++ii;
            }
            xor = and ^ or;
            counts[0] = counts[0] + start;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int[] ccounts = (int[])counts.clone();
            int index = end - 1;
            while (index >= start) {
                int pos;
                if (arr[index] < 0 != neg) {
                    arr[index] = arr[index] ^ Integer.MIN_VALUE;
                    --index;
                    continue;
                }
                int n = pos = arr[index] >> 8 & 0xFF;
                counts[n] = counts[n] - 1;
                if (counts[pos] < index) {
                    int tmp = arr[counts[pos]];
                    arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                    arr[index] = tmp;
                    continue;
                }
                arr[counts[pos]] = arr[index];
                if (counts[pos] != index) continue;
                --index;
            }
            int ii2 = 0;
            while (ii2 < 256) {
                int pEnd = ccounts[ii2];
                int pStart = ii2 == 0 ? start : ccounts[ii2 - 1];
                if (pEnd - pStart > 1) {
                    if (pEnd - pStart < 512) {
                        Arrays.sort(arr, pStart, pEnd);
                    } else if (pEnd - pStart < 2048) {
                        Sort.sort00to07cpy(arr, pStart, pEnd, xor & 0xFF);
                    } else {
                        Sort.sort07to00(arr, pStart, pEnd, neg, xor & 0xFF);
                    }
                }
                if (pEnd != end) {
                    ++ii2;
                    continue;
                }
                break;
            }
        } else {
            Sort.sort07to00(arr, start, end, neg, xor & 0xFF);
        }
    }

    private static void sort07to00(int[] arr, int start, int end, boolean neg, int xor) {
        if ((xor & 0xFF) != 0) {
            int pos;
            int[] counts = new int[256];
            int ii = start;
            while (ii < end) {
                int n = pos = arr[ii] & 0xFF;
                counts[n] = counts[n] + 1;
                ++ii;
            }
            counts[0] = counts[0] + start;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int index = end - 1;
            while (index >= start) {
                if (arr[index] < 0 != neg) {
                    arr[index] = arr[index] ^ Integer.MIN_VALUE;
                    --index;
                    continue;
                }
                int n = pos = arr[index] & 0xFF;
                counts[n] = counts[n] - 1;
                if (counts[pos] < index) {
                    int tmp = arr[counts[pos]];
                    arr[counts[pos]] = arr[index] ^ Integer.MIN_VALUE;
                    arr[index] = tmp;
                    continue;
                }
                arr[counts[pos]] = arr[index];
                if (counts[pos] != index) continue;
                --index;
            }
        }
    }

    private static void sort00to07cpy(int[] arr, int start, int end, int xor) {
        int[] dst = new int[end - start];
        if (1 == Sort.sort00to07cpy(arr, dst, start, end, 0, end - start, xor)) {
            System.arraycopy(dst, 0, arr, start, end - start);
        }
    }

    private static int sort00to07cpy(int[] src, int[] dst, int srcStart, int srcEnd, int dstStart, int dstEnd, int xor) {
        if ((xor & 0xFF) != 0) {
            int pos;
            int[] counts = new int[256];
            int ii = srcStart;
            while (ii < srcEnd) {
                int n = pos = src[ii] & 0xFF;
                counts[n] = counts[n] + 1;
                ++ii;
            }
            counts[0] = counts[0] + dstStart;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int i = srcEnd - 1;
            while (i >= srcStart) {
                int n = pos = src[i] & 0xFF;
                counts[n] = counts[n] - 1;
                dst[counts[pos]] = src[i];
                --i;
            }
            return (1 + Sort.sort08to17cpy(dst, src, dstStart, dstEnd, srcStart, srcEnd, xor)) % 2;
        }
        return Sort.sort08to17cpy(src, dst, srcStart, srcEnd, dstStart, dstEnd, xor);
    }

    private static void sort08to17cpy(int[] arr, int start, int end, int xor) {
        int[] dst = new int[end - start];
        if (1 == Sort.sort08to17cpy(arr, dst, start, end, 0, end - start, xor)) {
            System.arraycopy(dst, 0, arr, start, end - start);
        }
    }

    private static int sort08to17cpy(int[] src, int[] dst, int srcStart, int srcEnd, int dstStart, int dstEnd, int xor) {
        if ((xor & 0xFF00) != 0) {
            int pos;
            int[] counts = new int[256];
            int ii = srcStart;
            while (ii < srcEnd) {
                int n = pos = src[ii] >> 8 & 0xFF;
                counts[n] = counts[n] + 1;
                ++ii;
            }
            counts[0] = counts[0] + dstStart;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int i = srcEnd - 1;
            while (i >= srcStart) {
                int n = pos = src[i] >> 8 & 0xFF;
                counts[n] = counts[n] - 1;
                dst[counts[pos]] = src[i];
                --i;
            }
            return (1 + Sort.sort16to23cpy(dst, src, dstStart, dstEnd, srcStart, srcEnd, xor)) % 2;
        }
        return Sort.sort16to23cpy(src, dst, srcStart, srcEnd, dstStart, dstEnd, xor);
    }

    private static void sort16to23cpy(int[] arr, int start, int end, int xor) {
        int[] dst = new int[end - start];
        if (1 == Sort.sort16to23cpy(arr, dst, start, end, 0, end - start, xor)) {
            System.arraycopy(dst, 0, arr, start, end - start);
        }
    }

    private static int sort16to23cpy(int[] src, int[] dst, int srcStart, int srcEnd, int dstStart, int dstEnd, int xor) {
        if ((xor & 0xFF0000) != 0) {
            int pos;
            int[] counts = new int[256];
            int ii = srcStart;
            while (ii < srcEnd) {
                int n = pos = src[ii] >> 16 & 0xFF;
                counts[n] = counts[n] + 1;
                ++ii;
            }
            counts[0] = counts[0] + dstStart;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int i = srcEnd - 1;
            while (i >= srcStart) {
                int n = pos = src[i] >> 16 & 0xFF;
                counts[n] = counts[n] - 1;
                dst[counts[pos]] = src[i];
                --i;
            }
            return (1 + Sort.sort24to30cpy(dst, src, dstStart, dstEnd, srcStart, srcEnd, xor)) % 2;
        }
        return Sort.sort24to30cpy(src, dst, srcStart, srcEnd, dstStart, dstEnd, xor);
    }

    private static void sort24to30cpy(int[] arr, int start, int end, int xor) {
        int[] dst = new int[end - start];
        if (1 == Sort.sort24to30cpy(arr, dst, start, end, 0, end - start, xor)) {
            System.arraycopy(dst, 0, arr, start, end - start);
        }
    }

    private static int sort24to30cpy(int[] src, int[] dst, int srcStart, int srcEnd, int dstStart, int dstEnd, int xor) {
        if ((xor & 0xFF000000) != 0) {
            int pos;
            int[] counts = new int[256];
            int ii = srcStart;
            while (ii < srcEnd) {
                int n = pos = src[ii] >> 24 & 0xFF;
                counts[n] = counts[n] + 1;
                ++ii;
            }
            counts[0] = counts[0] + dstStart;
            ii = 1;
            while (ii < 256) {
                counts[ii] = counts[ii] + counts[ii - 1];
                ++ii;
            }
            int i = srcEnd - 1;
            while (i >= srcStart) {
                int n = pos = src[i] >> 24 & 0xFF;
                counts[n] = counts[n] - 1;
                dst[counts[pos]] = src[i];
                --i;
            }
            return 1;
        }
        return 0;
    }

    public static void bitQuickSort(int[] arr) {
        int and = -1;
        int or = 0;
        int i = 0;
        while (i < arr.length) {
            and &= arr[i];
            or |= arr[i];
            ++i;
        }
        int bit = 31 - Integer.numberOfLeadingZeros(and ^ or);
        if (bit >= 0) {
            Sort.bitQuickSort(arr, 0, arr.length, bit);
        }
    }

    private static void bitQuickSort(int[] arr, int start, int end, int bit) {
        int mask = -1 >>> 32 - bit;
        int and = -1;
        int or = 0;
        int pBit = 1 << bit;
        int eBit = bit == 31 ? 0 : pBit;
        int lastStart = start;
        int lastEnd = end;
        while (start < end) {
            if ((arr[start] & pBit) != eBit) {
                and &= arr[start];
                or |= arr[start];
                ++start;
            }
            if ((arr[end - 1] & pBit) == eBit) {
                and &= arr[--end];
                or |= arr[end];
            }
            if (start >= end || (arr[start] & pBit) != eBit || (arr[end - 1] & pBit) == eBit) continue;
            int tmp = arr[--end];
            arr[end] = arr[start];
            arr[start] = tmp;
            and &= arr[start];
            or |= arr[start];
            and &= arr[end];
            or |= arr[end];
            ++start;
        }
        if (start != end) {
            throw new RuntimeException();
        }
        bit = 31 - Integer.numberOfLeadingZeros(mask & (and ^ or));
        if (bit >= 0) {
            if (lastStart < start) {
                Sort.bitQuickSort(arr, lastStart, start, bit);
            }
            if (start < lastEnd) {
                Sort.bitQuickSort(arr, start, lastEnd, bit);
            }
        }
    }

    public static void main(String[] args) {
        int cnt = 10000000;
        int dif = 1000;
        Random rnd = new Random();
        int[] templates = new int[1000];
        int i = 0;
        while (i < templates.length) {
            templates[i] = rnd.nextInt();
            ++i;
        }
        int[] vals = new int[10000000];
        int ii = 0;
        while (ii < vals.length) {
            vals[ii] = rnd.nextInt();
            ++ii;
        }
        Timer timer = new Timer();
        timer.start();
        Arrays.sort(vals);
        timer.stop();
        System.out.println(timer.getString());
        int ii2 = 1;
        while (ii2 < vals.length) {
            if (vals[ii2] < vals[ii2 - 1]) {
                throw new InternalError("wrong: " + vals[ii2 - 1] + ", " + vals[ii2]);
            }
            ++ii2;
        }
    }

    private Sort() {
    }
}

