/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import ch.javasoft.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredListCollection<E>
implements Collection<E> {
    private final BitSet unselected = new BitSet();
    private final List<E> unfiltered;
    private final ThreadLocal<Boolean> flag = new ThreadLocal();

    public FilteredListCollection(List<E> unfiltered) {
        this.unfiltered = unfiltered;
    }

    public List<E> getUnfilteredList() {
        return this.unfiltered;
    }

    public boolean isSelected(int unfilteredIndex) {
        if (unfilteredIndex < 0 || unfilteredIndex > this.unfiltered.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(unfilteredIndex));
        }
        return !this.unselected.get(unfilteredIndex);
    }

    public void setSelected(int unfilteredIndex, boolean selected) {
        if (unfilteredIndex < 0 || unfilteredIndex > this.unfiltered.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(unfilteredIndex));
        }
        this.unselected.set(unfilteredIndex, !selected);
    }

    public void selectAll() {
        this.unselected.clear();
    }

    public void unselectAll() {
        this.unselected.set(0, this.unfiltered.size());
    }

    @Override
    public boolean add(E o) {
        return this.unfiltered.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.unfiltered.addAll(c);
    }

    @Override
    public void clear() {
        this.unfiltered.clear();
    }

    @Override
    public boolean contains(Object o) {
        int index = this.unfiltered.indexOf(o);
        return index >= 0 && !this.unselected.get(index);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean cfr_ignored_0 = o instanceof FilteredListCollection;
        if (this.flag.get() == null) {
            this.flag.set(Boolean.TRUE);
            boolean result = o.equals(this);
            this.flag.remove();
            return result;
        }
        this.flag.remove();
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int size = this.unfiltered.size();
        int i = this.unselected.nextClearBit(0);
        while (i < size) {
            E obj = this.unfiltered.get(i);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            i = this.unselected.nextClearBit(i + 1);
        }
        return hashCode;
    }

    @Override
    public boolean isEmpty() {
        int len = this.unselected.length();
        return this.unfiltered.size() == len && this.unselected.nextClearBit(0) == len;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int remove = -1;
            int index;
            {
                this.index = FilteredListCollection.this.unselected.nextClearBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.index < FilteredListCollection.this.unfiltered.size();
            }

            @Override
            public E next() {
                if (this.index < FilteredListCollection.this.unfiltered.size()) {
                    int last = this.index;
                    this.index = FilteredListCollection.this.unselected.nextClearBit(last + 1);
                    return FilteredListCollection.this.unfiltered.get(last);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.remove >= 0) {
                    FilteredListCollection.this.unfiltered.remove(this.remove);
                    --this.index;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        int index = this.unfiltered.indexOf(o);
        if (index >= 0) {
            int last;
            if (this.unselected.get(index) && index != (last = this.unfiltered.lastIndexOf(o))) {
                int first = index + 1;
                index = -1;
                int i = first;
                while (i <= last && index < 0) {
                    if (!this.unselected.get(i) && FilteredListCollection.eq(o, this.unfiltered.get(i))) {
                        index = i;
                    }
                    ++i;
                }
            }
            if (index >= 0) {
                this.unfiltered.remove(index);
                int len = this.unselected.length();
                int i = index + 1;
                while (i < len) {
                    this.unselected.set(i - 1, this.unselected.get(i));
                    ++i;
                }
                this.unselected.clear(len - 1);
                return true;
            }
        }
        return false;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean any = false;
        for (Object o : c) {
            boolean removed = this.remove(o);
            any |= removed;
            while (removed) {
                removed = this.remove(o);
            }
        }
        return any;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean any = false;
        int i = 0;
        while (i < this.unfiltered.size()) {
            E o;
            if (!this.unselected.get(i) && !c.contains(o = this.unfiltered.get(i))) {
                any |= this.remove(o);
            }
            ++i;
        }
        return any;
    }

    @Override
    public int size() {
        return this.unfiltered.size() - this.unselected.cardinality();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a == null) {
            a = new Object[size];
        } else if (a.length < size) {
            a = Arrays.newArray(a, size);
        }
        Object[] arr = a;
        int index = 0;
        int i = this.unselected.nextClearBit(0);
        while (i < size) {
            arr[index++] = this.unfiltered.get(i);
            i = this.unselected.nextClearBit(i + 1);
        }
        return a;
    }
}

