/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import ch.javasoft.util.Arrays;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArray
implements Iterable<Byte>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6523901146842278626L;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static final int DEFAULT_CAPACITY = 7;
    private int mLength = 0;
    private byte[] mArray;

    public ByteArray() {
        this(7);
    }

    public ByteArray(int capacity) {
        this.mArray = new byte[capacity];
        this.initialize(this.mArray, 0, capacity, false);
    }

    public ByteArray(byte[] initialValues) {
        this.mArray = initialValues;
        this.mLength = initialValues.length;
    }

    public ByteArray(byte[] original, int from, int to) {
        this.mArray = Arrays.copyOfRange(original, from, to);
        this.mLength = to - from;
    }

    public int length() {
        return this.mLength;
    }

    public boolean isEmpty() {
        return this.mLength == 0;
    }

    public byte get(int index) throws IndexOutOfBoundsException {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index not in [0, " + (this.mLength - 1) + "]: " + index);
        }
        return this.mArray[index];
    }

    public int indexOf(byte value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int fromIndex, byte value) {
        int i = fromIndex;
        while (i < this.mLength) {
            if (value == this.mArray[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public byte set(int index, byte value) throws IndexOutOfBoundsException {
        byte old;
        if (index >= this.mLength) {
            this.ensureCapacity(index + 1);
            old = this.initialValue();
        } else {
            old = this.mArray[index];
        }
        this.mArray[index] = value;
        this.mLength = Math.max(this.mLength, index + 1);
        return old;
    }

    public void add(byte value) {
        this.set(this.mLength, value);
    }

    public void addAll(ByteArray array) {
        this.addAll(0, this.mLength, array.mArray);
    }

    public void addAll(int from, int to, ByteArray array) {
        if (to > array.mLength) {
            throw new IndexOutOfBoundsException("to index after length: " + to + " > " + array.mLength);
        }
        this.addAll(from, to, array.mArray);
    }

    public void addAll(byte ... values) {
        this.addAll(0, values.length, values);
    }

    public void addAll(int from, int to, byte ... values) {
        if (from < 0) {
            throw new IndexOutOfBoundsException("from must be non-negative: " + from);
        }
        if (to < from) {
            throw new IndexOutOfBoundsException("to must not be smaller than from: " + to + " < " + from);
        }
        this.ensureCapacity(this.mLength + to - from);
        System.arraycopy(values, from, this.mArray, this.mLength, to - from);
        this.mLength += to - from;
    }

    public boolean add(int index, byte value) {
        if (index < 0 || index > this.mLength) {
            throw new IndexOutOfBoundsException("index must be >=0 and <= length, but was " + index);
        }
        this.ensureCapacity(this.mLength + 1);
        System.arraycopy(this.mArray, index, this.mArray, index + 1, this.mLength - index);
        this.mArray[index] = value;
        ++this.mLength;
        return true;
    }

    public byte removeLast() {
        return this.remove(this.mLength - 1);
    }

    public byte remove(int index) {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index not in [0, " + (this.mLength - 1) + "]: " + index);
        }
        byte old = this.mArray[index];
        --this.mLength;
        System.arraycopy(this.mArray, index + 1, this.mArray, index, this.mLength - index);
        return old;
    }

    public void clear() {
        this.initialize(this.mArray, 0, this.mLength, true);
        this.mLength = 0;
    }

    public byte first() {
        return this.get(0);
    }

    public byte last() {
        return this.get(this.mLength - 1);
    }

    public void swap(int indexA, int indexB) {
        if (indexA < 0 || indexA >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexA + " not in [0, " + (this.mLength - 1) + "]");
        }
        if (indexB < 0 || indexB >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexB + " not in [0, " + (this.mLength - 1) + "]");
        }
        byte tmp = this.mArray[indexA];
        this.mArray[indexA] = this.mArray[indexB];
        this.mArray[indexB] = tmp;
    }

    protected void ensureCapacity(int size) {
        if (size >= this.mArray.length) {
            int newSize = Math.max(size, this.mArray.length * 2);
            byte[] newArr = new byte[newSize];
            System.arraycopy(this.mArray, 0, newArr, 0, this.mLength);
            this.initialize(newArr, this.mLength, newSize, false);
            this.mArray = newArr;
        }
    }

    protected byte initialValue() {
        return 0;
    }

    private void initialize(byte[] array, int from, int to, boolean force) {
        byte initialValue = this.initialValue();
        if ((force || initialValue != 0) && from < to) {
            java.util.Arrays.fill(array, from, to, initialValue);
        }
    }

    public byte[] toArray() {
        byte[] arr = new byte[this.mLength];
        System.arraycopy(this.mArray, 0, arr, 0, this.mLength);
        return arr;
    }

    public byte[] yieldArray() {
        this.trimToLength();
        byte[] arr = this.mArray;
        this.mArray = new byte[7];
        this.initialize(this.mArray, 0, 7, false);
        this.mLength = 0;
        return arr;
    }

    public ByteArray clone() {
        return new ByteArray(this.mArray, 0, this.mLength);
    }

    public ByteArray subRange(int from) {
        return this.subRange(from, this.mLength);
    }

    public ByteArray subRange(int from, int to) {
        return new ByteArray(this.mArray, from, to);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ByteArray.this.length();
            }

            @Override
            public Byte next() {
                return ByteArray.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("immutable iterator");
            }
        };
    }

    public static byte[][] toMatrix(ByteArray[] mx) {
        byte[][] res = new byte[mx.length][];
        int i = 0;
        while (i < mx.length) {
            res[i] = mx[i].toArray();
            ++i;
        }
        return res;
    }

    public static byte[][] toMatrix(Collection<ByteArray> mx) {
        byte[][] res = new byte[mx.size()][];
        int ri = 0;
        for (ByteArray row : mx) {
            res[ri++] = row.toArray();
        }
        return res;
    }

    public static byte[][] toMatrix(Collection<byte[]> mx, boolean cloneArrays) {
        byte[][] res = new byte[mx.size()][];
        int ri = 0;
        if (cloneArrays) {
            for (byte[] row : mx) {
                res[ri++] = (byte[])row.clone();
            }
        } else {
            for (byte[] row : mx) {
                res[ri++] = row;
            }
        }
        return res;
    }

    public static void swap(byte[] arr, int indexA, int indexB) {
        byte tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static byte[][] clone(byte[][] arr) {
        byte[][] clone = new byte[arr.length][];
        int i = 0;
        while (i < clone.length) {
            int len = arr[i].length;
            clone[i] = new byte[len];
            System.arraycopy(arr[i], 0, clone[i], 0, len);
            ++i;
        }
        return clone;
    }

    public void trimToLength() {
        if (this.mLength < this.mArray.length) {
            byte[] arr = new byte[this.mLength];
            System.arraycopy(this.mArray, 0, arr, 0, this.mLength);
            this.mArray = arr;
        }
    }

    public int binarySearch(byte key) throws IllegalStateException {
        return this.binarySearch(key, 0, this.mLength);
    }

    public int binarySearch(byte key, int fromIndex, int toIndex) throws IllegalStateException {
        return Arrays.binarySearch(this.mArray, fromIndex, toIndex, key);
    }

    public int addToSorted(byte value) {
        int pos = this.binarySearch(value);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        this.add(pos, value);
        return pos;
    }

    public void sort(boolean ascending) {
        this.sort(ascending, 0, this.mLength);
    }

    public void sort(boolean ascending, int start, int end) {
        java.util.Arrays.sort(this.mArray, start, end);
        if (!ascending) {
            int ii = start;
            while (ii < end / 2) {
                byte tmp = this.mArray[ii];
                this.mArray[ii] = this.mArray[end - ii - 1];
                this.mArray[end - ii - 1] = tmp;
                ++ii;
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.mLength) {
            byte val = this.mArray[i];
            hash ^= val;
            hash ^= val >>> 32;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteArray) {
            ByteArray other = (ByteArray)obj;
            if (this.mLength != other.mLength) {
                return false;
            }
            int i = 0;
            while (i < this.mLength) {
                if (this.mArray[i] != other.mArray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int ii = 0;
        while (ii < this.mLength) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mArray[ii]);
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }
}

