/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.util;

import ch.javasoft.smx.iface.MatrixBase;

public class DimensionCheck {
    public static void checkEqualDimensions(MatrixBase mxA, MatrixBase mxB) throws IllegalArgumentException {
        DimensionCheck.checkEqualRowCount(mxA, mxB);
        DimensionCheck.checkEqualColumnCount(mxA, mxB);
    }

    public static void checkEqualRowCount(MatrixBase mxA, MatrixBase mxB) throws IllegalArgumentException {
        if (mxA.getRowCount() != mxB.getRowCount()) {
            throw new IllegalArgumentException("number of rows are not equal for matrices: " + mxA.getRowCount() + " != " + mxB.getRowCount());
        }
    }

    public static void checkEqualColumnCount(MatrixBase mxA, MatrixBase mxB) throws IllegalArgumentException {
        if (mxA.getColumnCount() != mxB.getColumnCount()) {
            throw new IllegalArgumentException("number of columns are not equal for matrices: " + mxA.getColumnCount() + " != " + mxB.getColumnCount());
        }
    }

    public static void checkTransposeDimensions(MatrixBase src, MatrixBase dst) throws IllegalArgumentException {
        if (src.getColumnCount() != dst.getRowCount()) {
            throw new IllegalArgumentException("dimension missmatch for matrix transposition: src.columnCount (" + src.getColumnCount() + ") != dst.rowCount (" + dst.getRowCount() + ")");
        }
        if (dst.getColumnCount() != src.getRowCount()) {
            throw new IllegalArgumentException("dimension missmatch for matrix transposition: dst.columnCount (" + dst.getColumnCount() + ") != src.rowCount (" + src.getRowCount() + ")");
        }
    }

    public static void checkMulDimensions(MatrixBase srcA, MatrixBase srcB, MatrixBase dst) throws IllegalArgumentException {
        if (srcA.getColumnCount() != srcB.getRowCount()) {
            throw new IllegalArgumentException("dimension missmatch for matrix multiplication: srcA.columnCount (" + srcA.getColumnCount() + ") != srcB.rowCount (" + srcB.getRowCount() + ")");
        }
        if (srcA.getRowCount() != dst.getRowCount()) {
            throw new IllegalArgumentException("dimension missmatch for matrix multiplication: srcA.rowCount (" + srcA.getRowCount() + ") != dst.rowCount (" + dst.getRowCount() + ")");
        }
        if (srcB.getColumnCount() != dst.getColumnCount()) {
            throw new IllegalArgumentException("dimension missmatch for matrix multiplication: srcB.columnCount (" + srcB.getColumnCount() + ") != dst.columnCount (" + dst.getColumnCount() + ")");
        }
    }

    public static void checkSqareDimensions(MatrixBase mx) throws IllegalArgumentException {
        if (mx.getRowCount() != mx.getColumnCount()) {
            throw new IllegalArgumentException("not a square matrix: " + mx.getRowCount() + " != " + mx.getColumnCount());
        }
    }
}

