/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.matrix;

import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.ops.ExtendedMatrixOperations;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedDoubleOperations
implements ExtendedMatrixOperations<Double, Double> {
    private final Zero zero;
    private final Gauss gauss;

    public ExtendedDoubleOperations(Zero zero) {
        this.zero = zero;
        this.gauss = new Gauss(zero.mZeroPos);
    }

    public ExtendedDoubleOperations(double tolerance) {
        this(new Zero(tolerance));
    }

    public Zero getZero() {
        return this.zero;
    }

    public Gauss getGauss() {
        return this.gauss;
    }

    @Override
    public int rank(ReadableMatrix<Double> mx) {
        if (mx instanceof ReadableDoubleMatrix) {
            return this.gauss.rank((ReadableDoubleMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public int nullity(ReadableMatrix<Double> mx) {
        if (mx instanceof ReadableDoubleMatrix) {
            return this.gauss.nullity((ReadableDoubleMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<Double> invert(ReadableMatrix<Double> mx) {
        if (mx instanceof ReadableDoubleMatrix) {
            return this.gauss.invert((ReadableDoubleMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<Double> nullspace(ReadableMatrix<Double> mx) {
        if (mx instanceof ReadableDoubleMatrix) {
            return this.gauss.nullspace((ReadableDoubleMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

