/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.util.DimensionCheck;
import java.math.BigInteger;

public class Transpose {
    public static IntMatrix transpose(ReadableIntMatrix src) {
        DefaultIntMatrix dst = new DefaultIntMatrix(src.getColumnCount(), src.getRowCount());
        Transpose.transpose(src, dst);
        return dst;
    }

    public static void transpose(ReadableIntMatrix src, WritableIntMatrix dst) {
        DimensionCheck.checkTransposeDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        if (src == dst) {
            int row = 0;
            while (row < rows) {
                int col = row + 1;
                while (col < cols) {
                    int valA = src.getIntValueAt(row, col);
                    int valB = src.getIntValueAt(col, row);
                    dst.setValueAt(col, row, valA);
                    dst.setValueAt(row, col, valB);
                    ++col;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    dst.setValueAt(col, row, src.getIntValueAt(row, col));
                    ++col;
                }
                ++row;
            }
        }
    }

    public static IntRationalMatrix transpose(ReadableIntRationalMatrix src) {
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(src.getColumnCount(), src.getRowCount());
        Transpose.transpose(src, dst);
        return dst;
    }

    public static void transpose(ReadableIntRationalMatrix src, WritableIntRationalMatrix dst) {
        DimensionCheck.checkTransposeDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        if (src == dst) {
            int row = 0;
            while (row < rows) {
                int col = row + 1;
                while (col < cols) {
                    int numeratorA = src.getIntNumeratorAt(row, col);
                    int denominatorA = src.getIntDenominatorAt(row, col);
                    int numeratorB = src.getIntNumeratorAt(col, row);
                    int denominatorB = src.getIntDenominatorAt(col, row);
                    dst.setValueAt(col, row, numeratorA, denominatorA);
                    dst.setValueAt(row, col, numeratorB, denominatorB);
                    ++col;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    dst.setValueAt(col, row, src.getIntNumeratorAt(row, col), src.getIntDenominatorAt(row, col));
                    ++col;
                }
                ++row;
            }
        }
    }

    public static BigIntegerRationalMatrix transpose(ReadableBigIntegerRationalMatrix src) {
        DefaultBigIntegerRationalMatrix dst = new DefaultBigIntegerRationalMatrix(src.getColumnCount(), src.getRowCount());
        Transpose.transpose(src, dst);
        return dst;
    }

    public static void transpose(ReadableBigIntegerRationalMatrix src, WritableBigIntegerRationalMatrix dst) {
        DimensionCheck.checkTransposeDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        if (src == dst) {
            int row = 0;
            while (row < rows) {
                int col = row + 1;
                while (col < cols) {
                    BigInteger numeratorA = src.getBigIntegerNumeratorAt(row, col);
                    BigInteger denominatorA = src.getBigIntegerDenominatorAt(row, col);
                    BigInteger numeratorB = src.getBigIntegerNumeratorAt(col, row);
                    BigInteger denominatorB = src.getBigIntegerDenominatorAt(col, row);
                    dst.setValueAt(col, row, numeratorA, denominatorA);
                    dst.setValueAt(row, col, numeratorB, denominatorB);
                    ++col;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    dst.setValueAt(col, row, src.getBigIntegerNumeratorAt(row, col), src.getBigIntegerDenominatorAt(row, col));
                    ++col;
                }
                ++row;
            }
        }
    }

    public static DoubleMatrix transpose(ReadableDoubleMatrix src) {
        if (src.getRowCount() == 0 || src.getColumnCount() == 0) {
            return src.toDoubleMatrix(true);
        }
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(src.getColumnCount(), src.getRowCount());
        Transpose.transpose(src, dst);
        return dst;
    }

    public static void transpose(ReadableDoubleMatrix src, WritableDoubleMatrix dst) {
        DimensionCheck.checkTransposeDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        if (src == dst) {
            int row = 0;
            while (row < rows) {
                int col = row + 1;
                while (col < cols) {
                    double valueA = src.getDoubleValueAt(row, col);
                    double valueB = src.getDoubleValueAt(col, row);
                    dst.setValueAt(col, row, valueA);
                    dst.setValueAt(row, col, valueB);
                    ++col;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    dst.setValueAt(col, row, src.getDoubleValueAt(row, col));
                    ++col;
                }
                ++row;
            }
        }
    }

    private Transpose() {
    }
}

